package com.elitesland.fin.infr.repo.arorder;


import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.arorder.QArOrderDtlDO;


import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:41
 */
@Component
@RequiredArgsConstructor
public class ArOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;

    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 总单Id
        if (null != arOrderDtlPageParam.getMasId()) {
            predicates.add(qArOrderDtlDO.masId.eq(arOrderDtlPageParam.getMasId()));
        }
        if (CollectionUtils.isNotEmpty(arOrderDtlPageParam.getMasIds())) {
            predicates.add(qArOrderDtlDO.masId.in(arOrderDtlPageParam.getMasIds()));
        }
        predicates.add(qArOrderDtlDO.deleteFlag.eq(0));
        JPAQuery<ArOrderDtlDTO> query = select(ArOrderDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        arOrderDtlPageParam.setPaging(query);
        arOrderDtlPageParam.fillOrders(query, qArOrderDtlDO);

        return PagingVO.<ArOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArOrderDtlDO.id,
                qArOrderDtlDO.sourceNo,
                qArOrderDtlDO.masId,
                qArOrderDtlDO.sourceLine,
                qArOrderDtlDO.itemId,
                qArOrderDtlDO.itemCode,
                qArOrderDtlDO.itemName,
                qArOrderDtlDO.itemType,
                qArOrderDtlDO.smallCateCode,
                qArOrderDtlDO.smallCateName,
                qArOrderDtlDO.uom,
                qArOrderDtlDO.uomName,
                qArOrderDtlDO.qty,
                qArOrderDtlDO.exclTaxPrice,
                qArOrderDtlDO.price,
                qArOrderDtlDO.taxRate,
                qArOrderDtlDO.totalAmt,
                qArOrderDtlDO.exclTaxAmt,
                qArOrderDtlDO.taxAmt,
                qArOrderDtlDO.totalCurAmt,
                qArOrderDtlDO.exclTaxCurAmt,
                qArOrderDtlDO.taxCurAmt,
                qArOrderDtlDO.remark,
                qArOrderDtlDO.buCode,
                qArOrderDtlDO.buId,
                qArOrderDtlDO.buName,
                qArOrderDtlDO.expensesType,
                qArOrderDtlDO.relateId,
                qArOrderDtlDO.es11,
                qArOrderDtlDO.es12,
                qArOrderDtlDO.es13,
                qArOrderDtlDO.es14,
                qArOrderDtlDO.es15,
                qArOrderDtlDO.es16,
                qArOrderDtlDO.es17,
                qArOrderDtlDO.es18,
                qArOrderDtlDO.es19,
                qArOrderDtlDO.es20,
                qArOrderDtlDO.es21,
                qArOrderDtlDO.es22,
                qArOrderDtlDO.es23,
                qArOrderDtlDO.es24,
                qArOrderDtlDO.docType,
                qArOrderDtlDO.docType2,
                qArOrderDtlDO.docCls,
                qArOrderDtlDO.verAmt,
                qArOrderDtlDO.unVerAmt,
                qArOrderDtlDO.applyVerAmTing,
                qArOrderDtlDO.protocolCode
        )).from(qArOrderDtlDO);
    }


    public List<Long> findBySourceId(String sourceId) {
        List<Long> res = jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }
    public List<Long> findUnverBySourceId(ArOrderPageParam arOrderPageParam) {
        String sourceId = arOrderPageParam.getSourceNoDtl();
        // 总单Id
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(sourceId)) {
            predicates.add(qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"));
        }
        predicates.add(qArOrderDtlDO.deleteFlag.eq(0));
        if(StringUtils.isNotBlank(arOrderPageParam.getWriteOfFAmtCon())){
            if(FinConstant.WRITE_OFF_AMT_CON_GT.equals(arOrderPageParam.getWriteOfFAmtCon())){
                predicates.add(qArOrderDtlDO.unVerAmt.gt(BigDecimal.ZERO));
            }else if(FinConstant.WRITE_OFF_AMT_CON_LT.equals(arOrderPageParam.getWriteOfFAmtCon())){
                predicates.add(qArOrderDtlDO.unVerAmt.lt(BigDecimal.ZERO));
            }
        }else{
            predicates.add(qArOrderDtlDO.unVerAmt.ne(BigDecimal.ZERO));
        }
        return jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }
    public List<BigDecimal> countByMasId(Long id) {
        return jpaQueryFactory.select(qArOrderDtlDO.qty)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.eq(id))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.update(qArOrderDtlDO)
                .set(qArOrderDtlDO.deleteFlag, 1)
                .where(qArOrderDtlDO.masId.in(ids))
                .execute();
        return res;
    }

    public void delByMasId(List<Long> id) {
        jpaQueryFactory.delete(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.in(id))
                .execute();
    }
    @SysCodeProc
    public List<ArOrderDtlDTO> listByMisId(Long masId) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.masId.eq(masId))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

    @SysCodeProc
    public List<ArOrderDtlDTO> listByMasIds(Collection<Long> ids) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.masId.in(ids))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }
}
