package com.elitesland.fin.rpc.ystsupp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.support.provider.org.dto.OrgOuComRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgOuComRpcParam;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class RmiOrgOuRpcServiceServiceImpl implements RmiOrgOuRpcServiceService{

    private final OrgOuRpcService orgOuRpcService;

    @Override
    public List<OrgOuRpcDTO> findOuDtoByParam(OrgOuRpcDtoParam param) {
        List<OrgOuRpcDTO> orgOuRpcDTOList = orgOuRpcService.findOuDtoByParam(param);
        Assert.notNull(orgOuRpcDTOList, "查询公司信息失败");
        return orgOuRpcDTOList;
    }

    public List<OrgOuComRpcDTO> findOuDtoByParam(OrgOuComRpcParam param) {
        log.info("findOuDtoByParam param:{}", JSONUtil.toJsonStr(param));
        List<OrgOuComRpcDTO> data = orgOuRpcService.selectComOuByParam(param);
        log.info("findOuDtoByParam data:{}", JSONUtil.toJsonStr(data));
        return data;
    }


    /**
     * 查询公司基础信息接口
     *
     * @param ouCodes 公司编号
     * @return
     */
    @Override
    public List<OrgOuRpcSimpleDTO> findBaseOuByCodes(List<String> ouCodes) {
        if (CollectionUtil.isEmpty(ouCodes)) {
            return Collections.EMPTY_LIST;
        }
        try {

           List<OrgOuRpcSimpleDTO> orgOuRpcSimpleDTOList = orgOuRpcService.findSimpleByOuCodes(ouCodes);
            if (CollectionUtil.isNotEmpty(orgOuRpcSimpleDTOList)) {
                return orgOuRpcSimpleDTOList;
            }
        } catch (Exception e) {
            log.error("findBaseOuByCodes error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用基础中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,OrgOuRpcSimpleDTO> findBaseOuMapByCodes(List<String> ouCodes) {

        List<OrgOuRpcSimpleDTO> rpcDTOList = this.findBaseOuByCodes(ouCodes);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, OrgOuRpcSimpleDTO> ouMap = rpcDTOList.stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, t -> t, (t1, t2) -> t1));

        return ouMap;

    }

}
