package com.elitesland.fin.rpc.ystsupp;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/14
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RmiOrgStoreRpcServiceServiceImpl implements RmiOrgStoreRpcServiceService{
    private final OrgStoreRpcService orgStoreRpcService;


    /**
     * 查询门店基础信息接口
     *
     * @param storeCodeList 公司编号
     * @return
     */
    @Override
    public List<OrgStoreBaseRpcDTO> findBaseStoreByCodes(List<String> storeCodeList) {
        if (CollectionUtil.isEmpty(storeCodeList)) {
            return Collections.EMPTY_LIST;
        }
        try {
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setStoreCodeList(storeCodeList);
            ApiResult<List<OrgStoreBaseRpcDTO>> apiResult = orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam);
            if (apiResult.isSuccess()) {
                List<OrgStoreBaseRpcDTO> rpcDTOList = apiResult.getData();
                if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                    return rpcDTOList;
                }
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用基础域(findOrgStoreBaseByParam)查询门店失败：" + apiResult.getErrorMsg());
            }

        } catch (Exception e) {
            log.error("findBaseOuByCodes error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用基础中心dubbo服务异常：" + e);
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,OrgStoreBaseRpcDTO> findBaseStoreMapByCodes(List<String> storeCodeList) {

        List<OrgStoreBaseRpcDTO> rpcDTOList = this.findBaseStoreByCodes(storeCodeList);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, OrgStoreBaseRpcDTO> ouMap = rpcDTOList.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getStoreCode, t -> t, (t1, t2) -> t1));

        return ouMap;

    }
}
