/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.data.util.Pair;

public class AmountRoundConverter
extends Converter<BigDecimal, BigDecimal, Pair<Integer, RoundingMode>> {
    private static final SystemRpcService systemRpcService = (SystemRpcService)SpringContextHolder.getBean(SystemRpcService.class);

    @Override
    public BigDecimal convert(BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if (this.baseValue == null) {
            return value;
        }
        Integer scale = (Integer)((Pair)this.baseValue).getFirst();
        RoundingMode roundingMode = (RoundingMode)((Object)((Pair)this.baseValue).getSecond());
        return NumberUtils.toScaledBigDecimal((BigDecimal)value, (int)scale, (RoundingMode)roundingMode);
    }

    @Override
    public synchronized Pair<Integer, RoundingMode> initBaseValue() {
        this.baseValue = this.setAmountAccuracyBySettingService();
        return this.baseValue;
    }

    @Override
    public synchronized Pair<Integer, RoundingMode> refreshBaseValue() {
        this.baseValue = this.setAmountAccuracyBySettingService();
        return this.baseValue;
    }

    private Pair<Integer, RoundingMode> setAmountAccuracyBySettingService() {
        SysSettingVO amountDecimalPlace = systemRpcService.findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        SysSettingVO amountRoundingModeValue = systemRpcService.findSysSettingByNo("AMOUNT_ROUNDING_MODE_VALUE");
        int scale = 0;
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (amountDecimalPlace != null && amountDecimalPlace.getSettingVal() != null && !amountDecimalPlace.getSettingVal().equals("")) {
            scale = Integer.parseInt(amountDecimalPlace.getSettingVal());
        }
        if (amountRoundingModeValue != null && amountRoundingModeValue.getSettingVal() != null && !amountRoundingModeValue.getSettingVal().equals("")) {
            roundingMode = RoundingMode.valueOf(Integer.parseInt(amountRoundingModeValue.getSettingVal()));
        }
        return Pair.of((Object)scale, (Object)((Object)roundingMode));
    }
}

