/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.vo.baseInfo.BaseCustRelateInfoVO;
import com.elitesland.fin.application.facade.vo.baseInfo.BaseSupplyRelateInfoVO;
import com.elitesland.fin.application.service.InfoBaseService;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InfoBaseServiceImpl
implements InfoBaseService {
    private static final Logger log = LoggerFactory.getLogger(InfoBaseServiceImpl.class);
    private final PurSuppOutService purSuppOutService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RmiSaleRpcService rmiSaleRpcService;

    @Override
    public BaseCustRelateInfoVO getCustRelateInfo(String custCode) {
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Collections.singletonList(custCode));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)custBaseDTO));
        BaseCustRelateInfoVO baseCustRelateInfoVO = new BaseCustRelateInfoVO();
        baseCustRelateInfoVO.setInOutCust(custBaseDTO.getInOutCust());
        if (!"C".equals(custBaseDTO.getCustType2())) {
            log.info("\u975e\u5185\u90e8\u5ba2\u6237:{}", (Object)custCode);
            return baseCustRelateInfoVO;
        }
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u7f16\u7801:{}", (Object)corBusinCode);
        if (StrUtil.isBlank((CharSequence)corBusinCode)) {
            throw new BusinessException("\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        baseCustRelateInfoVO.setTaxpayerType(orgOuRpcSimpleDTO.getTaxpayerType());
        baseCustRelateInfoVO.setId(orgOuRpcSimpleDTO.getId());
        baseCustRelateInfoVO.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        baseCustRelateInfoVO.setOuName(orgOuRpcSimpleDTO.getOuName());
        baseCustRelateInfoVO.setBuId(orgOuRpcSimpleDTO.getBuId());
        baseCustRelateInfoVO.setBuCode(orgOuRpcSimpleDTO.getBuCode());
        baseCustRelateInfoVO.setBuName(orgOuRpcSimpleDTO.getBuName());
        return baseCustRelateInfoVO;
    }

    @Override
    public BaseSupplyRelateInfoVO getSupplyRelateInfo(String suppCode) {
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(Arrays.asList(suppCode));
        List<PurSuppBaseRpcDTO> baseSuppByParam = this.purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new BusinessException("\u516c\u53f8\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        log.info("\u4f9b\u5e94\u5546\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)purSuppBaseRpcDTO));
        BaseSupplyRelateInfoVO baseSupplyRelateInfoVO = new BaseSupplyRelateInfoVO();
        baseSupplyRelateInfoVO.setInOutCust(purSuppBaseRpcDTO.getIoType());
        if (!"INNER".equals(purSuppBaseRpcDTO.getSuppType2())) {
            log.info("\u975e\u5185\u90e8\u4f9b\u5e94\u5546:{}", (Object)suppCode);
            return baseSupplyRelateInfoVO;
        }
        String ouCode2 = purSuppBaseRpcDTO.getOuCode2();
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(ouCode2));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u5173\u8054\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        baseSupplyRelateInfoVO.setTaxpayerType(orgOuRpcSimpleDTO.getTaxpayerType());
        baseSupplyRelateInfoVO.setId(orgOuRpcSimpleDTO.getId());
        baseSupplyRelateInfoVO.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        baseSupplyRelateInfoVO.setOuName(orgOuRpcSimpleDTO.getOuName());
        baseSupplyRelateInfoVO.setBuId(orgOuRpcSimpleDTO.getBuId());
        baseSupplyRelateInfoVO.setBuCode(orgOuRpcSimpleDTO.getBuCode());
        baseSupplyRelateInfoVO.setBuName(orgOuRpcSimpleDTO.getBuName());
        return baseSupplyRelateInfoVO;
    }

    public InfoBaseServiceImpl(PurSuppOutService purSuppOutService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, RmiSaleRpcService rmiSaleRpcService) {
        this.purSuppOutService = purSuppOutService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.rmiSaleRpcService = rmiSaleRpcService;
    }
}

