/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ApOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.repo.writeoff.ApOrderDetailRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ApOrderServiceImpl
implements ApOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderServiceImpl.class);
    private final ApOrderDomainService apOrderDomainService;
    private final WorkflowRpcService workflowRpcService;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDetailRepoProc apOrderDetailRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @SysCodeProc
    public PagingVO<ApOrderVO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        if (res != null && CollectionUtils.isNotEmpty((Collection)res.getRecords())) {
            List<Long> masIds = res.getRecords().stream().map(ApOrderVO::getId).collect(Collectors.toList());
            List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(masIds);
            Map apOrderDtlDTOMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
            List<String> relevanceOuCodeList = res.getRecords().stream().map(ApOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
            res.getRecords().stream().forEach(v -> {
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                List arOrderDtlDTOS1 = (List)apOrderDtlDTOMap.get(v.getId());
                if (CollUtil.isNotEmpty((Collection)arOrderDtlDTOS1)) {
                    for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                        if (null != apOrderDtlDTO.getVerAmt()) {
                            verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                        }
                        if (apOrderDtlDTO.getApplyVerAmTing() != null) {
                            verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                        }
                        if (apOrderDtlDTO.getUnVerAmt() == null) continue;
                        unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                    }
                }
                v.setVerAmt(verAmt);
                v.setApplyVerAmTing(verAmting);
                v.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        List<Long> apOrderIdList = res.getRecords().stream().map(ApOrderVO::getId).distinct().collect(Collectors.toList());
        Map<Long, List<ApOrderDtlDTO>> detialMap = this.apOrderDtlRepoProc.listByMasIds(apOrderIdList).stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId));
        res.getRecords().forEach(x -> x.setInvoicePriceVariance(((List)detialMap.get(x.getId())).stream().filter(e -> e.getInvoicePriceVariance() != null).map(ApOrderDtlDTO::getInvoicePriceVariance).reduce(BigDecimal.ZERO, BigDecimal::add)));
        this.flexFieldUtilService.handleFlexFieldShowNameForVO("AP_ORDER", res.getRecords());
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<ApOrderVO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.writeoffPage(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        if (res.isEmpty()) {
            return res;
        }
        List<Long> masIds = res.getRecords().stream().map(ApOrderVO::getId).collect(Collectors.toList());
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(masIds);
        Map apOrderDtlDTOMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
        List<String> relevanceOuCodeList = res.getRecords().stream().map(ApOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        res.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List arOrderDtlDTOS1 = (List)apOrderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)arOrderDtlDTOS1)) {
                for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                    verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return res;
    }

    @Override
    @SysCodeProc
    public ApOrderVO get(Long id) {
        Map<String, OrgOuRpcSimpleDTO> ouMap;
        OrgOuRpcSimpleDTO ouRpcSimpleDTO;
        ReceiptPaymentAgreementVO agreementVO;
        ApOrderDTO apOrderDTO = this.apOrderDomainService.get(id);
        Map<String, ReceiptPaymentAgreementVO> agreementMap = this.receiptPaymentAgreementDomainService.selectPaymentAgreementByCodes(Collections.singletonList(apOrderDTO.getProtocolCode()));
        if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(apOrderDTO.getProtocolCode()) && Objects.nonNull(agreementVO = agreementMap.get(apOrderDTO.getProtocolCode()))) {
            apOrderDTO.setProtocolName(agreementVO.getProtocolName());
        }
        if (Objects.nonNull(ouRpcSimpleDTO = (ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(apOrderDTO.getRelevanceOuCode()))).get(apOrderDTO.getRelevanceOuCode()))) {
            apOrderDTO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setInvoicePriceVariance(apOrderDtlDTOS.stream().filter(e -> e.getInvoicePriceVariance() != null).map(ApOrderDtlDTO::getInvoicePriceVariance).reduce(BigDecimal.ZERO, BigDecimal::add));
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("AP_ORDER", (CustomFieldBaseModelVo)res);
        return res;
    }

    @Override
    public List<ApOrderVO> getBatch(List<Long> ids) {
        List<ApOrderDTO> apOrderDTOS = this.apOrderDomainService.queryByIds(ids);
        return ApOrderConvert.INSTANCE.convertList(apOrderDTOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.apOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.apOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ApOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        if (CollUtil.isNotEmpty(apOrder.getApOrderDtlGroupList())) {
            apOrder.getApOrderDtlGroupList().forEach(e -> e.setInvoicePriceVariance(BigDecimal.ZERO));
        }
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> commit(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long resId = this.apOrderDomainService.commit(apOrder);
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u4ed8\u5355\u5ba1\u6838-" + apOrder.getApOrderNo();
            String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.apOrderDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApOrderVO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.getApOrderAndDtl(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        this.flexFieldUtilService.handleSingleFlexFieldShowNameForVO("AP_ORDER", (CustomFieldBaseModelVo)res);
        return res;
    }

    @Override
    @SysCodeProc
    public void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u91c7\u8d2d\u7ed3\u7b97\u5355", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write((OutputStream)response.getOutputStream(), ApOrderVO.class).sheet("\u91c7\u8d2d\u7ed3\u7b97\u5355").doWrite(res.getRecords());
        }
        catch (IOException e) {
            log.error("\u91c7\u8d2d\u7ed3\u7b97\u5355\u5bfc\u51fa\u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
        }
    }

    @Override
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        this.apOrderDomainService.restDocState(ids);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Long> redPunch(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.get(id);
        this.checkRedPunch(apOrderDTO);
        ApOrder apOrder = this.apOrderDomainService.redPunchCreate(id);
        apOrder.setCheck(false);
        return this.commit(ApOrderConvert.INSTANCE.convertParam(apOrder));
    }

    void checkRedPunch(ApOrderDTO apOrderDTO) {
        if (Objects.isNull(apOrderDTO)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(apOrderDTO.getRedState())) {
            throw new BusinessException("\u5355\u636e\u5df2\u7ea2\u51b2");
        }
        if (Objects.nonNull(apOrderDTO.getRedSourceNo())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u4e3a\u7ea2\u51b2\u5355\u636e");
        }
        if (BigDecimal.ZERO.compareTo(apOrderDTO.getVerAmt()) != 0) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDTO.getOrderState())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
        }
        if (!apOrderDTO.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u53ea\u5141\u8bb8\u7ea2\u51b2\u624b\u5de5\u751f\u6210\u7684\u5e94\u4ed8\u5355");
        }
    }

    private void checkVerAmtEqualZero(long id) {
        BigDecimal verAmt;
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(apOrderDtlDTOS) && !BigDecimal.ZERO.equals(verAmt = apOrderDtlDTOS.stream().map(ApOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add))) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u4e3a0");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long apDId, BigDecimal amt) {
        ApOrderDtlDO detail = this.findDetail(apDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    @NotNull
    private ApOrderDtlDO findDetail(Long arDId) {
        ApOrderDtlDO detail = this.apOrderDetailRepoProc.getApOrderDetailAmt(arDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + arDId));
        return detail;
    }

    private void doUpdateVerAmt(ApOrderAmtUpdateDTO update) {
        if (this.apOrderDetailRepoProc.updateVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getAuditDataVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long apDId, BigDecimal amt, String verType) {
        ApOrderDtlDO detail = this.findDetail(apDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @NotNull
    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    @Override
    public List<ApOrderDtlVO> listApOrderDetail(FinApOrderDetailQuery query) {
        return this.apOrderDetailRepoProc.listArOrderDetail(query);
    }

    public ApOrderServiceImpl(ApOrderDomainService apOrderDomainService, WorkflowRpcService workflowRpcService, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDetailRepoProc apOrderDetailRepoProc, FlexFieldUtilService flexFieldUtilService, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.apOrderDomainService = apOrderDomainService;
        this.workflowRpcService = workflowRpcService;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDetailRepoProc = apOrderDetailRepoProc;
        this.flexFieldUtilService = flexFieldUtilService;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

