/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccountflow;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountIocService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountRuleConfigService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.application.service.unionpay.entity.constant.Constants;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.creditAccountFlow.CreditAccountFlowDomainService;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.redisson.RedissonRedLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CreditAccountFlowServiceImpl
implements CreditAccountFlowService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountFlowServiceImpl.class);
    @Autowired
    private CreditAccountFlowRepo creditAccountFlowRepo;
    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;
    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;
    @Autowired
    private CreditAccountRepo creditAccountRepo;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    @Autowired
    private AccountRuleConfigRepo accountRuleConfigRepo;
    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;
    @Autowired
    private CreditAccountService creditAccountService;
    @Autowired
    private FinSalMqProcessor finSalMqProcessor;
    @Autowired
    private CreditAccountIocService creditAccountIocService;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private CreditAccountRuleConfigService creditAccountRuleConfigService;
    @Autowired
    private RmiSaleRpcService rmiSaleRpcService;
    @Autowired
    private CreditAccountRuleConfigRepo creditAccountRuleConfigRepo;
    @Autowired
    private RedLockUtils redLockUtils;
    @Autowired
    private FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private MyRedisService myRedisService;
    @Autowired
    private CreditAccountFlowDomainService creditAccountFlowDomainService;
    private static final BigDecimal ONE_HUNDRED_BIGDECIMAL = new BigDecimal("100");

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        PagingVO<CreditAccountFlowDTO> pagingVO = this.creditAccountFlowRepoProc.page(creditAccountFlowPageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List creditAccountFlowDTOList = pagingVO.getRecords();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(creditAccountFlowDTOList.stream().map(CreditAccountFlowDTO::getOuCode).collect(Collectors.toList()));
        List creditAccountRuleConfigDOList = this.creditAccountRuleConfigRepo.findAll();
        creditAccountFlowDTOList.stream().forEach(item -> {
            CreditAccountRuleConfigDO creditAccountRuleConfigDO = creditAccountRuleConfigDOList.stream().filter(accountRuleConfigDO -> StringUtils.equals((CharSequence)item.getCreditAccountRuleCode(), (CharSequence)accountRuleConfigDO.getRuleCode())).findFirst().orElse(null);
            if (creditAccountRuleConfigDO != null) {
                item.setCreditAccountRuleName(creditAccountRuleConfigDO.getRuleName());
            }
        });
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowDTO> appPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        PagingVO<CreditAccountFlowDTO> pagingVO = this.creditAccountFlowRepoProc.appPage(creditAccountFlowPageParam);
        List creditAccountFlowDTOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty((Collection)creditAccountFlowDTOList)) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(CreditAccountFlowParam creditAccountFlowParam) {
        this.checkApproveParam(creditAccountFlowParam);
        this.approve(creditAccountFlowParam, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode(), true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBalanceAndGenerateCreditAccountFlow(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.forEach(v -> {
            int res;
            CreditAccountFlowParam creditAccountFlowParam = v;
            CreditAccountDTO oldCreditAccountDTO = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals((Object)oldCreditAccountDTO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
                this.creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
            } else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            CreditAccountDTO newCreditAccountDTO = this.creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if (newCreditAccountDTO == null) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit = newCreditAccountDTO.getCreditAccountAvailableLimit();
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            SysUserDTO user = this.getUser();
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(creditAccountFlowParam);
            this.flexFieldUtilService.handFlexFieldValueFeference("CREDIT_ACCOUNT_FLOW", (Object)creditAccountFlowDO);
            creditAccountFlowDO = (CreditAccountFlowDO)((Object)((Object)this.creditAccountFlowRepo.save((Object)creditAccountFlowDO)));
            creditAccountFlowParam.setId(creditAccountFlowDO.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(CreditAccountFlowParam creditAccountFlowParam) {
        this.checkApproveParam(creditAccountFlowParam);
        this.approve(creditAccountFlowParam, UdcEnum.APPLY_STATUS_REJECTED.getValueCode(), false);
    }

    @Override
    public void accountFlowCallBack(String doc, CreditAccountFlowDO creditAccountFlowDO, boolean isApprove) {
        if (UdcEnum.DOC_CLS_SVO.getValueCode().equals(doc) || UdcEnum.DOC_CLS_AO.getValueCode().equals(doc)) {
            return;
        }
    }

    private void checkApproveParam(CreditAccountFlowParam param) {
        Assert.notNull((Object)((Object)param), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getCreditAccountCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getTransactionType(), (String)"\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getAmount(), (String)"\u53d1\u751f\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void approve(CreditAccountFlowParam creditAccountFlowParam, String state, boolean isApprove) {
        Optional creditAccountFlowDOOptional = this.creditAccountFlowRepo.findById(creditAccountFlowParam.getId());
        Assert.isTrue((boolean)creditAccountFlowDOOptional.isPresent(), (String)"\u67e5\u8be2\u4e0d\u5230\u5355\u636e", (Object[])new Object[0]);
        CreditAccountFlowDO creditAccountFlowDO = (CreditAccountFlowDO)((Object)creditAccountFlowDOOptional.get());
        Assert.equals((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode(), (Object)creditAccountFlowDO.getOrderState(), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279", (Object[])new Object[0]);
        this.updateAccountAmountAndApprove(creditAccountFlowParam, state);
    }

    private void updateAccountAmount(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            CreditAccountDO creditAccountDO = this.creditAccountRepoProc.findByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            BigDecimal creditAccountLimit = creditAccountDO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = creditAccountDO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = creditAccountDO.getCreditAccountOccupancyLimit();
            Assert.equals((Object)creditAccountDO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountLimit = creditAccountLimit.add(creditAccountFlowParam.getAmount());
            }
            if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountLimit = creditAccountLimit.subtract(creditAccountFlowParam.getAmount());
            }
            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(creditAccountFlowParam.getAmount());
            }
            if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(creditAccountFlowParam.getAmount());
            }
            if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountUsedLimit = creditAccountUsedLimit.add(creditAccountFlowParam.getAmount());
            }
            if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountUsedLimit = creditAccountUsedLimit.subtract(creditAccountFlowParam.getAmount());
            }
            BigDecimal creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            creditAccountDO.setCreditAccountLimit(creditAccountLimit);
            creditAccountDO.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountDO.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountDO.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }

    private void updateAccountAmountFor_CREDIT_IO_TYPE_T(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            CreditAccountDTO creditAccountDTOOld = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals((Object)creditAccountDTOOld.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            int res = this.creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(creditAccountDTOOld.getId(), creditAccountFlowParam.getAmount());
            log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
            if (res < 1) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
            }
            CreditAccountDTO creditAccountDTO = this.creditAccountRepoProc.get(creditAccountDTOOld.getId());
            if (creditAccountDTO == null) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
            }
            BigDecimal creditAccountLimit = creditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = creditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = creditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit = creditAccountDTO.getCreditAccountAvailableLimit();
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }

    private void updateAccountAmountOther(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            CreditAccountDTO newCreditAccountDTO;
            int res;
            CreditAccountDTO oldCreditAccountDTO = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals((Object)oldCreditAccountDTO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newCreditAccountDTO = this.creditAccountRepoProc.get(oldCreditAccountDTO.getId())) == null) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit = newCreditAccountDTO.getCreditAccountAvailableLimit();
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }

    private void updateAccountAmountAndApprove(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            int res;
            CreditAccountDTO oldCreditAccountDTO = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals((Object)oldCreditAccountDTO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25\uff0c\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
                this.creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
            } else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                res = this.creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                    throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u51cf\u5c11\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u4fe1\u7528\u8d26\u6237\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            CreditAccountDTO newCreditAccountDTO = this.creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if (newCreditAccountDTO == null) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
                throw new BusinessException("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u67e5\u8be2\u66f4\u65b0\u540e\u4fe1\u7528\u8d26\u6237\u5931\u8d25");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit = newCreditAccountDTO.getCreditAccountAvailableLimit();
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            SysUserDTO user = this.getUser();
            creditAccountFlowParam.setOrderState(state);
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            this.creditAccountFlowRepoProc.updateCreditAccountFlowAmountById(creditAccountFlowParam);
        }
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    @Override
    public String generateCreditAccountFlow(CreditAccountFlowParam param) {
        log.info("\u751f\u6210\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\uff0c\u63a5\u6536\u5230\u53c2\u6570{}", (Object)JSONUtil.toJsonStr((Object)((Object)param)));
        this.checkGenerateCreditAccountFlowParam(param);
        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE.copyParam(param);
        this.buildCreditAccountFlowParam(creditAccountFlowParam);
        CreditAccountDO creditAccountDO = this.getCreditAccountMsg(creditAccountFlowParam);
        if (StrUtil.isEmpty((CharSequence)param.getWorkflowProcInstId())) {
            this.checkIdempotent(creditAccountDO, creditAccountFlowParam);
        }
        List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList = this.getCreditAccountRuleMsgWithRedis(creditAccountDO, creditAccountFlowParam);
        List<CreditAccountIocDTO> accountIocDTOList = this.getAccountIocMsgWithRedis(accountRuleConfigPageVOList);
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().sorted(Comparator.comparing(CreditAccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        RedissonRedLock redLock = null;
        try {
            String lockKey = "ACCOUNT_FLOW_GENERATE:" + creditAccountDO.getCreditAccountCode();
            log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u9501:{}", (Object)lockKey);
            redLock = this.redLockUtils.getRedLock(lockKey);
            boolean lockFlag = redLock.tryLock(3L, 300L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\u5e76\u53d1\u8fc7\u5927,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6\u9501\u6210\u529f");
            CreditAccountDTO creditAccountDTO = this.creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountDO.getCreditAccountCode());
            CreditAccountDO creditAccountDO1 = CreditAccountConvert.INSTANCE.ConvertDTO2DO(creditAccountDTO);
            this.checkCreditAccountLimit(accountRuleConfigPageVOList, creditAccountDO1, creditAccountFlowParam, accountIocDTOList);
            List<CreditAccountFlowParam> creditAccountFlowParamList = this.buildCreditAccountFlow(accountRuleConfigPageVOList, creditAccountFlowParam, creditAccountDO1, accountIocDTOList);
            ArrayList<CreditAccountFlowParam> autoApproveCreditAccountFlowParams = new ArrayList<CreditAccountFlowParam>();
            ArrayList<CreditAccountFlowParam> notAutoApproveCreditAccountFlowParams = new ArrayList<CreditAccountFlowParam>();
            creditAccountFlowParamList.forEach(v -> {
                if (v.isAutomaticReview()) {
                    autoApproveCreditAccountFlowParams.add((CreditAccountFlowParam)((Object)v));
                } else {
                    notAutoApproveCreditAccountFlowParams.add((CreditAccountFlowParam)((Object)v));
                }
            });
            if (!CollectionUtils.isEmpty(autoApproveCreditAccountFlowParams)) {
                this.creditAccountFlowDomainService.updateBalanceAndGenerateCreditAccountFlow(autoApproveCreditAccountFlowParams);
            }
            if (!CollectionUtils.isEmpty(notAutoApproveCreditAccountFlowParams)) {
                this.creditAccountFlowDomainService.saveCreditAccountFlowList(notAutoApproveCreditAccountFlowParams);
            }
            String string = creditAccountFlowParamList.get(0).getFlowNo();
            return string;
        }
        catch (InterruptedException e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u83b7\u53d6redis\u9501\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        finally {
            redLock.unlock();
            log.info("\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
        }
    }

    private void creditAccountFlowReview(List<CreditAccountFlowParam> creditAccountFlowParamList) {
        creditAccountFlowParamList.stream().forEach(item -> {
            if (item.isAutomaticReview()) {
                this.approve((CreditAccountFlowParam)((Object)item));
            }
        });
    }

    private List<CreditAccountFlowParam> generateCreditAccountFlow(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList, CreditAccountFlowParam creditAccountFlowParam, CreditAccountDO creditAccountDO, List<CreditAccountIocDTO> accountIocDTOList) {
        List<CreditAccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        ArrayList<CreditAccountFlowParam> creditAccountFlowParamList = new ArrayList<CreditAccountFlowParam>();
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {
            CreditAccountFlowParam param = this.buildCreditAccountFlowParam(creditAccountFlowParam, creditAccountDO, accountIocDTOList, (CreditAccountRuleConfigPageVO)accountRuleConfigPageVO);
            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(param);
            this.flexFieldUtilService.handFlexFieldValueFeference("CREDIT_ACCOUNT_FLOW", (Object)creditAccountFlowDO);
            this.creditAccountFlowRepo.save((Object)creditAccountFlowDO);
            param.setFlowNo(creditAccountFlowDO.getFlowNo());
            param.setId(creditAccountFlowDO.getId());
            creditAccountFlowParamList.add(param);
        });
        return creditAccountFlowParamList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCreditAccountFlowList(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.stream().forEach(v -> {
            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO((CreditAccountFlowParam)((Object)v));
            this.flexFieldUtilService.handFlexFieldValueFeference("CREDIT_ACCOUNT_FLOW", (Object)creditAccountFlowDO);
            creditAccountFlowDO = (CreditAccountFlowDO)((Object)((Object)this.creditAccountFlowRepo.save((Object)creditAccountFlowDO)));
            v.setId(creditAccountFlowDO.getId());
        });
    }

    private List<CreditAccountFlowParam> buildCreditAccountFlow(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList, CreditAccountFlowParam creditAccountFlowParam, CreditAccountDO creditAccountDO, List<CreditAccountIocDTO> accountIocDTOList) {
        List<CreditAccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        ArrayList<CreditAccountFlowParam> creditAccountFlowParamList = new ArrayList<CreditAccountFlowParam>();
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {
            CreditAccountFlowParam param = this.buildCreditAccountFlowParam(creditAccountFlowParam, creditAccountDO, accountIocDTOList, (CreditAccountRuleConfigPageVO)accountRuleConfigPageVO);
            creditAccountFlowParamList.add(param);
        });
        return creditAccountFlowParamList;
    }

    @Override
    public Boolean checkCreditAccountBalance(CreditAccountFlowParam param) {
        this.checkGenerateCreditAccountFlowParam(param);
        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE.copyParam(param);
        this.buildCreditAccountFlowParam(creditAccountFlowParam);
        CreditAccountDO creditAccountDO = this.getCreditAccountMsg(creditAccountFlowParam);
        this.checkIdempotent(creditAccountDO, creditAccountFlowParam);
        List<CreditAccountRuleConfigPageVO> creditAccountRuleConfigPageVOList = this.getCreditAccountRuleMsg(creditAccountDO, creditAccountFlowParam);
        List<CreditAccountIocDTO> creditAccountIocDTOList = this.getAccountIocMsg(creditAccountRuleConfigPageVOList);
        creditAccountRuleConfigPageVOList = creditAccountRuleConfigPageVOList.stream().sorted(Comparator.comparing(CreditAccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        this.checkCreditAccountLimit(creditAccountRuleConfigPageVOList, creditAccountDO, creditAccountFlowParam, creditAccountIocDTOList);
        return true;
    }

    private void buildCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowParam.setSourceDocType(creditAccountFlowParam.getSourceDoc().concat("_").concat(creditAccountFlowParam.getSourceDocType()));
        creditAccountFlowParam.setSourceDocStatus(creditAccountFlowParam.getSourceDoc().concat("_").concat(creditAccountFlowParam.getSourceDocStatus()));
    }

    private void checkCreditAccountLimit(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList, CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam, List<CreditAccountIocDTO> accountIocDTOList) {
        accountRuleConfigPageVOList.stream().forEach(item -> {
            CreditAccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(item.getIoCode())).findFirst().orElse(null);
            Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u4fe1\u7528\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(accountIocDTO.getIoType())) {
                Assert.isTrue((creditAccountDO.getCreditAccountAvailableLimit().compareTo(creditAccountFlowParam.getSourceDocAmount().multiply(item.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL)) >= 0 ? 1 : 0) != 0, (String)"\u4fe1\u7528\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
            }
        });
    }

    private void checkIdempotent(CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowParam.setCreditAccountType(creditAccountDO.getCreditAccountType());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(this.creditAccountFlowRepoProc.queryCreditAccountFlowVO(creditAccountFlowParam)), (String)"\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u8fc7\u6d41\u6c34", (Object[])new Object[0]);
    }

    private List<CreditAccountIocDTO> getAccountIocMsg(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        HashSet<String> ioCodeSet = new HashSet<String>();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        CreditAccountIocParam accountIocParam = new CreditAccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountIocDTO> accountIocDTOList = this.creditAccountIocService.queryByAccountIocParam(accountIocParam);
        Assert.notEmpty(accountIocDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u4e8b\u52a1\u7801\u5931\u8d25", (Object[])new Object[0]);
        return accountIocDTOList;
    }

    private List<CreditAccountIocDTO> getAccountIocMsgWithRedis(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        HashSet ioCodeSet = new HashSet();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        CreditAccountIocParam accountIocParam = new CreditAccountIocParam();
        accountIocParam.setSize(Integer.MAX_VALUE);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountIocDTO> accountIocDTOList = this.myRedisService.getListDataFromRedis("YST_FIN_CREDIT_ACCOUNT_IOC", CreditAccountIocDTO.class, "\u4fe1\u7528\u4e8b\u52a1\u7801\u914d\u7f6e", () -> this.creditAccountIocService.queryByAccountIocParam(accountIocParam));
        if (!CollectionUtils.isEmpty(accountIocDTOList)) {
            accountIocDTOList = accountIocDTOList.stream().filter(v -> ioCodeSet.contains(v.getIoCode())).collect(Collectors.toList());
        }
        Assert.notEmpty(accountIocDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u4e8b\u52a1\u7801\u5931\u8d25", (Object[])new Object[0]);
        return accountIocDTOList;
    }

    public CreditAccountFlowParam buildCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam, CreditAccountDO creditAccountDO, List<CreditAccountIocDTO> accountIocDTOList, CreditAccountRuleConfigPageVO accountRuleConfigPageVO) {
        CreditAccountFlowParam result = new CreditAccountFlowParam();
        result.setOuCode(creditAccountDO.getOuCode());
        result.setOuName(creditAccountDO.getOuName());
        result.setObjectCode(creditAccountDO.getObjectCode());
        result.setObjectName(creditAccountDO.getObjectName());
        result.setObjectType(creditAccountDO.getObjectType());
        result.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
        CreditAccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(accountRuleConfigPageVO.getIoCode())).findFirst().orElse(null);
        Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
        result.setTransactionType(accountIocDTO.getIoType());
        result.setAmount(creditAccountFlowParam.getSourceDocAmount().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL));
        result.setTransactionTime(LocalDateTime.now());
        result.setCreditAccountType(creditAccountDO.getCreditAccountType());
        result.setCreditAccountCode(creditAccountDO.getCreditAccountCode());
        result.setCreditAccountName(creditAccountDO.getCreditAccountName());
        result.setSourceDoc(creditAccountFlowParam.getSourceDoc());
        result.setSourceNo(creditAccountFlowParam.getSourceNo());
        result.setSourceId(creditAccountFlowParam.getSourceId());
        result.setCreditAccountRuleCode(accountRuleConfigPageVO.getRuleCode());
        result.setPriorityNo(accountRuleConfigPageVO.getPriorityNo());
        result.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        result.setSourceDocStatus(creditAccountFlowParam.getSourceDocStatus());
        result.setAutomaticReview(accountRuleConfigPageVO.isAutomaticReview());
        result.setCreditAccountLimit(creditAccountDO.getCreditAccountLimit());
        result.setCreditAccountUsedLimit(creditAccountDO.getCreditAccountUsedLimit());
        result.setCreditAccountOccupancyLimit(creditAccountDO.getCreditAccountOccupancyLimit());
        result.setCreditAccountAvailableLimit(creditAccountDO.getCreditAccountAvailableLimit());
        result.setExtensionInfo(creditAccountFlowParam.getExtensionInfo());
        return result;
    }

    private List<CreditAccountRuleConfigPageVO> getCreditAccountRuleMsg(CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountRuleConfigQueryParam accountRuleConfigQueryParam = new CreditAccountRuleConfigQueryParam();
        accountRuleConfigQueryParam.setOptDoc(creditAccountFlowParam.getSourceDoc());
        accountRuleConfigQueryParam.setOptDocType(creditAccountFlowParam.getSourceDocType());
        accountRuleConfigQueryParam.setOptDocStatus(creditAccountFlowParam.getSourceDocStatus());
        accountRuleConfigQueryParam.setOptAccountType(creditAccountDO.getCreditAccountType());
        accountRuleConfigQueryParam.setSpecificAccount(creditAccountDO.getCreditAccountCode());
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        accountRuleConfigQueryParam.setSize(Constants.PAGE_SIZE);
        PagingVO<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.creditAccountRuleConfigService.searchPageWhihoutName(accountRuleConfigQueryParam);
        Assert.notEmpty((Iterable)accountRuleConfigPageVOPagingVO.getRecords(), (String)"\u6ca1\u6709\u5339\u914d\u5230\u4fe1\u7528\u8d26\u6237\u89c4\u5219", (Object[])new Object[0]);
        return accountRuleConfigPageVOPagingVO.getRecords();
    }

    private List<CreditAccountRuleConfigPageVO> getCreditAccountRuleMsgWithRedis(CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountRuleConfigQueryParam accountRuleConfigQueryParam = new CreditAccountRuleConfigQueryParam();
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        accountRuleConfigQueryParam.setSize(Constants.PAGE_SIZE);
        List<CreditAccountRuleConfigPageVO> creditAccountRuleConfigPageVOList = this.myRedisService.getListDataFromRedis("YST_FIN_CREDIT_ACCOUNT_RULE_CONFIG", CreditAccountRuleConfigPageVO.class, "\u4fe1\u7528\u8d26\u6237\u89c4\u5219\u914d\u7f6e", () -> {
            PagingVO<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.creditAccountRuleConfigService.searchPageWhihoutName(accountRuleConfigQueryParam);
            if (accountRuleConfigPageVOPagingVO == null || CollectionUtils.isEmpty((Collection)accountRuleConfigPageVOPagingVO.getRecords())) {
                return null;
            }
            return accountRuleConfigPageVOPagingVO.getRecords();
        });
        if (!CollectionUtils.isEmpty(creditAccountRuleConfigPageVOList)) {
            creditAccountRuleConfigPageVOList = creditAccountRuleConfigPageVOList.stream().filter(v -> {
                if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDoc()) && !creditAccountFlowParam.getSourceDoc().equals(v.getOptDoc())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDocType()) && !creditAccountFlowParam.getSourceDocType().equals(v.getOptDocType())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDocStatus()) && !creditAccountFlowParam.getSourceDocStatus().equals(v.getOptDocStatus())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)creditAccountDO.getCreditAccountType()) && !creditAccountDO.getCreditAccountType().equals(v.getOptAccountType())) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)creditAccountDO.getCreditAccountCode())) {
                    if (v.getSpecificAccount() == null) {
                        return true;
                    }
                    if (!creditAccountDO.getCreditAccountCode().equals(v.getSpecificAccount())) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        }
        Assert.notEmpty(creditAccountRuleConfigPageVOList, (String)"\u6ca1\u6709\u5339\u914d\u5230\u4fe1\u7528\u8d26\u6237\u89c4\u5219", (Object[])new Object[0]);
        return creditAccountRuleConfigPageVOList;
    }

    private CreditAccountDO getCreditAccountMsg(CreditAccountFlowParam creditAccountFlowParam) {
        return this.creditAccountRepoProc.findByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
    }

    private void checkGenerateCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam) {
        Assert.notNull((Object)((Object)creditAccountFlowParam), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)creditAccountFlowParam.getSourceDoc(), (String)"\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)creditAccountFlowParam.getSourceDocType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)creditAccountFlowParam.getSourceDocStatus(), (String)"\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)creditAccountFlowParam.getSourceDocAmount(), (String)"\u6765\u6e90\u5355\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)creditAccountFlowParam.getSourceId(), (String)"\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)creditAccountFlowParam.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)creditAccountFlowParam.getCreditAccountCode(), (String)"\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam) {
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowRepoProc.selectListByQueryParam(queryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam pageParam) {
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowRepoProc.selectRepairAfterPage(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam pageParam) {
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowRepoProc.selectRepairAfter(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }
}

