/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplySettleService;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplySettleDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplySettleRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinArRecVerApplySettleServiceImpl
implements FinArRecVerApplySettleService {
    private final FinArRecVerApplySettleRepoProc finArRecVerApplySettleRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinArRecVerApplySettleSaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> arDocNoList = saveList.stream().map(FinArRecVerApplySettleSaveDTO::getArDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArOrderDTO> arOrderDTOList = this.arOrderRepoProc.selectInOutCustByArOrderNo(arDocNoList);
        HashMap arOrderMap = CollectionUtil.isEmpty(arOrderDTOList) ? new HashMap() : arOrderDTOList.stream().collect(Collectors.toMap(ArOrderDTO::getArOrderNo, t -> t, (t1, t2) -> t1));
        List<String> recDocNoList = saveList.stream().map(FinArRecVerApplySettleSaveDTO::getRecDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<RecOrderDTO> recOrderDTOList = this.recOrderRepoProc.selectInOutCustByRecOrderNo(recDocNoList);
        HashMap recOrderMap = CollectionUtil.isEmpty(recOrderDTOList) ? new HashMap() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1));
        this.finArRecVerApplySettleRepoProc.save(saveList.stream().map(e -> {
            RecOrderDTO recOrderDTO;
            FinArRecVerApplySettleDO entity = FinArRecVerApplySettleConvert.INSTANCE.save2Do((FinArRecVerApplySettleSaveDTO)e);
            entity.setMasId(masId);
            ArOrderDTO arOrderDTO = (ArOrderDTO)arOrderMap.get(entity.getArDocNo());
            if (Objects.nonNull(arOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getArInOutCust()) ? arOrderDTO.getInOutCust() : entity.getArInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getArRelevanceOuCode()) ? arOrderDTO.getRelevanceOuCode() : entity.getArRelevanceOuCode();
                entity.setArInOutCust(inOutCust);
                entity.setArRelevanceOuCode(relevanceOuCode);
            }
            if (Objects.nonNull(recOrderDTO = (RecOrderDTO)recOrderMap.get(entity.getRecDocNo()))) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getRecInOutCust()) ? recOrderDTO.getInOutCust() : entity.getRecInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRecRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRecRelevanceOuCode();
                entity.setRecInOutCust(inOutCust);
                entity.setRecRelevanceOuCode(relevanceOuCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<FinArRecVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplySettleVO> finArRecVerApplySettleVOList = this.finArRecVerApplySettleRepoProc.listByMasIds(masIds).stream().map(FinArRecVerApplySettleConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finArRecVerApplySettleVOList)) {
            return Collections.EMPTY_LIST;
        }
        List arRelevanceOuCodeList = finArRecVerApplySettleVOList.stream().map(FinArRecVerApplySettleVO::getArRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recRelevanceOuCodeList = finArRecVerApplySettleVOList.stream().map(FinArRecVerApplySettleVO::getRecRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> relevanceOuCodeAllList = Stream.of(arRelevanceOuCodeList, recRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplySettleVOList)) {
            finArRecVerApplySettleVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouPayRpcSimpleDTO;
                OrgOuRpcSimpleDTO ouApRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getArRelevanceOuCode());
                if (Objects.nonNull(ouApRpcSimpleDTO)) {
                    v.setArRelevanceOuName(ouApRpcSimpleDTO.getOuName());
                }
                if (Objects.nonNull(ouPayRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRecRelevanceOuCode()))) {
                    v.setRecRelevanceOuName(ouPayRpcSimpleDTO.getOuName());
                }
            });
        }
        return finArRecVerApplySettleVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (this.finArRecVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u5904\u7406\u7f16\u53f7\u5931\u8d25!");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerFlag(Collection<Long> masIds, String verFlag) {
        if (this.finArRecVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u5904\u7406\u7f16\u53f7\u5931\u8d25!");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchNoByArDid(String arDid, String batchNo) {
        if (this.finArRecVerApplySettleRepoProc.updateBatchNoByArDid(arDid, batchNo) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u6279\u6b21\u53f7\u5931\u8d25!");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchNoByRcDid(String rcDid, String batchNo) {
        if (this.finArRecVerApplySettleRepoProc.updateBatchNoByRcDid(rcDid, batchNo) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u6279\u6b21\u53f7\u5931\u8d25!");
        }
    }

    public FinArRecVerApplySettleServiceImpl(FinArRecVerApplySettleRepoProc finArRecVerApplySettleRepoProc, ArOrderRepoProc arOrderRepoProc, RecOrderRepoProc recOrderRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.finArRecVerApplySettleRepoProc = finArRecVerApplySettleRepoProc;
        this.arOrderRepoProc = arOrderRepoProc;
        this.recOrderRepoProc = recOrderRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

