/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.inputinv;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.domain.entity.inputinv.QInputInvDO;
import com.elitesland.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class InputInvRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QInputInvDO qInputInvDO = QInputInvDO.inputInvDO;

    public PagingVO<InputInvDTO> page(InputInvPageParam inputInvPageParam, List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != inputInvPageParam.getOuId()) {
            predicates.add(this.qInputInvDO.ouId.eq((Object)inputInvPageParam.getOuId()));
        }
        if (inputInvPageParam.getSuppId() != null) {
            predicates.add(this.qInputInvDO.suppId.eq((Object)inputInvPageParam.getSuppId()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getCreateMode())) {
            predicates.add(this.qInputInvDO.createMode.eq((Object)inputInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getInvRegNo())) {
            predicates.add(this.qInputInvDO.invRegNo.like("%" + inputInvPageParam.getInvRegNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getOrderState())) {
            predicates.add(this.qInputInvDO.orderState.eq((Object)inputInvPageParam.getOrderState()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getSourceNo())) {
            predicates.add(this.qInputInvDO.sourceNo.like("%" + inputInvPageParam.getSourceNo() + "%"));
        }
        if (inputInvPageParam.getCreateTimeStart() != null && inputInvPageParam.getCreateTimeEnd() != null) {
            predicates.add(this.qInputInvDO.createTime.between((Comparable)inputInvPageParam.getCreateTimeStart(), (Comparable)inputInvPageParam.getCreateTimeEnd()));
        }
        if (inputInvPageParam.getTotalAmtStart() != null) {
            predicates.add(this.qInputInvDO.totalAmt.goe((Number)inputInvPageParam.getTotalAmtStart()));
        }
        if (inputInvPageParam.getTotalAmtEnd() != null) {
            predicates.add(this.qInputInvDO.totalAmt.loe((Number)inputInvPageParam.getTotalAmtEnd()));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(this.qInputInvDO.id.in(ids));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getInvNo())) {
            predicates.add(this.qInputInvDO.invNo.like("%" + inputInvPageParam.getInvNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getInvCode())) {
            predicates.add(this.qInputInvDO.invCode.like("%" + inputInvPageParam.getInvCode() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getInvType())) {
            predicates.add(this.qInputInvDO.invType.eq((Object)inputInvPageParam.getInvType()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getRedBlueType())) {
            predicates.add(this.qInputInvDO.redBlueType.eq((Object)inputInvPageParam.getRedBlueType()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getApOrderNo())) {
            predicates.add(this.qInputInvDO.apOrderNo.like("%" + inputInvPageParam.getRedBlueType() + "%"));
        }
        if (inputInvPageParam.getInvDateStart() != null && inputInvPageParam.getInvDateEnd() != null) {
            predicates.add(this.qInputInvDO.invDate.between((Comparable)inputInvPageParam.getInvDateStart(), (Comparable)inputInvPageParam.getInvDateEnd()));
        }
        predicates.add(this.qInputInvDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(InputInvDTO.class).where(ExpressionUtils.allOf(predicates));
        inputInvPageParam.setPaging(query);
        inputInvPageParam.fillOrders(query, this.qInputInvDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<InputInvDTO> queryByIds(Collection<Long> ids) {
        return ((JPAQuery)this.select(InputInvDTO.class).where((Predicate)this.qInputInvDO.id.in(ids))).fetch();
    }

    public void updateAudit(Long id, String reason, SysUserDTO user) {
        this.jpaQueryFactory.update((EntityPath)this.qInputInvDO).set(this.qInputInvDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qInputInvDO.auditRejection, (Object)reason).set((Path)this.qInputInvDO.auditUser, (Object)user.getUsername()).set(this.qInputInvDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qInputInvDO.id.eq((Object)id)}).execute();
    }

    public InputInvDTO queryById(Long id) {
        return (InputInvDTO)((JPAQuery)this.select(InputInvDTO.class).where((Predicate)this.qInputInvDO.id.eq((Object)id))).fetchOne();
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qInputInvDO).where(new Predicate[]{this.qInputInvDO.id.in(ids)}).execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qInputInvDO.id, this.qInputInvDO.sourceNo, this.qInputInvDO.ouCode, this.qInputInvDO.ouId, this.qInputInvDO.ouName, this.qInputInvDO.currCode, this.qInputInvDO.currName, this.qInputInvDO.totalAmt, this.qInputInvDO.totalCurAmt, this.qInputInvDO.auditUserId, this.qInputInvDO.auditUser, this.qInputInvDO.auditDate, this.qInputInvDO.orderState, this.qInputInvDO.exchangeRate, this.qInputInvDO.createTime, this.qInputInvDO.updater, this.qInputInvDO.modifyTime, this.qInputInvDO.creator, this.qInputInvDO.createMode, this.qInputInvDO.suppId, this.qInputInvDO.suppCode, this.qInputInvDO.suppName, this.qInputInvDO.suppRemark, this.qInputInvDO.remark, this.qInputInvDO.localCurrCode, this.qInputInvDO.localCurrName, this.qInputInvDO.auditDataVersion, this.qInputInvDO.auditRejection, this.qInputInvDO.invRegNo, this.qInputInvDO.invUser, this.qInputInvDO.revUser, this.qInputInvDO.recUser, this.qInputInvDO.bankAccount, this.qInputInvDO.suppAddress, this.qInputInvDO.suppTel, this.qInputInvDO.openBank, this.qInputInvDO.taxRate, this.qInputInvDO.taxNumber, this.qInputInvDO.procInstId, this.qInputInvDO.procInstStatus, this.qInputInvDO.approvedTime, this.qInputInvDO.submitTime, this.qInputInvDO.invNo, this.qInputInvDO.invCode, this.qInputInvDO.redBlueType, this.qInputInvDO.invType, this.qInputInvDO.apOrderNo, this.qInputInvDO.invDate, this.qInputInvDO.untaxedAmt, this.qInputInvDO.taxAmt, this.qInputInvDO.invCheckCode, this.qInputInvDO.invVerifyStatus, this.qInputInvDO.invFileCode})).from((EntityPath)this.qInputInvDO);
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qInputInvDO).set(this.qInputInvDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qInputInvDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qInputInvDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qInputInvDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qInputInvDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void savaApOrderNo(String createMode, String sourceNo, String apOrderNo) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qInputInvDO).set((Path)this.qInputInvDO.apOrderNo, (Object)apOrderNo).where(new Predicate[]{this.qInputInvDO.createMode.eq((Object)createMode).and((Predicate)this.qInputInvDO.sourceNo.eq((Object)sourceNo))});
        jpaUpdateClause.execute();
    }

    public void removeApOrderNo(String createMode, String sourceNo) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qInputInvDO).setNull((Path)this.qInputInvDO.apOrderNo).where(new Predicate[]{this.qInputInvDO.createMode.eq((Object)createMode).and((Predicate)this.qInputInvDO.sourceNo.eq((Object)sourceNo))});
        jpaUpdateClause.execute();
    }

    public List<InputInvDTO> findAllByParam(InputInvPageParam inputInvPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getCreateMode())) {
            predicates.add(this.qInputInvDO.createMode.eq((Object)inputInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty((CharSequence)inputInvPageParam.getSourceNo())) {
            predicates.add(this.qInputInvDO.sourceNo.eq((Object)inputInvPageParam.getSourceNo()));
        }
        predicates.add(this.qInputInvDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(InputInvDTO.class).where(ExpressionUtils.allOf(predicates));
        inputInvPageParam.setPaging(query);
        inputInvPageParam.fillOrders(query, this.qInputInvDO);
        return query.fetch();
    }

    public InputInvRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

