/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.expense;

import cn.hutool.json.JSONUtil;
import com.elitesland.fin.domain.expense.ExpTypeDtlDO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepoProc;
import com.elitesland.fin.param.expense.ExpTypeDtlRpcVO;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcParam;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcRespPVO;
import com.elitesland.fin.service.expense.ExpenseTypeRpcService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpenseTypeRpcServiceImpl
implements ExpenseTypeRpcService {
    private static final Logger log = LoggerFactory.getLogger(ExpenseTypeRpcServiceImpl.class);
    private final ExpTypeRepoProc expTypeRepoProc;
    private final ExpTypeDtlRepo expTypeDtlRepo;

    public ExpTypeQueryRpcRespPVO getList(ExpTypeQueryRpcParam param) {
        log.info("\u8d39\u7528\u7c7b\u578brpc\u67e5\u8be2-\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        ExpTypeQueryRpcRespPVO result = new ExpTypeQueryRpcRespPVO();
        ExpTypeDTO byExpTypeCode = this.expTypeRepoProc.findByExpTypeCode(param.getExpTypeCode());
        log.info("\u8d39\u7528\u7c7b\u578brpc\u67e5\u8be2-\u4e3b\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)byExpTypeCode));
        result.setExpTypeCode(byExpTypeCode.getExpTypeCode());
        result.setExpTypeName(byExpTypeCode.getExpTypeName());
        List<ExpTypeDtlDO> typeDtlDOS = this.expTypeDtlRepo.findAllByMasId(byExpTypeCode.getId());
        log.info("\u8d39\u7528\u7c7b\u578brpc\u67e5\u8be2-\u660e\u7ec6\u8868\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)byExpTypeCode));
        List dtlRpcVOS = typeDtlDOS.stream().map(e -> {
            ExpTypeDtlRpcVO vo = new ExpTypeDtlRpcVO();
            vo.setSourceDocType(e.getSourceDocType());
            vo.setSourceDoc(e.getSourceDoc());
            vo.setSourceDocStatus(e.getSourceDocStatus());
            return vo;
        }).collect(Collectors.toList());
        result.setDtlList(dtlRpcVOS);
        log.info("\u8d39\u7528\u7c7b\u578brpc\u67e5\u8be2-\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr((Object)result));
        return null;
    }

    public ExpenseTypeRpcServiceImpl(ExpTypeRepoProc expTypeRepoProc, ExpTypeDtlRepo expTypeDtlRepo) {
        this.expTypeRepoProc = expTypeRepoProc;
        this.expTypeDtlRepo = expTypeDtlRepo;
    }
}

