/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.payorder;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import com.elitesland.fin.service.payorder.PayOrderRpcService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payOrder"})
public class PayOrderRpcServiceImpl
implements PayOrderRpcService {
    public final PayOrderDomainService payOrderDomainService;

    public Long save(PayOrderRpcParam payOrderRpcParam) {
        if (CharSequenceUtil.isBlank((CharSequence)payOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertRpc(payOrderRpcParam);
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = this.payOrderDomainService.save(payOrder);
        return resId;
    }

    public ApiResult<PagingVO<PayOrderRpcDTO>> page(PayOrderPageRpcParam payOrderPageRpcParam) {
        PayOrderPageParam payOrderPageParam = PayOrderConvert.INSTANCE.convertPageParamRpc(payOrderPageRpcParam);
        PagingVO<PayOrderRpcDTO> res = PayOrderConvert.INSTANCE.convertRpcDto(this.payOrderDomainService.page(payOrderPageParam));
        return ApiResult.ok(res);
    }

    public PayOrderRpcServiceImpl(PayOrderDomainService payOrderDomainService) {
        this.payOrderDomainService = payOrderDomainService;
    }
}

