/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.payment;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDO;
import com.elitesland.fin.entity.payment.QPaymentRuleConfigDO;
import com.elitesland.fin.entity.payment.QPaymentRuleConfigDtlDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentRuleConfigRepoProc {
    private static final Logger log = LoggerFactory.getLogger(PaymentRuleConfigRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final QPaymentRuleConfigDO jpaQDo = QPaymentRuleConfigDO.paymentRuleConfigDO;
    private final QPaymentRuleConfigDtlDO jpaDQDo = QPaymentRuleConfigDtlDO.paymentRuleConfigDtlDO;

    public void updateDynamically(PaymentRuleConfigDO param) {
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)this.jpaQDo);
        if (StringUtils.isNotBlank((CharSequence)param.getRuleCode())) {
            updateClause.set((Path)this.jpaQDo.ruleCode, (Object)param.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRuleName())) {
            updateClause.set((Path)this.jpaQDo.ruleName, (Object)param.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOptDoc())) {
            updateClause.set((Path)this.jpaQDo.optDoc, (Object)param.getOptDoc());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStatus())) {
            updateClause.set((Path)this.jpaQDo.status, (Object)param.getStatus());
        }
        updateClause.set(this.jpaQDo.modifyTime, (Object)LocalDateTime.now());
        updateClause.where(new Predicate[]{this.jpaQDo.id.eq((Object)param.getId())}).execute();
    }

    public List<PaymentRuleConfigDtlDTO> searchByPaymentRuleConfigParam(PaymentRuleConfigParam paymentRuleConfigParam) {
        JPAQuery<PaymentRuleConfigDtlDTO> jpaQuery = this.select(PaymentRuleConfigDtlDTO.class);
        jpaQuery.where(this.where(paymentRuleConfigParam));
        return jpaQuery.fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.jpaDQDo.id, this.jpaQDo.ruleCode, this.jpaQDo.ruleName, this.jpaQDo.optDoc, this.jpaDQDo.optDocType, this.jpaDQDo.optDocStatus, this.jpaDQDo.calculatePercent, this.jpaQDo.status, this.jpaDQDo.masId, this.jpaQDo.createUserId, this.jpaQDo.creator, this.jpaQDo.createTime, this.jpaQDo.modifyUserId, this.jpaQDo.updater, this.jpaQDo.modifyTime, this.jpaQDo.deleteFlag, this.jpaQDo.tenantId, this.jpaQDo.auditDataVersion, this.jpaDQDo.remark, this.jpaDQDo.priorityNo, this.jpaDQDo.optAccountType})).from((EntityPath)this.jpaDQDo)).leftJoin((EntityPath)this.jpaQDo)).on((Predicate)this.jpaQDo.id.eq(this.jpaDQDo.masId));
    }

    public List<PaymentRuleConfigPageVO> selectPaymentRuleConfigByParam(PaymentRuleConfigParam paymentRuleConfigParam) {
        JPAQuery<PaymentRuleConfigPageVO> jpaQuery = this.select(PaymentRuleConfigPageVO.class);
        jpaQuery.where(this.where(paymentRuleConfigParam));
        return jpaQuery.fetch();
    }

    public PagingVO<PaymentRuleConfigPageVO> searchPage(PaymentRuleConfigParam param) {
        JPAQuery<PaymentRuleConfigPageVO> jpaQuery = this.select(PaymentRuleConfigPageVO.class);
        jpaQuery.where(this.where(param));
        param.fillOrders(jpaQuery, this.jpaQDo);
        param.setPaging(jpaQuery);
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private Predicate where(PaymentRuleConfigParam param) {
        BooleanExpression predicate = this.jpaQDo.isNotNull();
        if (StringUtils.isNotBlank((CharSequence)param.getMultiKeywords())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)this.jpaQDo.ruleCode.like("%" + param.getMultiKeywords() + "%"), (Predicate)this.jpaQDo.ruleName.like("%" + param.getMultiKeywords() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRuleCodeName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)this.jpaQDo.ruleCode.like("%" + param.getRuleCodeName() + "%"), (Predicate)this.jpaQDo.ruleName.like("%" + param.getRuleCodeName() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDoc())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.optDoc.eq((Object)param.getOptDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDocType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaDQDo.optDocType.contains(param.getOptDocType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDocStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaDQDo.optDocStatus.eq((Object)param.getOptDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptAccountType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaDQDo.optAccountType.eq((Object)param.getOptAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.status.eq((Object)param.getStatus()));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.jpaQDo.deleteFlag.eq((Object)0).or((Predicate)this.jpaQDo.deleteFlag.isNull()));
        return predicate;
    }

    public PaymentRuleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

