/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.sale;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.sale.constant.AllowShipCustGroupEnum;
import com.elitesland.sale.constant.AllowShipStatus;
import com.elitesland.sale.service.AllowShipRpcService;
import com.elitesland.sale.service.CrmCustRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RmiSaleRpcServiceImpl
implements RmiSaleRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiSaleRpcServiceImpl.class);
    private final CrmCustRpcService crmCustRpcService;
    private final AllowShipRpcService allowShipRpcService;

    @Override
    public List<LmSaveCustRespVO> findInvCust(List<String> custCodeList) {
        ApiResult apiResult = this.crmCustRpcService.findInvCust(custCodeList);
        Assert.notNull((Object)apiResult, (String)"\u8c03\u75282B\u9500\u552e\u57df\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a,\u5ba2\u6237\u7f16\u7801{}", (Object[])new Object[]{custCodeList});
        Assert.isTrue((boolean)apiResult.isSuccess(), (String)"\u8c03\u75282B\u9500\u552e\u57df\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5ba2\u6237\u7f16\u7801{}", (Object[])new Object[]{custCodeList});
        return (List)apiResult.getData();
    }

    @Override
    public List<AllowShipCustGroupDVO> getCustGroupInfo(AllowShipCustGroupDParam param) {
        List custGroupInfo;
        try {
            custGroupInfo = this.allowShipRpcService.getCustGroupInfo(param);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9500\u552e\u57df\u63a5\u53e3\u67e5\u8be2\u5ba2\u6237\u7ec4\u4fe1\u606f\u5931\u8d25, {}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u57df\u63a5\u53e3\u67e5\u8be2\u5ba2\u6237\u7ec4\u4fe1\u606f\u5931\u8d25");
        }
        return custGroupInfo;
    }

    @Override
    public String getCustGroupCodeByCustCode(String custCode) {
        AllowShipCustGroupDParam allowShipCustGroupDParam = new AllowShipCustGroupDParam();
        ArrayList<String> custCodes = new ArrayList<String>();
        custCodes.add(custCode);
        allowShipCustGroupDParam.setCustCodes(custCodes);
        allowShipCustGroupDParam.setStatus(AllowShipStatus.ACTIVE.getType());
        allowShipCustGroupDParam.setType(AllowShipCustGroupEnum.CREIDT_ACCOUNT_GROUP.getType());
        List allowShipCustGroupDVOList = this.allowShipRpcService.getCustGroupInfo(allowShipCustGroupDParam);
        if (CollectionUtils.isNotEmpty((Collection)allowShipCustGroupDVOList)) {
            String custGroupCode = ((AllowShipCustGroupDVO)allowShipCustGroupDVOList.get(0)).getCode();
            Assert.notEmpty((CharSequence)custGroupCode, (String)"\u67e5\u8be2\u5ba2\u6237\u7ec4\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
            return custGroupCode;
        }
        return custCode;
    }

    @Override
    public List<RmiOrgBankAccRpcVO> findBankAccByCustCode(String custCode) {
        List bankAccRpcDtoByCustCode = null;
        try {
            bankAccRpcDtoByCustCode = this.crmCustRpcService.findBankAccRpcDtoByCustCode(custCode);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9500\u552e\u57df\u67e5\u8be2\u5ba2\u6237\u94f6\u884c\u4fe1\u606f\u5931\u8d25, {}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528\u9500\u552e\u57df\u67e5\u8be2\u5ba2\u6237\u94f6\u884c\u4fe1\u606f\u5931\u8d25");
        }
        return bankAccRpcDtoByCustCode;
    }

    public RmiSaleRpcServiceImpl(CrmCustRpcService crmCustRpcService, AllowShipRpcService allowShipRpcService) {
        this.crmCustRpcService = crmCustRpcService;
        this.allowShipRpcService = allowShipRpcService;
    }
}

