/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.data.util.Pair;

public class PriceRoundConverter
extends Converter<BigDecimal, BigDecimal, Pair<Integer, RoundingMode>> {
    private static final SystemRpcService systemRpcService = (SystemRpcService)SpringContextHolder.getBean(SystemRpcService.class);

    @Override
    public BigDecimal convert(BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if (this.baseValue == null) {
            return value;
        }
        Integer scale = (Integer)((Pair)this.baseValue).getFirst();
        RoundingMode roundingMode = (RoundingMode)((Object)((Pair)this.baseValue).getSecond());
        return NumberUtils.toScaledBigDecimal((BigDecimal)value, (int)scale, (RoundingMode)roundingMode);
    }

    @Override
    public synchronized Pair<Integer, RoundingMode> initBaseValue() {
        this.baseValue = this.setPriceAccuracyBySettingService();
        return this.baseValue;
    }

    @Override
    public synchronized Pair<Integer, RoundingMode> refreshBaseValue() {
        this.baseValue = this.setPriceAccuracyBySettingService();
        return this.baseValue;
    }

    private Pair<Integer, RoundingMode> setPriceAccuracyBySettingService() {
        SysSettingVO priceDecimalPlace = systemRpcService.findSysSettingByNo("PRICE_DECIMAL_PLACE");
        SysSettingVO priceRoundingModeValue = systemRpcService.findSysSettingByNo("PRICE_ROUNDING_MODE_VALUE");
        Integer scale = 0;
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (priceDecimalPlace != null && priceDecimalPlace.getSettingVal() != null && !priceDecimalPlace.getSettingVal().equals("")) {
            scale = Integer.parseInt(priceDecimalPlace.getSettingVal());
        }
        if (priceRoundingModeValue != null && priceRoundingModeValue.getSettingVal() != null && priceRoundingModeValue.getSettingVal().equals("")) {
            roundingMode = RoundingMode.valueOf(Integer.parseInt(priceRoundingModeValue.getSettingVal()));
        }
        return Pair.of((Object)scale, (Object)((Object)roundingMode));
    }
}

