/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.app;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.fin.application.facade.param.account.AccountAppParam;
import com.elitesland.fin.application.facade.vo.app.StoreAccountCustAppVO;
import com.elitesland.fin.application.service.app.AppAccountService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgStoreRpcServiceService;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AppAccountServiceImpl
implements AppAccountService {
    private final RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService;
    private final RmiSaleRpcService rmiSaleRpcService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SysCodeProc
    public StoreAccountCustAppVO selectCustByStore(AccountAppParam accountAppParam) {
        if (StringUtils.isBlank((CharSequence)accountAppParam.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a!");
        }
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOList = this.rmiOrgStoreRpcServiceService.findBaseStoreByCodes(Collections.singletonList(accountAppParam.getStoreCode()));
        if (CollectionUtil.isEmpty(orgStoreBaseRpcDTOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u5230\u95e8\u5e97(" + accountAppParam.getStoreCode() + ")\u4fe1\u606f!");
        }
        StoreAccountCustAppVO storeAccountCustAppVO = new StoreAccountCustAppVO();
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreBaseRpcDTOList.get(0);
        if (StringUtils.isBlank((CharSequence)orgStoreBaseRpcDTO.getCustCode())) {
            return storeAccountCustAppVO;
        }
        storeAccountCustAppVO.setCustCode(orgStoreBaseRpcDTO.getCustCode());
        storeAccountCustAppVO.setCustName(orgStoreBaseRpcDTO.getCustName());
        if (!StringUtils.isNotBlank((CharSequence)storeAccountCustAppVO.getCustCode())) return storeAccountCustAppVO;
        List<CustBaseDTO> custBaseInfoDTOList = this.rmiSaleRpcService.findBaseCustByCodes(Collections.singletonList(storeAccountCustAppVO.getCustCode()));
        if (!CollectionUtil.isNotEmpty(custBaseInfoDTOList)) throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u5ba2\u6237\u4fe1\u606f\u672a\u67e5\u5230!");
        CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
        if (StringUtils.isBlank((CharSequence)custBaseInfoDTO.getPreCustCode())) {
            return storeAccountCustAppVO;
        }
        storeAccountCustAppVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
        if (!StringUtils.isNotBlank((CharSequence)storeAccountCustAppVO.getStoreCustCode())) return storeAccountCustAppVO;
        List<CrmCustBaseDTO> custBaseInfoDTOS = this.rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(storeAccountCustAppVO.getStoreCustCode()));
        if (!CollectionUtil.isNotEmpty(custBaseInfoDTOS)) throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u4e3b\u5ba2\u6237\u4fe1\u606f\u672a\u67e5\u5230!");
        CrmCustBaseDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
        storeAccountCustAppVO.setStoreCustName(custBaseInfoDTO1.getCustName());
        if (!Objects.equals(custBaseInfoDTO1.getInOutCust(), "OUT")) return storeAccountCustAppVO;
        storeAccountCustAppVO.setStoreCustType2Flag(true);
        return storeAccountCustAppVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SysCodeProc
    public StoreAccountCustAppVO selectCheckCustByStore(AccountAppParam accountAppParam) {
        if (StringUtils.isBlank((CharSequence)accountAppParam.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a!");
        }
        List<OrgStoreBaseRpcDTO> orgStoreBaseRpcDTOList = this.rmiOrgStoreRpcServiceService.findBaseStoreByCodes(Collections.singletonList(accountAppParam.getStoreCode()));
        if (CollectionUtil.isEmpty(orgStoreBaseRpcDTOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u5230\u95e8\u5e97(" + accountAppParam.getStoreCode() + ")\u4fe1\u606f!");
        }
        StoreAccountCustAppVO storeAccountCustAppVO = new StoreAccountCustAppVO();
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreBaseRpcDTOList.get(0);
        if (StringUtils.isBlank((CharSequence)orgStoreBaseRpcDTO.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u5ba2\u6237\u4e3a\u7a7a!");
        }
        storeAccountCustAppVO.setCustCode(orgStoreBaseRpcDTO.getCustCode());
        storeAccountCustAppVO.setCustName(orgStoreBaseRpcDTO.getCustName());
        storeAccountCustAppVO.setStoreCustType2Flag(false);
        if (!StringUtils.isNotBlank((CharSequence)storeAccountCustAppVO.getCustCode())) return storeAccountCustAppVO;
        List<CustBaseDTO> custBaseInfoDTOList = this.rmiSaleRpcService.findBaseCustByCodes(Collections.singletonList(storeAccountCustAppVO.getCustCode()));
        if (!CollectionUtil.isNotEmpty(custBaseInfoDTOList)) throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u5ba2\u6237\u672a\u67e5\u5230!");
        CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
        if (StringUtils.isBlank((CharSequence)custBaseInfoDTO.getPreCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u4e3b\u5ba2\u6237\u4e3a\u7a7a!");
        }
        storeAccountCustAppVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
        if (!StringUtils.isNotBlank((CharSequence)storeAccountCustAppVO.getStoreCustCode())) return storeAccountCustAppVO;
        List<CrmCustBaseDTO> custBaseInfoDTOS = this.rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(storeAccountCustAppVO.getStoreCustCode()));
        if (!CollectionUtil.isNotEmpty(custBaseInfoDTOS)) throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7684\u4e3b\u5ba2\u6237\u672a\u67e5\u5230!");
        CrmCustBaseDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
        storeAccountCustAppVO.setStoreCustName(custBaseInfoDTO1.getCustName());
        if (!Objects.equals(custBaseInfoDTO1.getInOutCust(), "OUT")) return storeAccountCustAppVO;
        storeAccountCustAppVO.setStoreCustType2Flag(true);
        return storeAccountCustAppVO;
    }

    public AppAccountServiceImpl(RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService, RmiSaleRpcService rmiSaleRpcService) {
        this.rmiOrgStoreRpcServiceService = rmiOrgStoreRpcServiceService;
        this.rmiSaleRpcService = rmiSaleRpcService;
    }
}

