/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.expense;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.entity.expense.QExpRuleConfigDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpRuleConfigRepoProc {
    private static final Logger log = LoggerFactory.getLogger(ExpRuleConfigRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;

    public void updateEnableFlag(List<Long> ids, boolean enable) {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        this.jpaQueryFactory.update((EntityPath)jpaQDO).set((Path)jpaQDO.enableFlag, (Object)enable).where(new Predicate[]{jpaQDO.id.in(ids)}).execute();
    }

    public void updateDynamically(ExpRuleConfigDO param) {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)jpaQDO);
        if (StringUtils.isNotBlank((CharSequence)param.getRuleCode())) {
            updateClause.set((Path)jpaQDO.ruleCode, (Object)param.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRuleName())) {
            updateClause.set((Path)jpaQDO.ruleName, (Object)param.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getExpTypeCode())) {
            updateClause.set((Path)jpaQDO.calculateType, (Object)param.getExpTypeCode());
        }
        if (param.getEnableFlag() != null) {
            updateClause.set((Path)jpaQDO.enableFlag, (Object)param.getEnableFlag());
        }
        updateClause.set(jpaQDO.modifyTime, (Object)LocalDateTime.now());
        updateClause.where(new Predicate[]{jpaQDO.id.eq((Object)param.getId())}).execute();
    }

    public List<ExpRuleConfigDO> getAllExpRuleConfig(String expTypeCode) {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)jpaQDO).where((Predicate)jpaQDO.expTypeCode.eq((Object)expTypeCode))).fetch();
    }

    public List<ExpRuleConfigDO> getAllEnableExpRuleConfig(String expTypeCode) {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)jpaQDO).where((Predicate)jpaQDO.enableFlag.eq(Boolean.valueOf(true)).and((Predicate)jpaQDO.expTypeCode.eq((Object)expTypeCode)))).fetch();
    }

    public List<ExpRuleConfigDO> getAllEnableExpRuleConfig() {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)jpaQDO).where((Predicate)jpaQDO.enableFlag.eq(Boolean.valueOf(true)))).fetch();
    }

    public List<ExpRuleConfigDO> findExpRuleConfigByExpTypeAndElement(String expTypeCode, String expElement) {
        QExpRuleConfigDO jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)jpaQDO).where((Predicate)jpaQDO.expTypeCode.eq((Object)expTypeCode).and((Predicate)jpaQDO.expElement.eq((Object)expElement)))).fetch();
    }

    public PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param) {
        QExpRuleConfigDO jpaQDo = QExpRuleConfigDO.expRuleConfigDO;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExpRuleConfigPageVO.class, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ruleCode, jpaQDo.ruleName, jpaQDo.expTypeCode, jpaQDo.enableFlag, jpaQDo.createUserId, jpaQDo.creator, jpaQDo.createTime, jpaQDo.modifyUserId, jpaQDo.updater, jpaQDo.modifyTime, jpaQDo.deleteFlag, jpaQDo.tenantId, jpaQDo.auditDataVersion, jpaQDo.remark, jpaQDo.priorityNo, jpaQDo.calculatePercent, jpaQDo.uomAmt, jpaQDo.calculateType})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private Predicate where(ExpRuleConfigQueryParam param) {
        QExpRuleConfigDO jpaQDo = QExpRuleConfigDO.expRuleConfigDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        if (StringUtils.isNotBlank((CharSequence)param.getMultiKeywords())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)jpaQDo.ruleCode.like("%" + param.getMultiKeywords() + "%"), (Predicate)jpaQDo.ruleName.like("%" + param.getMultiKeywords() + "%")));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getExpTypeCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.expTypeCode.eq((Object)param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getRuleName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ruleName.like("%" + param.getRuleName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCalculateType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.calculateType.eq((Object)param.getCalculateType()));
        }
        if (param.getEnableStatus() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.enableFlag.eq(param.getEnableStatus()));
        }
        return predicate;
    }

    public ExpRuleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

