/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.expense;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigConvert;
import com.elitesland.fin.application.convert.expense.ExpRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSortParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigDtlVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.expense.ExpenseConstant;
import com.elitesland.fin.application.service.expense.ExpenseRuleConfigService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.expense.ExpRuleConfigDomainService;
import com.elitesland.fin.domain.service.expense.ExpRuleConfigDtlDomainService;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDtlDO;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigRepoProc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class ExpenseRuleConfigServiceImpl
implements ExpenseRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(ExpenseRuleConfigServiceImpl.class);
    public static final String PLUS = "+";
    private final ExpRuleConfigDomainService expRuleConfigDomainService;
    private final ExpRuleConfigDtlDomainService expRuleConfigDtlDomainService;
    private final RedissonClient redissonClient;
    private final ExpRuleConfigRepo expRuleConfigRepo;
    private final ExpRuleConfigDtlRepo expRuleConfigDtlRepo;
    private final UdcProvider udcProvider;
    private final AccountService accountService;
    private final RedisUtils redisUtils;
    private final ExpRuleConfigRepoProc expRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param) {
        PagingVO<ExpRuleConfigPageVO> ExpRuleConfigPageVOPagingVO = this.expRuleConfigDomainService.searchPage(param);
        log.info("\u8d39\u7528\u8ba1\u7b97\u89c4\u5219,\u5206\u9875\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(ExpRuleConfigPageVOPagingVO));
        Map expTypeMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "EXPENSES_TYPE");
        if (CollectionUtil.isNotEmpty((Collection)ExpRuleConfigPageVOPagingVO.getRecords())) {
            ExpRuleConfigPageVOPagingVO.getRecords().forEach(e -> {
                e.setExpTypeName((String)expTypeMap.get(e.getExpTypeCode()));
                if ("FIXED_PERCENT".equals(e.getCalculateType())) {
                    e.setCalculateStrategy(e.getCalculatePercent());
                } else if ("FIXED_AMT".equals(e.getCalculateType())) {
                    e.setCalculateStrategy(e.getUomAmt());
                }
            });
        }
        return ExpRuleConfigPageVOPagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(ExpRuleConfigSaveParam param) {
        param.setEnableFlag(true);
        this.validateSaveOrUpdateParam(param);
        this.persistence(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(List<ExpRuleConfigSortParam> param) {
        log.info("\u6392\u5e8f\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(param));
        List ids = param.stream().map(BaseModelParam::getId).distinct().collect(Collectors.toList());
        Map<Long, Integer> idPriorityMap = param.stream().collect(Collectors.toMap(BaseModelParam::getId, ExpRuleConfigSortParam::getPriorityNo));
        List data = this.expRuleConfigRepo.findAllById(ids);
        log.info("\u6392\u5e8f\u4fdd\u5b58\u524d\u53c2\u65701:{}", (Object)JSONUtil.toJsonStr((Object)data));
        data.forEach(e -> {
            if (idPriorityMap.containsKey(e.getId())) {
                e.setPriorityNo((Integer)idPriorityMap.get(e.getId()));
            }
        });
        log.info("\u6392\u5e8f\u4fdd\u5b58\u524d\u53c2\u65702:{}", (Object)JSONUtil.toJsonStr((Object)data));
        this.expRuleConfigRepo.saveAll(data);
    }

    private void persistence(ExpRuleConfigSaveParam param) {
        if (param.getId() == null) {
            this.checkExist(param);
            this.saveConfigAndDtl(param);
        } else {
            this.checkExistWhenUpdate(param);
            this.updateConfigAndDtl(param);
        }
    }

    private void checkExist(ExpRuleConfigSaveParam param) {
        log.info("\u6821\u9a8c\u521b\u5efa\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        List<ExpRuleConfigDO> expRuleConfigDOList = this.expRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
        expRuleConfigDOList = this.expRuleConfigRepo.findAllByRuleName(param.getRuleName());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
    }

    private void checkExistWhenUpdate(ExpRuleConfigSaveParam param) {
        log.info("\u6821\u9a8c\u7f16\u8f91\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        List<ExpRuleConfigDO> expRuleConfigDOList = this.expRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        expRuleConfigDOList = expRuleConfigDOList.stream().filter(e -> !e.getId().equals(param.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
        expRuleConfigDOList = this.expRuleConfigRepo.findAllByRuleName(param.getRuleName());
        if (CollectionUtils.isNotEmpty(expRuleConfigDOList = expRuleConfigDOList.stream().filter(e -> !e.getId().equals(param.getId())).collect(Collectors.toList()))) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigDOList.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
    }

    private void checkRepeatData(ExpRuleConfigSaveParam param) {
    }

    private void updateConfigAndDtl(ExpRuleConfigSaveParam param) {
        ExpRuleConfigDO expRuleConfigDO = (ExpRuleConfigDO)this.expRuleConfigRepo.findById(param.getId()).orElseThrow(new BusinessException("\u8be5\u5355\u636e\u4e0d\u5b58\u5728"));
        BeanUtil.copyProperties((Object)param, (Object)expRuleConfigDO, (String[])new String[0]);
        String expElement = this.getExpElement(param);
        this.checkSameElementOnUpdate(param.getExpTypeCode(), expElement, param.getId());
        expRuleConfigDO.setExpElement(expElement);
        log.info("\u4fdd\u5b58\u524d\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)expRuleConfigDO));
        this.expRuleConfigRepo.save(expRuleConfigDO);
        ArrayList<ExpRuleConfigDtlDO> expRuleConfigDtlDOS = new ArrayList<ExpRuleConfigDtlDO>();
        for (ExpRuleConfigDtlDTO dtlDTO : param.getExpRuleConfigDtlDTOList()) {
            for (ExpRuleConfigDtlDTO.RangeObject rangeObject : dtlDTO.getRangeObjects()) {
                ExpRuleConfigDtlDO expRuleConfigDtlDO = new ExpRuleConfigDtlDO();
                expRuleConfigDtlDO.setMasId(expRuleConfigDO.getId());
                expRuleConfigDtlDO.setRangeId(rangeObject.getRangeId());
                expRuleConfigDtlDO.setRangeCode(rangeObject.getRangeCode());
                expRuleConfigDtlDO.setRangeName(rangeObject.getRangeName());
                expRuleConfigDtlDO.setRangeType(dtlDTO.getRangeType());
                expRuleConfigDtlDOS.add(expRuleConfigDtlDO);
            }
        }
        log.info("\u660e\u7ec6\u4fdd\u5b58\u524d\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(expRuleConfigDtlDOS));
        if (CollUtil.isNotEmpty(expRuleConfigDtlDOS)) {
            this.expRuleConfigDtlDomainService.deleteByParam(this.getQueryBeanByMasId(expRuleConfigDO.getId()));
            this.expRuleConfigDtlRepo.saveAll(expRuleConfigDtlDOS);
        }
    }

    private Integer getPriorityNo(String expTypeCode) {
        List<ExpRuleConfigDO> allExpRuleConfig = this.expRuleConfigRepoProc.getAllExpRuleConfig(expTypeCode);
        Optional<Integer> max = allExpRuleConfig.stream().map(ExpRuleConfigDO::getPriorityNo).filter(Objects::nonNull).max(Integer::compareTo);
        return max.orElse(0);
    }

    private void checkSameElementOnSave(String expTypeCode, String expElement) {
        List<ExpRuleConfigDO> expRuleConfigByExpTypeAndElement = this.expRuleConfigRepoProc.findExpRuleConfigByExpTypeAndElement(expTypeCode, expElement);
        if (CollUtil.isNotEmpty(expRuleConfigByExpTypeAndElement)) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigByExpTypeAndElement.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u6392\u5e8f\u5143\u7d20\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
    }

    private void checkSameElementOnUpdate(String expTypeCode, String expElement, Long id) {
        List<ExpRuleConfigDO> expRuleConfigByExpTypeAndElement = this.expRuleConfigRepoProc.findExpRuleConfigByExpTypeAndElement(expTypeCode, expElement);
        if (CollUtil.isNotEmpty(expRuleConfigByExpTypeAndElement = expRuleConfigByExpTypeAndElement.stream().filter(e -> !e.getId().equals(id)).collect(Collectors.toList()))) {
            ExpRuleConfigDO expRuleConfigDO = expRuleConfigByExpTypeAndElement.get(0);
            String ruleCode = expRuleConfigDO.getRuleCode();
            String ruleName = expRuleConfigDO.getRuleName();
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u6392\u5e8f\u5143\u7d20\u7684\u89c4\u5219\uff0c\u7f16\u7801\u4e3a:" + ruleCode + ",\u540d\u79f0\u4e3a:" + ruleName);
        }
    }

    private Long saveConfigAndDtl(ExpRuleConfigSaveParam param) {
        ExpRuleConfigDO expRuleConfigDO = ExpRuleConfigConvert.INSTANCE.param2DO(param);
        String expElement = this.getExpElement(param);
        this.checkSameElementOnSave(param.getExpTypeCode(), expElement);
        expRuleConfigDO.setExpElement(expElement);
        Integer priorityNo = this.getPriorityNo(param.getExpTypeCode());
        expRuleConfigDO.setPriorityNo(priorityNo + 1);
        log.info("\u4fdd\u5b58\u524d\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)expRuleConfigDO));
        this.expRuleConfigRepo.save(expRuleConfigDO);
        ArrayList<ExpRuleConfigDtlDO> expRuleConfigDtlDOS = new ArrayList<ExpRuleConfigDtlDO>();
        for (ExpRuleConfigDtlDTO dtlDTO : param.getExpRuleConfigDtlDTOList()) {
            for (ExpRuleConfigDtlDTO.RangeObject rangeObject : dtlDTO.getRangeObjects()) {
                ExpRuleConfigDtlDO expRuleConfigDtlDO = new ExpRuleConfigDtlDO();
                expRuleConfigDtlDO.setMasId(expRuleConfigDO.getId());
                expRuleConfigDtlDO.setRangeId(rangeObject.getRangeId());
                expRuleConfigDtlDO.setRangeCode(rangeObject.getRangeCode());
                expRuleConfigDtlDO.setRangeName(rangeObject.getRangeName());
                expRuleConfigDtlDO.setRangeType(dtlDTO.getRangeType());
                expRuleConfigDtlDOS.add(expRuleConfigDtlDO);
            }
        }
        log.info("\u660e\u7ec6\u4fdd\u5b58\u524d\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(expRuleConfigDtlDOS));
        if (CollUtil.isNotEmpty(expRuleConfigDtlDOS)) {
            this.expRuleConfigDtlDomainService.deleteByParam(this.getQueryBeanByMasId(expRuleConfigDO.getId()));
            this.expRuleConfigDtlRepo.saveAll(expRuleConfigDtlDOS);
        }
        return expRuleConfigDO.getId();
    }

    private String getExpElement(ExpRuleConfigSaveParam param) {
        String calculateType = param.getCalculateType();
        String rangeTypeStr = param.getExpRuleConfigDtlDTOList().stream().map(ExpRuleConfigDtlDTO::getRangeType).collect(Collectors.joining(PLUS));
        return calculateType + PLUS + rangeTypeStr;
    }

    private void validateSaveOrUpdateParam(ExpRuleConfigSaveParam param) {
        Assert.notEmpty((CharSequence)param.getRuleCode(), (String)"\u89c4\u5219\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getExpTypeCode(), (String)"\u8d39\u7528\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getCalculateType(), (String)"\u8ba1\u7b97\u65b9\u5f0f\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.isAutomaticReview(), (String)"\u53f0\u8d26\u81ea\u52a8\u5ba1\u6838\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getValidDate(), (String)"\u751f\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getEnableFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        Optional<ExpRuleConfigDO> expRuleConfigDOOptional = this.expRuleConfigDomainService.findById(id);
        String expTypeCode = null;
        if (expRuleConfigDOOptional.isPresent()) {
            this.expRuleConfigDomainService.deleteById(id);
            expTypeCode = expRuleConfigDOOptional.get().getExpTypeCode();
            List<ExpRuleConfigDO> all = this.expRuleConfigRepoProc.getAllExpRuleConfig(expTypeCode);
            List<ExpRuleConfigDO> sortedList = all.stream().sorted(Comparator.comparing(ExpRuleConfigDO::getPriorityNo, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            log.info("\u5168\u5c40\u91cd\u65b0\u6392\u5e8f\u540e1:{}", (Object)JSONUtil.toJsonStr(sortedList));
            this.updatePriorityNo(sortedList);
        }
    }

    public void updatePriorityNo(List<ExpRuleConfigDO> sortedList) {
        for (int i = 0; i < sortedList.size(); ++i) {
            sortedList.get(i).setPriorityNo(i + 1);
        }
        log.info("\u5168\u5c40\u91cd\u65b0\u6392\u5e8f\u540e2:{}", (Object)JSONUtil.toJsonStr(sortedList));
        this.expRuleConfigRepo.saveAll(sortedList);
    }

    private ExpRuleConfigDtlDO getQueryBeanByMasId(Long id) {
        ExpRuleConfigDtlDO whereBean = new ExpRuleConfigDtlDO();
        whereBean.setMasId(id);
        return whereBean;
    }

    @Override
    @SysCodeProc
    public ExpRuleConfigQueryVO detail(Long id) {
        Optional dbConfig = this.expRuleConfigRepo.findById(id);
        if (dbConfig.isEmpty()) {
            return null;
        }
        ExpRuleConfigQueryVO queryVO = ExpRuleConfigConvert.INSTANCE.do2VO((ExpRuleConfigDO)dbConfig.get());
        log.info("\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u8be6\u60c5:{}", (Object)JSONUtil.toJsonStr((Object)queryVO));
        Map calTypeMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "CAL_TYPE");
        queryVO.setExpTypeName((String)calTypeMap.get(queryVO.getExpTypeCode()));
        ArrayList<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList = new ArrayList<ExpRuleConfigDtlDTO>();
        List<ExpRuleConfigDtlDO> dtlData = this.expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasId(id);
        Map<String, List<ExpRuleConfigDtlDO>> groupedData = dtlData.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getRangeType));
        log.info("\u89c4\u5219\u660e\u7ec6\u5206\u7ec4\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(groupedData));
        for (Map.Entry<String, List<ExpRuleConfigDtlDO>> entry : groupedData.entrySet()) {
            ExpRuleConfigDtlDTO expRuleConfigDtlDTO = new ExpRuleConfigDtlDTO();
            String rangeType = entry.getKey();
            expRuleConfigDtlDTO.setRangeType(rangeType);
            ArrayList<ExpRuleConfigDtlDTO.RangeObject> rangeObjects = new ArrayList<ExpRuleConfigDtlDTO.RangeObject>();
            for (ExpRuleConfigDtlDO expRuleConfigDtlDO : entry.getValue()) {
                ExpRuleConfigDtlDTO.RangeObject objectDTO = new ExpRuleConfigDtlDTO.RangeObject();
                objectDTO.setRangeId(expRuleConfigDtlDO.getRangeId());
                objectDTO.setRangeCode(expRuleConfigDtlDO.getRangeCode());
                objectDTO.setRangeName(expRuleConfigDtlDO.getRangeName());
                rangeObjects.add(objectDTO);
            }
            expRuleConfigDtlDTO.setRangeObjects(rangeObjects);
            expRuleConfigDtlDTOList.add(expRuleConfigDtlDTO);
        }
        queryVO.setExpRuleConfigDtlDTOList(expRuleConfigDtlDTOList);
        return queryVO;
    }

    @Override
    @SysCodeProc
    public List<ExpRuleConfigQueryVO> getList(String code) {
        List<ExpRuleConfigDO> allExpRuleConfig = this.expRuleConfigRepoProc.getAllExpRuleConfig(code);
        List<Long> ruleIds = allExpRuleConfig.stream().map(BaseModel::getId).collect(Collectors.toList());
        log.info("\u6240\u6709\u72b6\u6001\u7684\u89c4\u5219\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(allExpRuleConfig));
        List<ExpRuleConfigQueryVO> dataToReturn = ExpRuleConfigConvert.INSTANCE.do2VOBatch(allExpRuleConfig);
        log.info("\u6dfb\u52a0\u8be6\u60c5\u524d:{}", (Object)JSONUtil.toJsonStr(dataToReturn));
        List<ExpRuleConfigDtlDO> dtlData = this.expRuleConfigDtlDomainService.findExpRuleConfigDtlByMasIdsIn(ruleIds);
        Map<Long, List<ExpRuleConfigDtlDO>> groupByMasId = dtlData.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getMasId));
        log.info("\u89c4\u5219\u660e\u7ec6\u6570\u636e,\u6309\u89c4\u5219id\u5206\u7ec4:{}", (Object)JSONUtil.toJsonStr(groupByMasId));
        for (ExpRuleConfigQueryVO expRuleConfigQueryVO : dataToReturn) {
            ArrayList<ExpRuleConfigDtlDTO> expRuleConfigDtlDTOList = new ArrayList<ExpRuleConfigDtlDTO>();
            List<ExpRuleConfigDtlDO> dtlDOS = groupByMasId.get(expRuleConfigQueryVO.getId());
            expRuleConfigQueryVO.setExpElementName(this.getElementName(expRuleConfigQueryVO.getExpElement()));
            if (CollUtil.isEmpty(dtlDOS)) continue;
            Map<String, List<ExpRuleConfigDtlDO>> groupedData = dtlDOS.stream().collect(Collectors.groupingBy(ExpRuleConfigDtlDO::getRangeType));
            log.info("\u89c4\u5219\u660e\u7ec6\u6309\u6761\u4ef6\u5206\u7ec4\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(groupedData));
            for (Map.Entry<String, List<ExpRuleConfigDtlDO>> entry : groupedData.entrySet()) {
                ExpRuleConfigDtlDTO expRuleConfigDtlDTO = new ExpRuleConfigDtlDTO();
                String rangeType = entry.getKey();
                expRuleConfigDtlDTO.setRangeType(rangeType);
                ArrayList<ExpRuleConfigDtlDTO.RangeObject> rangeObjects = new ArrayList<ExpRuleConfigDtlDTO.RangeObject>();
                for (ExpRuleConfigDtlDO expRuleConfigDtlDO : entry.getValue()) {
                    ExpRuleConfigDtlDTO.RangeObject objectDTO = new ExpRuleConfigDtlDTO.RangeObject();
                    objectDTO.setRangeId(expRuleConfigDtlDO.getRangeId());
                    objectDTO.setRangeCode(expRuleConfigDtlDO.getRangeCode());
                    objectDTO.setRangeName(expRuleConfigDtlDO.getRangeName());
                    rangeObjects.add(objectDTO);
                }
                expRuleConfigDtlDTO.setRangeObjects(rangeObjects);
                expRuleConfigDtlDTOList.add(expRuleConfigDtlDTO);
            }
            expRuleConfigQueryVO.setExpRuleConfigDtlDTOList(expRuleConfigDtlDTOList);
        }
        log.info("\u6dfb\u52a0\u8be6\u60c5\u540e:{}", (Object)JSONUtil.toJsonStr(dataToReturn));
        return dataToReturn;
    }

    private String getElementName(String element) {
        if (element == null || element.isEmpty()) {
            return "";
        }
        return Arrays.stream(element.split("\\+")).map(key -> ExpenseConstant.elementNameMapping.getOrDefault(key, (String)key)).collect(Collectors.joining(PLUS));
    }

    @Override
    public List<ExpRuleConfigQueryVO> getExpTypeList() {
        List<ExpRuleConfigDO> allEnableExpRuleConfig = this.expRuleConfigRepoProc.getAllEnableExpRuleConfig();
        log.info("\u6240\u6709\u542f\u7528\u72b6\u6001\u7684\u89c4\u5219\u6570\u636e:{}", (Object)JSONUtil.toJsonStr(allEnableExpRuleConfig));
        List<ExpRuleConfigDO> distinctExpRuleConfig = allEnableExpRuleConfig.stream().collect(Collectors.collectingAndThen(Collectors.toMap(ExpRuleConfigDO::getExpTypeCode, expRuleConfig -> expRuleConfig, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
        distinctExpRuleConfig = distinctExpRuleConfig.stream().sorted(Comparator.comparingInt(ExpRuleConfigDO::getPriorityNo)).collect(Collectors.toList());
        return ExpRuleConfigConvert.INSTANCE.do2VOBatch(distinctExpRuleConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEnableFlag(List<Long> ids, boolean enable) {
        List<ExpRuleConfigDO> configDOList = this.expRuleConfigDomainService.findByIds(ids);
        if (enable) {
            this.checkEnableRule(configDOList);
        }
        if (!enable) {
            this.checkStopRule(configDOList);
        }
        Boolean res = this.expRuleConfigDomainService.updateEnableFlag(ids, enable);
    }

    public void detailCode2Name(List<ExpRuleConfigDtlVO> expRuleConfigDtlVOList) {
        Map docClsUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(), UdcEnum.DOC_CLS_SO_C.getCode());
        Map docStatusUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(), UdcEnum.DOC_STATUS_RSO_CL.getCode());
        Map accountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        HashSet<String> accountCodeSet = new HashSet<String>();
        expRuleConfigDtlVOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split("\\+");
                Arrays.stream(specificAccountArray).forEach(specificAccount -> accountCodeSet.add((String)specificAccount));
            }
        });
        List<Object> accountDTOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(accountCodeSet)) {
            AccountParam accountParam = new AccountParam();
            accountParam.setAccountCodes(accountCodeSet);
            accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
            Assert.notEmpty(accountDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u540d\u79f0\u5931\u8d25", (Object[])new Object[0]);
        }
        ArrayList optDocTypeList = new ArrayList();
        ArrayList specificAccountList = new ArrayList();
        ArrayList finalAccountDTOList = accountDTOList;
        expRuleConfigDtlVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            specificAccountList.clear();
            String[] optDocTypeArray = item.getOptDocType().split("\\+");
            Arrays.stream(optDocTypeArray).forEach(optDocType -> optDocTypeList.add((String)docClsUdc.get(optDocType)));
            if (StringUtils.isNotEmpty((CharSequence)item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split("\\+");
                Arrays.stream(specificAccountArray).forEach(specificAccount -> {
                    AccountDTO result = finalAccountDTOList.stream().filter(accountVO -> specificAccount.equals(accountVO.getAccountCode())).findFirst().orElse(null);
                    if (result != null) {
                        specificAccountList.add(result.getAccountName());
                    }
                });
            }
            item.setOptDocTypeName(this.joinedWithPlus(optDocTypeList));
            if (CollectionUtils.isNotEmpty((Collection)specificAccountList)) {
                item.setSpecificAccountName(this.joinedWithPlus(specificAccountList));
            }
            item.setOptDocStatusName((String)docStatusUdc.get(item.getOptDocStatus()));
            item.setOptAccountTypeName((String)accountTypeUdc.get(item.getOptAccountType()));
        });
    }

    public void pageCode2Name(List<ExpRuleConfigPageVO> expRuleConfigPageVOList) {
    }

    private String joinedWithPlus(List<String> param) {
        return StringUtils.join(param, (String)PLUS);
    }

    private void removeCache(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public ExpRuleConfigDTO getByRuleCode(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            return (ExpRuleConfigDTO)bucket.get();
        }
        ExpRuleConfigDTO dbConfig = this.expRuleConfigDomainService.findByRuleCode(ruleCode);
        if (dbConfig != null) {
            Example dtlExample = Example.of((Object)this.getQueryBeanByMasId(dbConfig.getId()));
            List<ExpRuleConfigDtlDO> all = this.expRuleConfigDtlDomainService.findAll(dtlExample);
            List<ExpRuleConfigDtlDTO> expRuleConfigDtls = ExpRuleConfigDtlConvert.INSTANCE.do2DTOList(all);
            dbConfig.setExpRuleConfigDtlDTOList(expRuleConfigDtls);
            bucket.set((Object)dbConfig);
            return dbConfig;
        }
        return null;
    }

    @Override
    public PagingVO<ExpRuleConfigPageVO> searchPageWithOutName(ExpRuleConfigQueryParam param) {
        PagingVO<ExpRuleConfigPageVO> expRuleConfigPageVOPagingVO = this.expRuleConfigDomainService.searchPage(param);
        if (CollectionUtil.isNotEmpty((Collection)expRuleConfigPageVOPagingVO.getRecords())) {
            this.convertPage(expRuleConfigPageVOPagingVO.getRecords());
        }
        this.pageCode2Name(expRuleConfigPageVOPagingVO.getRecords());
        return expRuleConfigPageVOPagingVO;
    }

    private void convertPage(List<ExpRuleConfigPageVO> expRuleConfigDtls) {
    }

    private void checkStopRule(List<ExpRuleConfigDO> configDOList) {
        for (ExpRuleConfigDO expRuleConfigDO : configDOList) {
            if (expRuleConfigDO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u505c\u7528");
        }
    }

    private void checkEnableRule(List<ExpRuleConfigDO> configDOList) {
        for (ExpRuleConfigDO expRuleConfigDO : configDOList) {
            if (!expRuleConfigDO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u542f\u52a8");
        }
    }

    public ExpenseRuleConfigServiceImpl(ExpRuleConfigDomainService expRuleConfigDomainService, ExpRuleConfigDtlDomainService expRuleConfigDtlDomainService, RedissonClient redissonClient, ExpRuleConfigRepo expRuleConfigRepo, ExpRuleConfigDtlRepo expRuleConfigDtlRepo, UdcProvider udcProvider, AccountService accountService, RedisUtils redisUtils, ExpRuleConfigRepoProc expRuleConfigRepoProc) {
        this.expRuleConfigDomainService = expRuleConfigDomainService;
        this.expRuleConfigDtlDomainService = expRuleConfigDtlDomainService;
        this.redissonClient = redissonClient;
        this.expRuleConfigRepo = expRuleConfigRepo;
        this.expRuleConfigDtlRepo = expRuleConfigDtlRepo;
        this.udcProvider = udcProvider;
        this.accountService = accountService;
        this.redisUtils = redisUtils;
        this.expRuleConfigRepoProc = expRuleConfigRepoProc;
    }
}

