/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecHeadSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecHeadVO;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyRecHeadService;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecHeadDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepo;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecHeadRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class FinArRecVerApplyRecHeadServiceImpl
implements FinArRecVerApplyRecHeadService {
    private final FinArRecVerApplyRecHeadRepoProc finArRecVerApplyRecHeadRepoProc;
    private final FinArRecVerApplyRecHeadRepo finArRecVerApplyRecHeadRepo;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    public Long create(Long masId, FinArRecVerApplyRecHeadSaveDTO param) {
        List<RecOrderDTO> recOrderDTOList;
        HashMap recOrderMap;
        RecOrderDTO recOrderDTO;
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        FinArRecVerApplyRecHeadDO entity = FinArRecVerApplyRecHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        if ((StringUtils.isBlank((CharSequence)entity.getInOutCust()) || StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode())) && Objects.nonNull(recOrderDTO = (RecOrderDTO)(recOrderMap = CollectionUtil.isEmpty(recOrderDTOList = this.recOrderRepoProc.selectInOutCustByRecOrderNo(Collections.singletonList(entity.getRecOrderNo()))) ? new HashMap() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1))).get(entity.getRecOrderNo()))) {
            String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? recOrderDTO.getInOutCust() : entity.getInOutCust();
            String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
            entity.setInOutCust(inOutCust);
            entity.setRelevanceOuCode(relevanceOuCode);
        }
        this.flexFieldUtilService.handFlexFieldValueFeference("FIN_AR_REC_VER_APPLY_REC_HEAD", (Object)entity);
        return ((FinArRecVerApplyRecHeadDO)((Object)this.finArRecVerApplyRecHeadRepo.save((Object)entity))).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finArRecVerApplyRecHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecHeadVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = this.finArRecVerApplyRecHeadRepoProc.listByMasIds(masIds).stream().map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finArRecVerApplyRecHeadVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyRecHeadVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finArRecVerApplyRecHeadVOList;
    }

    @Override
    public List<FinArRecVerApplyRecHeadVO> listByIds(Collection<Long> ids, FinArRecVerApplyQuery query) {
        return this.finArRecVerApplyRecHeadRepoProc.listByIds(ids, query).stream().map(FinArRecVerApplyRecHeadConvert.INSTANCE::DO2VO).collect(Collectors.toList());
    }

    public FinArRecVerApplyRecHeadServiceImpl(FinArRecVerApplyRecHeadRepoProc finArRecVerApplyRecHeadRepoProc, FinArRecVerApplyRecHeadRepo finArRecVerApplyRecHeadRepo, FlexFieldUtilService flexFieldUtilService, RecOrderRepoProc recOrderRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.finArRecVerApplyRecHeadRepoProc = finArRecVerApplyRecHeadRepoProc;
        this.finArRecVerApplyRecHeadRepo = finArRecVerApplyRecHeadRepo;
        this.flexFieldUtilService = flexFieldUtilService;
        this.recOrderRepoProc = recOrderRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

