/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountIocConvert;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocRespVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocSaveVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.account.AccountIocDomainService;
import com.elitesland.fin.entity.account.AccountIoc;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountIocServiceImpl
implements AccountIocService {
    private static final Logger log = LoggerFactory.getLogger(AccountIocServiceImpl.class);
    private final AccountIocDomainService accountIocDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> createOne(AccountIocSaveVO saveVo) {
        AccountIoc accountIoc = AccountIocConvert.INSTANCE.saveVoToEn(saveVo);
        if (StringUtils.isEmpty((CharSequence)accountIoc.getStatus())) {
            accountIoc.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
        this.checkIocMandatory(accountIoc);
        this.checkIocCodeAndName(accountIoc);
        Long id = this.accountIocDomainService.saveAccountIoc(accountIoc, Optional.empty());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(AccountIocSaveVO saveVo) {
        Optional<AccountIocDTO> iocDTOOptional = this.accountIocDomainService.findById(saveVo.getId());
        if (iocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4e8b\u52a1\u7801\u4fe1\u606f!");
        }
        AccountIoc accountIoc = AccountIocConvert.INSTANCE.saveVoToEn(saveVo);
        this.checkIocMandatory(accountIoc);
        this.checkIocCodeAndName(accountIoc);
        Long id = this.accountIocDomainService.saveAccountIoc(accountIoc, iocDTOOptional);
        return ApiResult.ok((Object)id);
    }

    private void checkIocMandatory(AccountIoc accountIoc) {
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoCode())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoName())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7801\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoTypeName())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getIoType())) {
            throw new BusinessException(ApiCode.FAIL, "\u4e8b\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)accountIoc.getStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u662f\u5426\u542f\u7528\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    private void checkIocCodeAndName(AccountIoc accountIoc) {
        HashSet<String> ioCodeSet = new HashSet<String>();
        ioCodeSet.add(accountIoc.getIoCode());
        AccountIocParam accountIocParam = new AccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        List<AccountIocDTO> accountIocDTOList = this.accountIocDomainService.queryByAccountIocParam(accountIocParam);
        AccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(dto -> StringUtils.equals((CharSequence)accountIoc.getIoCode(), (CharSequence)dto.getIoCode())).findFirst().orElse(null);
        if (accountIocDTO != null) {
            Assert.equals((Object)accountIoc.getId(), (Object)accountIocDTO.getId(), (String)"\u8d26\u6237\u4e8b\u52a1\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        HashSet<String> ioNameSet = new HashSet<String>();
        ioNameSet.add(accountIoc.getIoName());
        accountIocParam = new AccountIocParam();
        accountIocParam.setIoNameSet(ioNameSet);
        List<AccountIocDTO> accountIocNameList = this.accountIocDomainService.queryByAccountIocParam(accountIocParam);
        accountIocDTO = accountIocNameList.stream().filter(dto -> StringUtils.equals((CharSequence)accountIoc.getIoName(), (CharSequence)dto.getIoName())).findFirst().orElse(null);
        if (accountIocDTO != null) {
            Assert.equals((Object)accountIoc.getId(), (Object)accountIocDTO.getId(), (String)"\u4e8b\u52a1\u7801\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    @SysCodeProc
    public ApiResult<AccountIocRespVO> findIdOne(Long id) {
        Optional<AccountIocDTO> accountIocDTOOptional = this.accountIocDomainService.findById(id);
        if (accountIocDTOOptional.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4e8b\u52a1\u7801\u4fe1\u606f!");
        }
        AccountIocDTO accountIocDTO = accountIocDTOOptional.get();
        AccountIocRespVO accountIocRespVO = AccountIocConvert.INSTANCE.dtoToRespVo(accountIocDTO);
        return ApiResult.ok((Object)accountIocRespVO);
    }

    @Override
    @SysCodeProc
    public Optional<AccountIocRespVO> findByCode(String code) {
        Optional<AccountIocDTO> accountDTOOptional = this.accountIocDomainService.findByCode(code);
        if (accountDTOOptional.isEmpty()) {
            return Optional.empty();
        }
        AccountIocDTO accountIocDTO = accountDTOOptional.get();
        AccountIocRespVO accountIocRespVO = AccountIocConvert.INSTANCE.dtoToRespVo(accountIocDTO);
        return Optional.of(accountIocRespVO);
    }

    @Override
    @SysCodeProc
    public List<AccountIocRespVO> findByCodeBatch(List<String> codeList) {
        List<AccountIocDTO> accountIocDTOList = this.accountIocDomainService.findByCodeBatch(codeList);
        if (CollectionUtils.isEmpty(accountIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<AccountIocRespVO> accountIocRespVOList = accountIocDTOList.stream().map(AccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return accountIocRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountIocRespVO> search(AccountIocParamVO param) {
        PagingVO<AccountIocDTO> pagingVo = this.accountIocDomainService.search(param);
        if (CollectionUtils.isEmpty((Collection)pagingVo.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List whAreaSettingRespVOList = vos.stream().map(AccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return PagingVO.builder().total(pagingVo.getTotal()).records(whAreaSettingRespVOList).build();
    }

    @Override
    @SysCodeProc
    public List<AccountIocRespVO> select(AccountIocParamVO param) {
        List<AccountIocDTO> accountIocDTOList = this.accountIocDomainService.selectByParam(param);
        if (CollectionUtils.isEmpty(accountIocDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<AccountIocRespVO> accountIocRespVOList = accountIocDTOList.stream().map(AccountIocConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
        return accountIocRespVOList;
    }

    @Override
    public List<AccountIocDTO> queryByAccountIocParam(AccountIocParam accountIocParam) {
        return this.accountIocDomainService.queryByAccountIocParam(accountIocParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> deleteBatch(List<Long> ids) {
        this.accountIocDomainService.updateDeleteFlagByIds(1, ids);
        return ApiResult.ok();
    }

    public AccountIocServiceImpl(AccountIocDomainService accountIocDomainService) {
        this.accountIocDomainService = accountIocDomainService;
    }
}

