/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeConvert;
import com.elitesland.fin.domain.expense.ExpType;
import com.elitesland.fin.domain.expense.ExpTypeDO;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import com.elitesland.fin.domain.service.expense.ExpTypeDomainService;
import com.elitesland.fin.domain.service.expense.ExpTypeDtlDomainService;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExpTypeDomainServiceImpl
implements ExpTypeDomainService {
    private static final Logger log = LoggerFactory.getLogger(ExpTypeDomainServiceImpl.class);
    private final ExpTypeRepo expTypeRepo;
    private final ExpTypeRepoProc expTypeRepoProc;
    private final ExpTypeDtlDomainService expTypeDtlDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ExpType expType) {
        expType.checkNotNull();
        expType.setDefaultValue();
        this.checkExpType(expType);
        Boolean isExistName = this.expTypeRepoProc.existsName(expType.getExpTypeName());
        if (isExistName.booleanValue()) {
            throw new BusinessException("\u8d39\u7528\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Boolean isExistCode = this.expTypeRepoProc.existsCode(expType.getExpTypeCode());
        if (isExistCode.booleanValue()) {
            throw new BusinessException("\u8d39\u7528\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        ExpTypeDO res = (ExpTypeDO)this.expTypeRepo.save(ExpTypeConvert.INSTANCE.convert(expType));
        Long masId = res.getId();
        if (Objects.nonNull(expType.getId())) {
            this.expTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(expType.getId()));
        }
        if (CollectionUtil.isNotEmpty(expType.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expType.getDtlList();
            expTypeDtlList.forEach(expTypeDtl -> expTypeDtl.setMasId(masId));
            this.expTypeDtlDomainService.save(expTypeDtlList);
        }
        return masId;
    }

    @Override
    @SysCodeProc
    public ExpTypeDTO get(Long id) {
        ExpTypeDTO res = this.expTypeRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExpTypeDTO> page(ExpTypePageParam expTypePageParam) {
        ArrayList<Long> exptypeIds = new ArrayList<Long>();
        PagingVO<ExpTypeDTO> res = this.expTypeRepoProc.page(expTypePageParam, exptypeIds);
        return res;
    }

    @Override
    public List<ExpTypeDTO> findByIds(List<Long> ids) {
        List<ExpTypeDTO> res = this.expTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateEnableFlag(List<Long> ids, boolean enable) {
        this.expTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ExpTypeDTO expTypeDTO = this.expTypeRepoProc.findById(id);
        if (expTypeDTO.getEnableFlag().booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e");
        }
        Long res = this.expTypeRepoProc.del(id);
        return res;
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDTO> getList() {
        List<ExpTypeDTO> res = this.expTypeRepoProc.getList();
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ExpType expType) {
        expType.checkNotNull();
        this.checkExpType(expType);
        Assert.notNull((Object)expType.getEnableFlag(), (String)"enableFlag is null", (Object[])new Object[0]);
        ExpTypeDO res = (ExpTypeDO)this.expTypeRepo.save(ExpTypeConvert.INSTANCE.convert(expType));
        Long masId = res.getId();
        if (Objects.nonNull(expType.getId())) {
            this.expTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(expType.getId()));
        }
        if (CollectionUtil.isNotEmpty(expType.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expType.getDtlList();
            expTypeDtlList.forEach(expTypeDtl -> expTypeDtl.setMasId(masId));
            this.expTypeDtlDomainService.save(expTypeDtlList);
        }
        return masId;
    }

    private void checkExpType(ExpType expType) {
    }

    private String arSpliceGroupKey(String sourceDoc, String sourceDocType, String sourceDocStatus) {
        String spliceGroupKey = sourceDoc + "-" + sourceDocType + "-" + sourceDocStatus;
        return spliceGroupKey;
    }

    public ExpTypeDomainServiceImpl(ExpTypeRepo expTypeRepo, ExpTypeRepoProc expTypeRepoProc, ExpTypeDtlDomainService expTypeDtlDomainService) {
        this.expTypeRepo = expTypeRepo;
        this.expTypeRepoProc = expTypeRepoProc;
        this.expTypeDtlDomainService = expTypeDtlDomainService;
    }
}

