/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvSumDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.fin.infr.factory.saleinv.SaleInvFactory;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.workflow.ProcessInfo;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SaleInvDomainServiceImpl
implements SaleInvDomainService {
    public final SaleInvRepoProc saleInvRepoProc;
    public final SaleInvRepo saleInvRepo;
    public final SaleInvDtlRepoProc saleInvDtlRepoProc;
    public final SaleInvDtlRepo saleInvDtlRepo;
    public final SaleInvdDtlRepoProc saleInvdDtlRepoProc;
    public final SaleInvdDtlRepo saleInvdDtlRepo;
    public final SaleInvFactory saleInvFactory;
    private final SeqNumProvider sysNumberRuleService;
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;

    @Override
    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam) {
        PagingVO<SaleInvDTO> res = this.saleInvFactory.page(saleInvPageParam);
        return res;
    }

    @Override
    public SaleInvSumDTO selectListSum(SaleInvPageParam param) {
        SaleInvSumDTO saleInvSumDTO = this.saleInvFactory.selectListSum(param);
        return saleInvSumDTO;
    }

    @Override
    public ApiResult<Set<String>> getInvNosByDocNos(List<String> docNos) {
        HashSet<String> invNoSets = new HashSet<String>();
        List<SaleInvDtlDTO> saleInvDtlDTOList = this.saleInvDtlRepoProc.queryDocNos(docNos);
        if (CollectionUtil.isNotEmpty(saleInvDtlDTOList)) {
            for (SaleInvDtlDTO saleInvDtlDTO : saleInvDtlDTOList) {
                String invNo = saleInvDtlDTO.getInvNo();
                if (!StringUtils.hasText((String)invNo)) continue;
                invNoSets.add(invNo);
            }
        }
        return ApiResult.ok(invNoSets);
    }

    @Override
    public ApiResult<Set<String>> querySaleInvNosBySaleReconciliatIds(List<Long> ids) {
        List<Long> invoiceAwaitIds;
        List<SaleInvDtlDO> saleInvDtlDOList;
        HashSet<String> invNoSets = new HashSet<String>();
        List<InvoiceAwaitDDO> invoiceAwaitDOList = this.invoiceAwaitDRepo.findAllByOptDocDtlIdIn(ids);
        if (CollectionUtil.isNotEmpty(invoiceAwaitDOList) && CollectionUtil.isNotEmpty(saleInvDtlDOList = this.saleInvDtlRepo.findAllBySourceLineIdIn(invoiceAwaitIds = invoiceAwaitDOList.stream().map(invoiceAwaitDDO -> invoiceAwaitDDO.getId()).collect(Collectors.toList())))) {
            for (SaleInvDtlDO saleInvDtlDO : saleInvDtlDOList) {
                if (!StringUtils.hasText((String)saleInvDtlDO.getInvNo())) continue;
                invNoSets.add(saleInvDtlDO.getInvNo());
            }
        }
        return ApiResult.ok(invNoSets);
    }

    @Override
    public SaleInvDTO get(Long id) {
        SaleInvDTO res = this.saleInvRepoProc.get(id);
        List<SaleInvDtlDTO> saleInvDtlDTOList = this.saleInvDtlRepoProc.queryByMasId(id);
        res.setSaleInvDtlDTOList(saleInvDtlDTOList);
        return res;
    }

    @Override
    @Transactional
    public Long save(SaleInv saleInv) {
        if (!UdcEnum.APPLY_STATUS_DRAFT.getValueCode().equals(saleInv.getOrderState())) {
            throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u65b0\u589e");
        }
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    @Transactional
    public Long del(List<Long> ids) {
        ids.forEach(x -> {
            SaleInvDTO saleInvDTO = this.saleInvRepoProc.get((Long)x);
            if (!saleInvDTO.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664\u64cd\u4f5c");
            }
        });
        Long res = this.saleInvRepoProc.del(ids);
        this.saleInvDtlRepoProc.delByMasId(ids);
        return res;
    }

    @Override
    @Transactional
    public Long update(SaleInv saleInv) {
        if (!UdcEnum.APPLY_STATUS_DRAFT.getValueCode().equals(saleInv.getOrderState())) {
            throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91");
        }
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    @Transactional
    public Long submit(SaleInv saleInv) {
        saleInv.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        saleInv.checkAmt();
        saleInv.checkAmtSum();
        SaleInvDO saleInvDO = this.saveOrUpdate(saleInv);
        return saleInvDO.getId();
    }

    @Override
    public List<SaleInvdDtlDTO> getInvdLists(Long masId) {
        List<SaleInvdDtlDTO> list = this.saleInvdDtlRepoProc.getList(masId);
        return list;
    }

    @Override
    @Transactional
    public Long updateInvInfo(SaleInvParam saleInvParam) {
        Long res = this.saleInvRepoProc.updateInvInfo(saleInvParam);
        return res;
    }

    @Override
    @Transactional
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.saleInvRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Transactional
    public SaleInvDO saveOrUpdate(SaleInv saleInv) {
        saleInv.check();
        saleInv.checkDtl();
        if (CharSequenceUtil.isBlank((CharSequence)saleInv.getApplyNo())) {
            String applyNo = this.sysNumberRuleService.generateCode("yst-fin", "XXFP", null);
            saleInv.setApplyNo(applyNo);
        }
        SaleInvDO saleInvDO = (SaleInvDO)this.saleInvRepo.save(SaleInvConvert.INSTANCE.convert(saleInv));
        this.saleInvDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{saleInvDO.getId()}));
        List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
        List<SaleInvDtlDO> saleInvDtlDOS = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
        saleInvDtlDOS.stream().forEach(x -> {
            x.setMasId(saleInvDO.getId());
            this.saleInvDtlRepo.save(x);
        });
        if (CollUtil.isNotEmpty(saleInv.getSaleInvdDtls())) {
            List<SaleInvdDtlDO> saleInvdDtlDOS = SaleInvConvert.INSTANCE.convertInvd(saleInv.getSaleInvdDtls());
            saleInvdDtlDOS.stream().forEach(x -> {
                x.setMasId(saleInvDO.getId());
                this.saleInvdDtlRepo.save(x);
            });
        }
        return saleInvDO;
    }

    @Override
    public SaleInvVO queryAmt() {
        return this.saleInvRepoProc.queryAmt();
    }

    public SaleInvDomainServiceImpl(SaleInvRepoProc saleInvRepoProc, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, SaleInvdDtlRepoProc saleInvdDtlRepoProc, SaleInvdDtlRepo saleInvdDtlRepo, SaleInvFactory saleInvFactory, SeqNumProvider sysNumberRuleService, InvoiceAwaitRepoProc invoiceAwaitRepoProc, InvoiceAwaitRepo invoiceAwaitRepo, InvoiceAwaitDRepo invoiceAwaitDRepo) {
        this.saleInvRepoProc = saleInvRepoProc;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.saleInvdDtlRepoProc = saleInvdDtlRepoProc;
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.saleInvFactory = saleInvFactory;
        this.sysNumberRuleService = sysNumberRuleService;
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
    }
}

