/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.invoice.await;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.dto.invoice.InvoiceAwaitRpcAutoDTO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.provider.invoice.await.InvoiceAwaitSaveServiceFactory;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.service.invoice.InvoiceAwaitRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay"})
public class InvoiceAwaitRpcServiceImpl
implements InvoiceAwaitRpcService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitRpcServiceImpl.class);
    private final InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final SystemRpcService systemRpcService;
    private final InvoiceAwaitService invoiceAwaitService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(InvoiceAwaitSaveParam param) {
        log.info("\u5f00\u59cb\u7ec4\u88c5\u4ed8\u6b3e\u8bb0\u5f55\u6570\u636e\uff0c\u63a5\u6536\u5230\u7684\u53c2\u6570\u4e3a" + JSON.toJSONString((Object)param));
        ApiResult<Long> result = this.checkSaveParam(param);
        if (ObjectUtil.isNotNull(result)) {
            return result;
        }
        Long id = this.saveInvoiceAwait(param);
        param.getOptDocType();
        param.getOptDocCls();
        param.getOptDocStatus();
        return ApiResult.ok((Object)id);
    }

    private ApiResult<Long> checkSaveParam(InvoiceAwaitSaveParam param) {
        if (Strings.isEmpty((CharSequence)param.getOptDocType())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isEmpty((CharSequence)param.getOptDocNo())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isEmpty((CharSequence)param.getOptDocStatus())) {
            return ApiResult.fail((String)"\u53ef\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.invoiceAwaitRepo.existsByOptDocNoAndOptDocType(param.getOptDocNo(), param.getOptDocType())) {
            return ApiResult.fail((String)"\u6765\u6e90\u5355\u636e\u5df2\u7ecf\u7533\u8bf7\u5f00\u8fc7\u53d1\u7968");
        }
        return null;
    }

    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {
        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        invoiceAwaitDO.setDocNo(this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<String>()));
        Long masId = ((InvoiceAwaitDO)this.invoiceAwaitRepo.save(invoiceAwaitDO)).getId();
        this.saveRecordsD(param, masId);
        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();
        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        this.invoiceAwaitDRepo.deleteByMasId(masId);
        this.invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOptDocNoBatch(List<String> optDocNos) {
        log.info("\u6839\u636e\u6765\u6e90\u5355\u53f7\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684Rpc\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocNos));
        if (CollectionUtil.isNotEmpty(optDocNos)) {
            this.invoiceAwaitService.updateDeleteFlagByOptDocNoBatch(optDocNos);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByOptDocIdBatch(List<Long> optDocIds) {
        log.info("\u6839\u636e\u6765\u6e90\u5355\u636e\u4e3b\u952eid\u6279\u91cf\u903b\u8f91\u5220\u9664\u7684Rpc\u5165\u53c2\uff1a{}" + JSON.toJSONString(optDocIds));
        if (CollectionUtil.isNotEmpty(optDocIds)) {
            this.invoiceAwaitService.updateDeleteFlagByOptDocIdBatch(optDocIds);
        }
    }

    public List<InvoiceAwaitRpcAutoDTO> autoInvoiceAwaitOrder(Map<String, Object> param) {
        try {
            String param01 = "";
            List<InvoiceAwaitDTO> invoiceAwaitDTOS = this.invoiceAwaitService.invoiceAwaitOrder(param01);
            List invoiceAwaitRpcAutoDTOS = JSON.parseArray((String)JSON.toJSONString(invoiceAwaitDTOS), InvoiceAwaitRpcAutoDTO.class);
            return invoiceAwaitRpcAutoDTOS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public InvoiceAwaitRpcServiceImpl(InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory, InvoiceAwaitRepo invoiceAwaitRepo, InvoiceAwaitDRepo invoiceAwaitDRepo, SystemRpcService systemRpcService, InvoiceAwaitService invoiceAwaitService) {
        this.invoiceAwaitSaveServiceFactory = invoiceAwaitSaveServiceFactory;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.systemRpcService = systemRpcService;
        this.invoiceAwaitService = invoiceAwaitService;
    }
}

