/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinJournalConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSetOfBookLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.application.service.accountingengine.FinJournalService;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookLineService;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookService;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepoProc;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinJournalServiceImpl
implements FinJournalService {
    private static final Logger log = LoggerFactory.getLogger(FinJournalServiceImpl.class);
    private final FinJournalRepo finJournalRepo;
    private final FinJournalRepoProc finJournalRepoProc;
    private final FinSetOfBookService finSetOfBookService;
    private final FinSetOfBookLineService finSetOfBookLineService;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleRepo finFlexibleRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinJournalVO> page(FinJournalParam finJournalParam) {
        PagingVO<FinJournalVO> finJournalVOPagingVO = FinJournalConvert.INSTANCE.DTOToVO(this.finJournalRepoProc.page(finJournalParam));
        if (CollectionUtils.isEmpty((Collection)finJournalVOPagingVO.getRecords())) {
            return finJournalVOPagingVO;
        }
        List<String> sobCodes = finJournalVOPagingVO.getRecords().stream().map(v -> v.getSobLedgerCode()).collect(Collectors.toList());
        List<FinSetOfBookDTO> finSetOfBookDTOS = this.finSetOfBookService.findBySobCodes(sobCodes);
        if (CollectionUtils.isEmpty(finSetOfBookDTOS)) {
            return finJournalVOPagingVO;
        }
        List<Long> sobIds = finSetOfBookDTOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOList = this.finSetOfBookLineService.findByMasIds(sobIds);
        if (CollectionUtils.isEmpty(finSetOfBookLineDTOList)) {
            return finJournalVOPagingVO;
        }
        if (CollectionUtils.isEmpty(finSetOfBookLineDTOList = finSetOfBookLineDTOList.stream().filter(v -> Boolean.TRUE.equals(v.getFlexibleFlag()) && StringUtils.isNotBlank((CharSequence)v.getFlexibleCode())).collect(Collectors.toList()))) {
            return finJournalVOPagingVO;
        }
        List<String> flexibleCodes = finSetOfBookLineDTOList.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getFlexibleCode())).map(v -> v.getFlexibleCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(flexibleCodes)) {
            return finJournalVOPagingVO;
        }
        List<FinFlexibleDO> finFlexibleDOS = this.finFlexibleRepo.findAllByFlexibleCodeIn(flexibleCodes);
        if (CollectionUtils.isEmpty(finFlexibleDOS)) {
            return finJournalVOPagingVO;
        }
        List<Long> finFlexibleIds = finFlexibleDOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<FinFlexibleValueDO> finFlexibleValueDOS = this.finFlexibleValueRepo.findAllByMasIdIn(finFlexibleIds);
        if (CollectionUtils.isEmpty(finFlexibleValueDOS)) {
            return finJournalVOPagingVO;
        }
        Map finFlexibleValueMap = finFlexibleValueDOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        Map<String, Long> finFlexibleMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> v.getId(), (o, n) -> n));
        List<FinSetOfBookLineDTO> finSetOfBookLineDTOListFinal = finSetOfBookLineDTOList;
        Map<String, Map> setOfBookLineMap = finSetOfBookDTOS.stream().collect(Collectors.toMap(v -> v.getSobCode(), v -> finSetOfBookLineDTOListFinal.stream().filter(w -> v.getId().equals(w.getMasId())).collect(Collectors.toMap(j -> j.getColumnName(), j -> j.getFlexibleCode()))));
        for (FinJournalVO record : finJournalVOPagingVO.getRecords()) {
            String sobLedgerCode = record.getSobLedgerCode();
            Map stringFinSetOfBookLineDTOMap = setOfBookLineMap.get(sobLedgerCode);
            if (stringFinSetOfBookLineDTOMap == null) continue;
            Set columnNames = stringFinSetOfBookLineDTOMap.keySet();
            for (String columnName : columnNames) {
                String finFlexibleValue1;
                List finFlexibleValueDOS1;
                Long finFlexibleId;
                String flexibleCode = (String)stringFinSetOfBookLineDTOMap.get(columnName);
                if (StringUtils.isBlank((CharSequence)flexibleCode) || (finFlexibleId = finFlexibleMap.get(flexibleCode)) == null || CollectionUtils.isEmpty(finFlexibleValueDOS1 = finFlexibleValueMap.get(finFlexibleId))) continue;
                Map<String, String> finFlexibleValueMap1 = finFlexibleValueDOS1.stream().collect(Collectors.toMap(v -> v.getFlexibleValueCode(), v -> v.getFlexibleValueName(), (o, n) -> n));
                String finFlexibleValueCode1 = record.getField(columnName);
                if (StringUtils.isBlank((CharSequence)finFlexibleValueCode1) || StringUtils.isBlank((CharSequence)(finFlexibleValue1 = finFlexibleValueMap1.get(finFlexibleValueCode1)))) continue;
                record.setField(columnName, finFlexibleValue1);
            }
        }
        return finJournalVOPagingVO;
    }

    public FinJournalServiceImpl(FinJournalRepo finJournalRepo, FinJournalRepoProc finJournalRepoProc, FinSetOfBookService finSetOfBookService, FinSetOfBookLineService finSetOfBookLineService, FinAccEngDetDataLineRepo finAccEngDetDataLineRepo, FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleRepo finFlexibleRepo) {
        this.finJournalRepo = finJournalRepo;
        this.finJournalRepoProc = finJournalRepoProc;
        this.finSetOfBookService = finSetOfBookService;
        this.finSetOfBookLineService = finSetOfBookLineService;
        this.finAccEngDetDataLineRepo = finAccEngDetDataLineRepo;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleRepo = finFlexibleRepo;
    }
}

