/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountAmtSumVO;
import com.elitesland.fin.application.facade.vo.account.AccountOuVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountDO qAccountDO = QAccountDO.accountDO;
    private final AccountRepo accountRepo;

    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, this.qAccountDO);
        List fetch = query.fetch();
        return PagingVO.builder().total(query.fetchCount()).records(fetch).build();
    }

    public List<AccountVO> queryList(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        return query.fetch();
    }

    public JPAQuery<AccountVO> buildJPAQuery(AccountPageParam accountPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderName())) {
            predicates.add(this.qAccountDO.accountHolderName.like("%" + accountPageParam.getAccountHolderName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountHolderNameList())) {
            predicates.add(this.qAccountDO.accountHolderName.in(accountPageParam.getAccountHolderNameList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderCode())) {
            predicates.add(this.qAccountDO.accountHolderCode.eq((Object)accountPageParam.getAccountHolderCode()));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountHolderCodeList())) {
            predicates.add(this.qAccountDO.accountHolderCode.in(accountPageParam.getAccountHolderCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountName())) {
            predicates.add(this.qAccountDO.accountName.like("%" + accountPageParam.getAccountName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountNameList())) {
            predicates.add(this.qAccountDO.accountName.in(accountPageParam.getAccountNameList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountType())) {
            predicates.add(this.qAccountDO.accountType.eq((Object)accountPageParam.getAccountType()));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountTypeList())) {
            predicates.add(this.qAccountDO.accountType.in(accountPageParam.getAccountTypeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getState())) {
            predicates.add(this.qAccountDO.state.eq((Object)accountPageParam.getState()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountCode())) {
            predicates.add(this.qAccountDO.accountCode.like(StringUtil.buildLikeString(accountPageParam.getAccountCode())));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountCodeList())) {
            predicates.add(this.qAccountDO.accountCode.in(accountPageParam.getAccountCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getSecOuCode())) {
            predicates.add(this.qAccountDO.secOuCode.eq((Object)accountPageParam.getSecOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderNameCode())) {
            predicates.add(this.qAccountDO.accountHolderName.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode())).or((Predicate)this.qAccountDO.accountHolderCode.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode()))));
        }
        if (CollectionUtil.isNotEmpty(accountPageParam.getIds())) {
            predicates.add(this.qAccountDO.id.in(accountPageParam.getIds()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)accountPageParam.getConditions(), AccountDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        JPAQuery query = (JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        return query;
    }

    public List<AccountVO> queryByAccounts(List<String> accounts, String type, String state) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            predicates.add(this.qAccountDO.accountType.eq((Object)type));
        }
        if (!CollectionUtils.isEmpty(accounts)) {
            predicates.add(this.qAccountDO.accountCode.in(accounts));
        }
        if (!StringUtils.isEmpty((CharSequence)state)) {
            predicates.add(this.qAccountDO.state.eq((Object)state));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public Boolean updateAmtByCode(AccountParam accountParam) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountDO.id, this.qAccountDO.accountName, this.qAccountDO.accountCode, this.qAccountDO.accountType, this.qAccountDO.state, this.qAccountDO.createTime, this.qAccountDO.creator, this.qAccountDO.accountOccupancyAmount, this.qAccountDO.accountAmount.subtract(this.qAccountDO.accountOccupancyAmount).as("accAvaAmt"), this.qAccountDO.accountAmount, this.qAccountDO.accountAvailableAmount, this.qAccountDO.secOuCode, this.qAccountDO.secOuName, this.qAccountDO.secFranchiseeCode, this.qAccountDO.accountHolderType, this.qAccountDO.accountHolderName, this.qAccountDO.accountHolderCode, this.qAccountDO.remark, this.qAccountDO.extensionInfo})).from((EntityPath)this.qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set((Path)this.qAccountDO.state, (Object)accountParam.getState()).where(new Predicate[]{this.qAccountDO.id.in(accountParam.getIds())}).execute();
        return res;
    }

    public AccountVO get(Long id) {
        AccountVO accountVO = (AccountVO)((Object)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.id.eq((Object)id))).fetchOne());
        return accountVO;
    }

    public AccountVO getByCode(String accCode) {
        AccountVO res = (AccountVO)((Object)((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.accountCode.eq((Object)accCode))).fetchOne());
        return res;
    }

    public Boolean updateOccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public Boolean updateAccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qAccountDO).set(this.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public void updateAccountAmountByAccountCode(AccountParam accountParam) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qAccountDO);
        if (accountParam.getAccountAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountAmount, (Object)accountParam.getAccountAmount());
        }
        if (accountParam.getAccountOccupancyAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccountOccupancyAmount());
        }
        if (accountParam.getAccountAvailableAmount() != null) {
            jpaUpdateClause.set(this.qAccountDO.accountAvailableAmount, (Object)accountParam.getAccountAvailableAmount());
        }
        jpaUpdateClause.where(new Predicate[]{this.qAccountDO.accountCode.eq((Object)accountParam.getAccountCode())}).execute();
    }

    public List<AccountDTO> getAccountByAccountParam(AccountParam param) {
        JPAQuery<AccountDTO> accountVOJPAQuery = this.select(AccountDTO.class);
        if (CollectionUtils.isNotEmpty(param.getAccountCodes())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountCode.in(param.getAccountCodes()));
        }
        if (CollectionUtils.isNotEmpty(param.getAccountHolderNames())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderName.in(param.getAccountHolderNames()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountCode.eq((Object)param.getAccountCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountName())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountName.eq((Object)param.getAccountName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderName())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderName.eq((Object)param.getAccountHolderName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountHolderCode.eq((Object)param.getAccountHolderCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSecOuCode())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.secOuCode.eq((Object)param.getSecOuCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountType())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.accountType.eq((Object)param.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getState())) {
            accountVOJPAQuery.where((Predicate)this.qAccountDO.state.eq((Object)param.getState()));
        }
        return accountVOJPAQuery.fetch();
    }

    public AccountDO findByAccountCode(String accountCode) {
        List<AccountDO> accountDOList = this.accountRepo.findAllByAccountCode(accountCode);
        Assert.notEmpty(accountDOList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountDOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDO accountDO = accountDOList.get(0);
        Assert.equals((Object)accountDO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountDOList.get(0);
    }

    public AccountVO getVOByCode(String accCode) {
        List accountVoList = ((JPAQuery)this.select(AccountVO.class).where((Predicate)this.qAccountDO.accountCode.eq((Object)accCode))).fetch();
        Assert.notEmpty((Iterable)accountVoList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountVoList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountVO accountVO = (AccountVO)((Object)accountVoList.get(0));
        Assert.equals((Object)accountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountVO;
    }

    public AccountDTO getDTOByCode(String accCode) {
        List accountDTOS = ((JPAQuery)this.select(AccountDTO.class).where((Predicate)this.qAccountDO.accountCode.eq((Object)accCode))).fetch();
        Assert.notEmpty((Iterable)accountDTOS, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountDTOS.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDTO accountDTO = (AccountDTO)accountDTOS.get(0);
        Assert.equals((Object)accountDTO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountDTO;
    }

    public List<String> selectSecOuCodeByAccountHolderCode(String accountHolderCode) {
        if (StringUtils.isBlank((CharSequence)accountHolderCode)) {
            return Collections.EMPTY_LIST;
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qAccountDO.secOuCode).distinct()).from((EntityPath)this.qAccountDO)).where((Predicate)this.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        return query.fetch();
    }

    public List<AccountOuVO> selectAccountOuByAccountHolderCode(String accountHolderCode) {
        if (StringUtils.isBlank((CharSequence)accountHolderCode)) {
            return Collections.EMPTY_LIST;
        }
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountOuVO.class, (Expression[])new Expression[]{this.qAccountDO.secOuCode.as("ouCode"), this.qAccountDO.secOuName.as("ouName"), this.qAccountDO.createTime})).from((EntityPath)this.qAccountDO)).where((Predicate)this.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        return query.fetch();
    }

    public AccountAmtSumVO selectAmtSumByParam(String secOuCode, String accountHolderCode) {
        AccountAmtSumVO res = (AccountAmtSumVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountAmtSumVO.class, (Expression[])new Expression[]{this.qAccountDO.accountAmount.sum().as("accountAmountSum"), this.qAccountDO.accountAvailableAmount.sum().as("accountAvailableAmountSum"), this.qAccountDO.accountOccupancyAmount.sum().as("accountOccupancyAmountSum")})).from((EntityPath)this.qAccountDO)).where((Predicate)this.qAccountDO.secOuCode.eq((Object)secOuCode))).where((Predicate)this.qAccountDO.accountHolderCode.eq((Object)accountHolderCode))).fetchOne();
        return res;
    }

    public List<AccountVO> selectAccountAmtByParam(String secOuCode, String accountHolderCode, String accountType) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)secOuCode)) {
            predicates.add(this.qAccountDO.secOuCode.eq((Object)secOuCode));
        }
        if (!StringUtils.isEmpty((CharSequence)accountHolderCode)) {
            predicates.add(this.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        }
        if (!StringUtils.isEmpty((CharSequence)accountType)) {
            predicates.add(this.qAccountDO.accountType.eq((Object)accountType));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public AccountRepoProc(JPAQueryFactory jpaQueryFactory, AccountRepo accountRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.accountRepo = accountRepo;
    }
}

