/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.flow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.entity.flow.QAccountFlowDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountFlowRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAccountFlowDO qAccountFlowDO = QAccountFlowDO.accountFlowDO;

    public PagingVO<AccountFlowVO> page(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, this.qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public AccountFlowVO selectByAccCode(String accCode) {
        return (AccountFlowVO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.select(AccountFlowVO.class).where((Predicate)this.qAccountFlowDO.accountCode.eq((Object)accCode))).where((Predicate)this.qAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)this.qAccountFlowDO.deleteFlag.isNull()))).orderBy(this.qAccountFlowDO.createTime.desc())).fetchFirst());
    }

    public List<AccountFlowVO> selectListByParam(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowPageParam accountFlowPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountHolderName())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountHolderName.eq((Object)accountFlowPageParam.getAccountHolderName()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountHolderNameList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountHolderName.in(accountFlowPageParam.getAccountHolderNameList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountName())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountName.like(accountFlowPageParam.getAccountName()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountNameList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountName.in(accountFlowPageParam.getAccountNameList()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountCodeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccountCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.eq((Object)accountFlowPageParam.getAccountCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getTransactionType())) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionType.eq((Object)accountFlowPageParam.getTransactionType()));
        }
        if (accountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionTime.goe((Comparable)accountFlowPageParam.getTransactionTimeS()));
        }
        if (accountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionTime.loe((Comparable)accountFlowPageParam.getTransactionTimeE()));
        }
        if (accountFlowPageParam.getAuditDateS() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.auditDate.goe((Comparable)accountFlowPageParam.getAuditDateS()));
        }
        if (accountFlowPageParam.getAuditDateE() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.auditDate.loe((Comparable)accountFlowPageParam.getAuditDateE()));
        }
        if (accountFlowPageParam.getAmountFrom() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.amount.goe((Number)accountFlowPageParam.getAmountFrom()));
        }
        if (accountFlowPageParam.getAmountTo() != null) {
            predicates.add((Predicate)this.qAccountFlowDO.amount.loe((Number)accountFlowPageParam.getAmountTo()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSecFranchiseeCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.secFranchiseeCode.eq((Object)accountFlowPageParam.getSecFranchiseeCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getAccountType())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountType.eq((Object)accountFlowPageParam.getAccountType()));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.like("%" + accountFlowPageParam.getSourceNo() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getFlowNo())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.like("%" + accountFlowPageParam.getFlowNo() + "%"));
        }
        if (CollectionUtil.isNotEmpty(accountFlowPageParam.getSourceDocList())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceDoc.in(accountFlowPageParam.getSourceDocList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getIds())) {
            predicates.add((Predicate)this.qAccountFlowDO.id.in(accountFlowPageParam.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccType())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountType.eq((Object)accountFlowPageParam.getAccType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccTypeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountType.in(accountFlowPageParam.getAccTypeList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.in(accountFlowPageParam.getFlowNoList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getTransactionTypeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.transactionType.in(accountFlowPageParam.getTransactionTypeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccKeyword())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.like("%" + accountFlowPageParam.getAccKeyword() + "%").or((Predicate)this.qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.eq((Object)accountFlowPageParam.getAccCode()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccCodeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccName())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccName() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceNoEq())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.eq((Object)accountFlowPageParam.getSourceNoEq()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceNo.in(accountFlowPageParam.getSourceNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceDoc())) {
            predicates.add((Predicate)this.qAccountFlowDO.sourceDoc.eq((Object)accountFlowPageParam.getSourceDoc()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)accountFlowPageParam.getConditions(), AccountFlowDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.accountType, this.qAccountFlowDO.flowNo, this.qAccountFlowDO.transactionType, this.qAccountFlowDO.amount, this.qAccountFlowDO.transactionTime, this.qAccountFlowDO.accountCode, this.qAccountFlowDO.accountName, this.qAccountFlowDO.accountAmount, this.qAccountFlowDO.accountOccupancyAmount, this.qAccountFlowDO.sourceNo, this.qAccountFlowDO.sourceDoc, this.qAccountFlowDO.remark, this.qAccountFlowDO.createTime, this.qAccountFlowDO.createUserId, this.qAccountFlowDO.creator, this.qAccountFlowDO.modifyTime, this.qAccountFlowDO.modifyUserId, this.qAccountFlowDO.updater, this.qAccountFlowDO.deleteFlag, this.qAccountFlowDO.companyCode, this.qAccountFlowDO.secFranchiseeCode, this.qAccountFlowDO.accountType, this.qAccountFlowDO.accountCode, this.qAccountFlowDO.accountName, this.qAccountFlowDO.accountAmount, this.qAccountFlowDO.accountOccupancyAmount, this.qAccountFlowDO.accountAvailableAmount, this.qAccountFlowDO.auditUserId, this.qAccountFlowDO.auditUserName, this.qAccountFlowDO.auditDate, this.qAccountFlowDO.orderState, this.qAccountFlowDO.accountHolderName, this.qAccountFlowDO.ruleCode, this.qAccountFlowDO.priorityNo, this.qAccountFlowDO.extensionInfo})).from((EntityPath)this.qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.dealerSelect(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, this.qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.flowNo, this.qAccountFlowDO.transactionType, this.qAccountFlowDO.amount, this.qAccountFlowDO.transactionTime, this.qAccountFlowDO.accountCode, this.qAccountFlowDO.accountName, this.qAccountFlowDO.sourceNo, this.qAccountFlowDO.sourceDoc})).from((EntityPath)this.qAccountFlowDO);
    }

    public List<AccountFlowVO> dealerSelectAmt(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountFlowVO.class, (Expression[])new Expression[]{this.qAccountFlowDO.id, this.qAccountFlowDO.amount})).from((EntityPath)this.qAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public void approveAccountFlow(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set((Path)this.qAccountFlowDO.orderState, (Object)accountFlowParam.getOrderState()).set(this.qAccountFlowDO.auditUserId, (Object)accountFlowParam.getAuditUserId()).set((Path)this.qAccountFlowDO.auditUserName, (Object)accountFlowParam.getAuditUserName()).set(this.qAccountFlowDO.auditDate, (Object)accountFlowParam.getAuditDate()).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)accountFlowParam.getId())}).execute();
    }

    public List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (accountFlowQueryParam.getSourceId() != null) {
            query.where((Predicate)this.qAccountFlowDO.sourceId.eq((Object)accountFlowQueryParam.getSourceId()));
        }
        if (accountFlowQueryParam.getSourceNo() != null) {
            query.where((Predicate)this.qAccountFlowDO.sourceNo.eq((Object)accountFlowQueryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getSourceDoc())) {
            query.where((Predicate)this.qAccountFlowDO.sourceDoc.eq((Object)accountFlowQueryParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getSourceDocStatus())) {
            query.where((Predicate)this.qAccountFlowDO.sourceDocStatus.eq((Object)accountFlowQueryParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getAccountType())) {
            query.where((Predicate)this.qAccountFlowDO.accountType.eq((Object)accountFlowQueryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getAccountCode())) {
            query.where((Predicate)this.qAccountFlowDO.accountCode.eq((Object)accountFlowQueryParam.getAccountCode()));
        }
        return query.fetch();
    }

    public void updateAccountFlowAmount(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountAmount, (Object)accountFlowParam.getAccountAmount()).set(this.qAccountFlowDO.accountOccupancyAmount, (Object)accountFlowParam.getAccountOccupancyAmount()).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountFlowParam.getAccountAvailableAmount()).where(new Predicate[]{this.qAccountFlowDO.accountCode.eq((Object)accountFlowParam.getAccountCode()).and((Predicate)this.qAccountFlowDO.orderState.eq((Object)accountFlowParam.getOrderState()))}).execute();
    }

    public void updateAccountFlowAmountById(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountAmount, (Object)accountFlowParam.getAccountAmount()).set(this.qAccountFlowDO.accountOccupancyAmount, (Object)accountFlowParam.getAccountOccupancyAmount()).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountFlowParam.getAccountAvailableAmount()).set((Path)this.qAccountFlowDO.orderState, (Object)accountFlowParam.getOrderState()).set(this.qAccountFlowDO.auditUserId, (Object)accountFlowParam.getAuditUserId()).set((Path)this.qAccountFlowDO.auditUserName, (Object)accountFlowParam.getAuditUserName()).set(this.qAccountFlowDO.auditDate, (Object)accountFlowParam.getAuditDate()).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)accountFlowParam.getId()).and((Predicate)this.qAccountFlowDO.orderState.eq((Object)accountFlowParam.getOrderState()))}).execute();
    }

    public List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSourceNo())) {
            query.where((Predicate)this.qAccountFlowDO.sourceNo.eq((Object)queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getAccountType())) {
            query.where((Predicate)this.qAccountFlowDO.accountType.eq((Object)queryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getFlowNo())) {
            query.where((Predicate)this.qAccountFlowDO.flowNo.eq((Object)queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where((Predicate)this.qAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getAccountCodeList())) {
            query.where((Predicate)this.qAccountFlowDO.accountCode.in(queryParam.getAccountCodeList()));
        }
        return query.fetch();
    }

    public AccountFlowVO selectPreviousRepairAmtByParam(AccountFlowQueryParam flowQueryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (!StringUtils.isEmpty((CharSequence)flowQueryParam.getAccountCode())) {
            query.where((Predicate)this.qAccountFlowDO.accountCode.eq((Object)flowQueryParam.getAccountCode()));
        }
        query.where((Predicate)this.qAccountFlowDO.auditDate.isNotNull());
        return (AccountFlowVO)((Object)((JPAQuery)query.orderBy(this.qAccountFlowDO.auditDate.desc())).fetchFirst());
    }

    public List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterPageWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(this.qAccountFlowDO.auditDate.desc());
        flowPageParam.setPaging(query);
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(AccountFlowPageParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)this.qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)this.qAccountFlowDO.auditDate.gt((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getAccountCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.eq((Object)pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(this.qAccountFlowDO.auditDate.desc());
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(AccountFlowPageParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)this.qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)this.qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)this.qAccountFlowDO.auditDate.goe((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getAccountCode())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.eq((Object)pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add((Predicate)this.qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal accountOccupancyAmount, BigDecimal accountAvailableAmount, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountOccupancyAmount, (Object)accountOccupancyAmount).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).set(this.qAccountFlowDO.amount, (Object)amount).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal accountAmount, BigDecimal accountAvailableAmount, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountAmount, (Object)accountAmount).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).set(this.qAccountFlowDO.amount, (Object)amount).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal accountOccupancyAmount, BigDecimal accountAvailableAmount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountOccupancyAmount, (Object)accountOccupancyAmount).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableById(BigDecimal accountAmount, BigDecimal accountAvailableAmount, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.accountAmount, (Object)accountAmount).set(this.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).where(new Predicate[]{this.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public PagingVO<AccountFlowVO> appPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, this.qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.qAccountFlowDO).set(this.qAccountFlowDO.deleteFlag, (Object)deleteFlag).where(new Predicate[]{this.qAccountFlowDO.id.in(ids)}).execute();
    }

    public AccountFlowRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

