/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.aporder;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.workflow.aporder.ApOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.pur.dto.account.PurAccountCheckQtyDTO;
import com.elitesland.pur.provider.PurAccountProvider;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ApOrderProcessServiceImpl
implements ApOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final FinApPayVerApplyService finApPayVerApplyService;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderRepo apOrderRepo;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final PurAccountProvider purAccountProvider;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        if (apOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QApOrderDO apOrderDO = QApOrderDO.apOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)apOrderDO).set(apOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{apOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)apOrderDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(apOrderDO.approvedTime, (Object)LocalDateTime.now()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)apOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(apOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)apOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)apOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(apOrderDO.approvedTime, (Object)LocalDateTime.now()).set(apOrderDO.auditDate, (Object)LocalDateTime.now()).set(apOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)apOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            List<ApOrderDtlDTO> apOrderDtlDTOList;
            if (UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode().equals(apOrderDTO.getCreateMode()) && !CollectionUtils.isEmpty(apOrderDtlDTOList = this.apOrderDtlRepoProc.listByMisId(id))) {
                List purAccountCheckQtyDTOList = apOrderDtlDTOList.stream().map(d -> {
                    PurAccountCheckQtyDTO purAccountCheckQtyDTO = new PurAccountCheckQtyDTO();
                    purAccountCheckQtyDTO.setDocNo(d.getSourceNo());
                    purAccountCheckQtyDTO.setInvoiceQty(d.getQty());
                    purAccountCheckQtyDTO.setLineNo(BigDecimal.valueOf(d.getSourceLine().intValue()));
                    return purAccountCheckQtyDTO;
                }).collect(Collectors.toList());
                this.purAccountProvider.addInvoiceQty(purAccountCheckQtyDTOList);
            }
            log.info("\u5e94\u4ed8\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
            this.finApPayVerApplyService.autoWriteoffAp(apOrderDTO);
        }
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(businessId);
        if (apOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(apOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public ApOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, FinApPayVerApplyService finApPayVerApplyService, ApOrderRepoProc apOrderRepoProc, ApOrderRepo apOrderRepo, ApOrderDtlRepoProc apOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, PurAccountProvider purAccountProvider) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.finApPayVerApplyService = finApPayVerApplyService;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderRepo = apOrderRepo;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.purAccountProvider = purAccountProvider;
    }
}

