/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArHeadSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecHeadSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.arorder.FinArOrderDetailQuery;
import com.elitesland.fin.application.facade.param.recorder.FinRecOrderDetailQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyVO;
import com.elitesland.fin.application.service.arorder.ArOrderDtlService;
import com.elitesland.fin.application.service.arorder.ArOrderExService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.recorder.RecOrderDtlService;
import com.elitesland.fin.application.service.recorder.RecOrderExService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyArHeadService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyArService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyRecHeadService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyRecService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplySettleService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerLocalService;
import com.elitesland.fin.application.service.writeoff.OperationLogService;
import com.elitesland.fin.common.BusinessOperatiomEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyDO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.ThreadLocalCopyUtil;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinArRecVerApplyServiceImpl
implements FinArRecVerApplyService {
    private static final Logger log = LoggerFactory.getLogger(FinArRecVerApplyServiceImpl.class);
    private final UdcProvider udcProvider;
    private final FinArRecVerApplyRepoProc finArRecVerApplyRepoProc;
    private final FinArRecVerApplyArService finArRecVerApplyArService;
    private final FinArRecVerApplyArHeadService finArRecVerApplyArHeadService;
    private final FinArRecVerApplyRecService finArRecVerApplyRecService;
    private final FinArRecVerApplyRecHeadService finArRecVerApplyRecHeadService;
    private final SeqNumProvider seqNumProvider;
    private final FinArRecVerLocalService finArRecVerLocalService;
    private final ArOrderExService arOrderExService;
    private final RecOrderExService recOrderExService;
    private final FinArRecVerApplySettleService finArRecVerApplySettleService;
    private final OperationLogService operationLogService;
    private final ThreadLocalCopyUtil threadLocalCopyUtil;
    private final ArOrderDtlService arOrderDtlService;
    private final RecOrderDtlService recOrderDtlService;
    private final RecOrderService recOrderService;
    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArVerConfigDtlRepoProc arVerConfigDtlRepoProc;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    public static final ThreadLocal<String> CURRENT_USER = new ThreadLocal();
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private ArOrderService arOrderService;
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    @Autowired
    @Lazy
    public void setArOrderService(ArOrderService arOrderService) {
        this.arOrderService = arOrderService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(FinArRecVerApplySaveDTO save) {
        if (save.getId() == null) {
            return this.doCreate(save);
        }
        return this.doUpdate(save);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(FinArRecVerApplySaveDTO save) {
        this.verifyDataNew(save);
        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.save(save);
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", id.toString(), OperationTypeEnum.APPROVE_SUBMIT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));
        this.updateArMiddleVerAmt(save.getArSaveList());
        this.updateRecMiddleVerAmt(save.getRecSaveList());
        this.finArRecVerApplySettleService.createBatch(id, this.settleApplyDetailListNew(save.getArSaveList(), save.getRecSaveList()));
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long writeOffSubmit(FinArRecVerApplySaveDTO save) {
        this.checkWriteOffParamNew(save);
        this.buildArAndRecSaveList(save);
        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.saveFinArRecVerApply(save);
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", id.toString(), OperationTypeEnum.APPROVE_SUBMIT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));
        List<FinArRecVerApplyArSaveDTO> finArRecVerApplyArSaveDTOList = save.getArHeadSaveList().stream().flatMap(item -> item.getArSaveList().stream()).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> finArRecVerApplyRecSaveDTOList = save.getRecHeadSaveList().stream().flatMap(item -> item.getRecSaveList().stream()).collect(Collectors.toList());
        this.updateArMiddleVerAmt(finArRecVerApplyArSaveDTOList);
        this.updateRecMiddleVerAmt(finArRecVerApplyRecSaveDTOList);
        List<FinArRecVerApplySettleSaveDTO> finArRecVerApplySettleSaveDTOList = this.settleApplyDetailListNew(finArRecVerApplyArSaveDTOList, finArRecVerApplyRecSaveDTOList);
        finArRecVerApplySettleSaveDTOList.forEach(finArRecVerApplySettleSaveDTO -> {
            finArRecVerApplySettleSaveDTO.setOuId(save.getOuId());
            finArRecVerApplySettleSaveDTO.setOuCode(save.getOuCode());
            finArRecVerApplySettleSaveDTO.setOuName(save.getOuName());
        });
        this.finArRecVerApplySettleService.createBatch(id, finArRecVerApplySettleSaveDTOList);
        save.setId(id);
        FinArRecApplyApprovalDTO dto = new FinArRecApplyApprovalDTO();
        ArrayList<String> applyNos = new ArrayList<String>();
        applyNos.add(save.getApplyDocNo());
        dto.setApplyNos(applyNos);
        dto.setApprovalType(FinArRecApplyApprovalDTO.ApprovalType.APPROVE);
        this.writeOffApprove(dto);
        return id;
    }

    public Long saveFinArRecVerApply(FinArRecVerApplySaveDTO save) {
        if (save.getId() == null) {
            return this.createFinArRecVerApply(save);
        }
        return this.updateFinArRecVerApply(save);
    }

    private Long updateFinArRecVerApply(FinArRecVerApplySaveDTO save) {
        if (save.getSchemeId() == null) {
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }
        this.updateApplyOrder(save);
        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = this.finArRecVerApplyArHeadService.listByMasIds(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        Assert.notEmpty(finArRecVerApplyArHeadVOList, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355", (Object[])new Object[0]);
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = this.finArRecVerApplyRecHeadService.listByMasIds(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        Assert.notEmpty(finArRecVerApplyRecHeadVOList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355", (Object[])new Object[0]);
        this.finArRecVerApplyArHeadService.deleteByMasId(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        this.finArRecVerApplyRecHeadService.deleteByMasId(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        this.finArRecVerApplyArService.deleteByMasId(finArRecVerApplyArHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toSet()));
        this.finArRecVerApplyRecService.deleteByMasId(finArRecVerApplyRecHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toSet()));
        save.getArHeadSaveList().stream().forEach(item -> {
            Long masId = this.finArRecVerApplyArHeadService.create(save.getId(), (FinArRecVerApplyArHeadSaveDTO)item);
            this.finArRecVerApplyArService.createBatch(masId, item.getArSaveList());
        });
        save.getRecHeadSaveList().stream().forEach(item -> {
            Long masId = this.finArRecVerApplyRecHeadService.create(save.getId(), (FinArRecVerApplyRecHeadSaveDTO)item);
            this.finArRecVerApplyRecService.createBatch(masId, save.getRecSaveList());
        });
        return save.getId();
    }

    private Long createFinArRecVerApply(FinArRecVerApplySaveDTO save) {
        Optional<FinArRecVerApplyArHeadSaveDTO> arHeadSaveDTOOptional = save.getArHeadSaveList().stream().filter(arHeadSaveDTO -> StringUtils.isNotBlank((CharSequence)arHeadSaveDTO.getOuCode()) || Objects.nonNull(arHeadSaveDTO.getOuId())).findFirst();
        if (arHeadSaveDTOOptional.isPresent()) {
            arHeadSaveDTOOptional.ifPresent(finArRecVerApplyArHeadSaveDTO -> {
                save.setOuId(finArRecVerApplyArHeadSaveDTO.getOuId());
                save.setOuCode(finArRecVerApplyArHeadSaveDTO.getOuCode());
                save.setOuName(finArRecVerApplyArHeadSaveDTO.getOuName());
            });
        } else {
            Optional<FinArRecVerApplyRecHeadSaveDTO> recHeadSaveDTOOptional = save.getRecHeadSaveList().stream().filter(recHeadSaveDTO -> StringUtils.isNotBlank((CharSequence)recHeadSaveDTO.getOuCode()) || Objects.nonNull(recHeadSaveDTO.getOuId())).findFirst();
            if (recHeadSaveDTOOptional.isPresent()) {
                recHeadSaveDTOOptional.ifPresent(recVerApplyRecHeadSaveDTO -> {
                    save.setOuId(recVerApplyRecHeadSaveDTO.getOuId());
                    save.setOuCode(recVerApplyRecHeadSaveDTO.getOuCode());
                    save.setOuName(recVerApplyRecHeadSaveDTO.getOuName());
                });
            }
        }
        long id = this.createApplyOrder(save);
        save.getArHeadSaveList().stream().forEach(item -> {
            item.setId(null);
            Long masId = this.finArRecVerApplyArHeadService.create(id, (FinArRecVerApplyArHeadSaveDTO)item);
            this.finArRecVerApplyArService.createBatch(masId, item.getArSaveList());
        });
        save.getRecHeadSaveList().stream().forEach(item -> {
            item.setId(null);
            Long masId = this.finArRecVerApplyRecHeadService.create(id, (FinArRecVerApplyRecHeadSaveDTO)item);
            this.finArRecVerApplyRecService.createBatch(masId, item.getRecSaveList());
        });
        return id;
    }

    private void buildArAndRecSaveList(FinArRecVerApplySaveDTO save) {
        this.buildArHeadSaveList(save);
        this.buildRecHeadSaveList(save);
    }

    private void buildArHeadSaveList(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = save.getArHeadSaveList();
        List<Long> arOrderIds = finArRecVerApplyArHeadSaveDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        ArOrderDtlExPageParam arOrderDtlPageParam = new ArOrderDtlExPageParam();
        ((ArOrderDtlPageParam)arOrderDtlPageParam).setMasIds(arOrderIds);
        arOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<ArOrderDtlVO> arOrderDtlVOPagingVO = this.arOrderDtlService.page(arOrderDtlPageParam);
        List arOrderDtlVOS = arOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty((Iterable)arOrderDtlVOS, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355\u660e\u7ec6", (Object[])new Object[0]);
        finArRecVerApplyArHeadSaveDTOList.forEach(arOrder -> {
            List arOrderDtlVOList = arOrderDtlVOS.stream().filter(arOrderDtlVO -> arOrderDtlVO.getMasId().equals(arOrder.getId())).collect(Collectors.toList());
            Assert.notEmpty(arOrderDtlVOList, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355\u660e\u7ec6", (Object[])new Object[0]);
            arOrder.setArSaveList((List<FinArRecVerApplyArSaveDTO>)(CollectionUtils.isEmpty(arOrder.getArSaveList()) ? Lists.newArrayList() : arOrder.getArSaveList()));
            if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                ArOrderDtlVO arOrderDtlVO2 = (ArOrderDtlVO)arOrderDtlVOList.get(0);
                this.buildArSaveList(arOrderDtlVO2, arOrder.getVerAmt(), (FinArRecVerApplyArHeadSaveDTO)arOrder);
                return;
            }
            ArOrderDtlVO arOrderDtlVO3 = arOrderDtlVOList.stream().filter(item -> arOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst().orElse(null);
            if (arOrderDtlVO3 != null) {
                this.buildArSaveList(arOrderDtlVO3, arOrder.getVerAmt(), (FinArRecVerApplyArHeadSaveDTO)arOrder);
            }
            if (arOrderDtlVO3 == null) {
                BigDecimal balance = arOrder.getVerAmt();
                for (ArOrderDtlVO item2 : arOrderDtlVOList) {
                    if (BigDecimal.ZERO.compareTo(item2.getUnVerAmt()) == 0) continue;
                    if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item2.getUnVerAmt()) <= 0) {
                            this.buildArSaveList(item2, balance, (FinArRecVerApplyArHeadSaveDTO)arOrder);
                            break;
                        }
                        if (balance.compareTo(item2.getUnVerAmt()) > 0) {
                            this.buildArSaveList(item2, item2.getUnVerAmt(), (FinArRecVerApplyArHeadSaveDTO)arOrder);
                            balance = balance.subtract(item2.getUnVerAmt());
                        }
                    }
                    if (arOrder.getVerAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) {
                        this.buildArSaveList(item2, balance, (FinArRecVerApplyArHeadSaveDTO)arOrder);
                        break;
                    }
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) continue;
                    this.buildArSaveList(item2, item2.getUnVerAmt(), (FinArRecVerApplyArHeadSaveDTO)arOrder);
                    balance = balance.subtract(item2.getUnVerAmt());
                }
            }
        });
    }

    private void buildArSaveList(ArOrderDtlVO arOrderDtlVO, BigDecimal amount, FinArRecVerApplyArHeadSaveDTO finArRecVerApplyArHeadSaveDTO) {
        arOrderDtlVO.setVerAmt(amount);
        arOrderDtlVO.setArId(finArRecVerApplyArHeadSaveDTO.getId());
        arOrderDtlVO.setArDocNo(finArRecVerApplyArHeadSaveDTO.getArOrderNo());
        arOrderDtlVO.setOutArDocNo(finArRecVerApplyArHeadSaveDTO.getSourceNo());
        arOrderDtlVO.setNotVerAmt(arOrderDtlVO.getUnVerAmt());
        arOrderDtlVO.setSubCustName(arOrderDtlVO.getCustName());
        arOrderDtlVO.setNotVerAmt(arOrderDtlVO.getUnVerAmt());
        FinArRecVerApplyArSaveDTO finArRecVerApplyArSaveDTO = ArOrderDtlConvert.INSTANCE.VO2DTO(arOrderDtlVO);
        finArRecVerApplyArSaveDTO.setArDId(arOrderDtlVO.getId());
        finArRecVerApplyArHeadSaveDTO.getArSaveList().add(finArRecVerApplyArSaveDTO);
        finArRecVerApplyArHeadSaveDTO.setSalesmanName(finArRecVerApplyArHeadSaveDTO.getBusinessName());
        finArRecVerApplyArHeadSaveDTO.setSalesmanCode(finArRecVerApplyArHeadSaveDTO.getSaleUser());
    }

    private void buildRecHeadSaveList(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = save.getRecHeadSaveList();
        List<Long> recIds = finArRecVerApplyRecHeadSaveDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        RecOrderDtlPageParam recOrderDtlPageParam = new RecOrderDtlPageParam();
        recOrderDtlPageParam.setMasIds(recIds);
        recOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<RecOrderDtlVO> recOrderDtlVOPagingVO = this.recOrderDtlService.page(recOrderDtlPageParam);
        List recOrderDtlVOS = recOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty((Iterable)recOrderDtlVOS, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355\u660e\u7ec6", (Object[])new Object[0]);
        finArRecVerApplyRecHeadSaveDTOList.forEach(recOrder -> {
            List recOrderDtlVOList = recOrderDtlVOS.stream().filter(recOrderDtlVO -> recOrderDtlVO.getMasId().equals(recOrder.getId())).collect(Collectors.toList());
            Assert.notEmpty(recOrderDtlVOList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355\u660e\u7ec6", (Object[])new Object[0]);
            recOrder.setRecSaveList((List<FinArRecVerApplyRecSaveDTO>)(CollectionUtils.isEmpty(recOrder.getRecSaveList()) ? Lists.newArrayList() : recOrder.getRecSaveList()));
            if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                RecOrderDtlVO recOrderDtlVO2 = (RecOrderDtlVO)recOrderDtlVOList.get(0);
                this.buildRecSaveList(recOrderDtlVO2, recOrder.getVerAmt(), (FinArRecVerApplyRecHeadSaveDTO)recOrder);
                return;
            }
            RecOrderDtlVO recOrderDtlVO3 = recOrderDtlVOList.stream().filter(item -> recOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst().orElse(null);
            if (recOrderDtlVO3 != null) {
                this.buildRecSaveList(recOrderDtlVO3, recOrder.getVerAmt(), (FinArRecVerApplyRecHeadSaveDTO)recOrder);
            }
            if (recOrderDtlVO3 == null) {
                BigDecimal balance = recOrder.getVerAmt();
                for (RecOrderDtlVO item2 : recOrderDtlVOList) {
                    if (BigDecimal.ZERO.compareTo(item2.getUnVerAmt()) == 0) continue;
                    if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item2.getUnVerAmt()) <= 0) {
                            this.buildRecSaveList(item2, balance, (FinArRecVerApplyRecHeadSaveDTO)recOrder);
                            break;
                        }
                        if (balance.compareTo(item2.getUnVerAmt()) > 0) {
                            this.buildRecSaveList(item2, item2.getUnVerAmt(), (FinArRecVerApplyRecHeadSaveDTO)recOrder);
                            balance = balance.subtract(item2.getUnVerAmt());
                        }
                    }
                    if (recOrder.getVerAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) {
                        this.buildRecSaveList(item2, balance, (FinArRecVerApplyRecHeadSaveDTO)recOrder);
                        break;
                    }
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) continue;
                    this.buildRecSaveList(item2, item2.getUnVerAmt(), (FinArRecVerApplyRecHeadSaveDTO)recOrder);
                    balance = balance.subtract(item2.getUnVerAmt());
                }
            }
        });
    }

    private void buildRecSaveList(RecOrderDtlVO recOrderDtlVO, BigDecimal amount, FinArRecVerApplyRecHeadSaveDTO finArRecVerApplyRecHeadSaveDTO) {
        recOrderDtlVO.setVerAmt(amount);
        recOrderDtlVO.setRecId(finArRecVerApplyRecHeadSaveDTO.getId());
        recOrderDtlVO.setRecDocNo(finArRecVerApplyRecHeadSaveDTO.getRecOrderNo());
        recOrderDtlVO.setOutRecDocNo(finArRecVerApplyRecHeadSaveDTO.getSourceNo());
        recOrderDtlVO.setOuName(finArRecVerApplyRecHeadSaveDTO.getRecOuName());
        recOrderDtlVO.setRecBuType(recOrderDtlVO.getRecKindName());
        recOrderDtlVO.setNotVerAmt(recOrderDtlVO.getUnVerAmt());
        FinArRecVerApplyRecSaveDTO finArRecVerApplyRecSaveDTO = RecOrderDtlConvert.INSTANCE.VO2DTO(recOrderDtlVO);
        finArRecVerApplyRecSaveDTO.setRecDId(recOrderDtlVO.getId());
        finArRecVerApplyRecHeadSaveDTO.getRecSaveList().add(finArRecVerApplyRecSaveDTO);
        finArRecVerApplyRecHeadSaveDTO.setSalesmanName(finArRecVerApplyRecHeadSaveDTO.getBusinessName());
        finArRecVerApplyRecHeadSaveDTO.setSalesmanCode(finArRecVerApplyRecHeadSaveDTO.getSaleUser());
    }

    private void checkWriteOffParam(FinArRecVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getArHeadSaveList();
        Assert.notEmpty(finArRecVerApplyArHeadSaveDTOList, (String)"\u5e94\u6536\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getRecHeadSaveList();
        Assert.notEmpty(finArRecVerApplyRecHeadSaveDTOList, (String)"\u6536\u6b3e\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finArRecVerApplyRecHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
        BigDecimal arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinArRecVerApplyArHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinArRecVerApplyRecHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        Assert.isTrue((arVerAmt.compareTo(recVerAmt) == 0 ? 1 : 0) != 0, (String)"\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    private void checkWriteOffParamNew(FinArRecVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinArRecVerApplyArHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getArHeadSaveList();
        List<FinArRecVerApplyRecHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getRecHeadSaveList();
        if (CollectionUtils.isEmpty(finArRecVerApplyArHeadSaveDTOList) && CollectionUtils.isEmpty(finArRecVerApplyRecHeadSaveDTOList)) {
            throw new BusinessException("\u5e94\u6536\u5355\u548c\u6536\u6b3e\u5355\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadSaveDTOList)) {
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
            arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinArRecVerApplyArHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty(finArRecVerApplyRecHeadSaveDTOList)) {
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
            recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinArRecVerApplyRecHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Assert.isTrue((arVerAmt.compareTo(recVerAmt) == 0 ? 1 : 0) != 0, (String)"\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    @Override
    @SysCodeProc
    public FinArRecVerApplyVO detail(Long id) {
        FinArRecVerApplyDO entity = this.findApplyOrder(id);
        FinArRecVerApplyVO result = FinArRecVerApplyConvert.INSTANCE.entity2Vo(entity);
        result.setArList(this.finArRecVerApplyArService.listByMasIds(Collections.singletonList(id)));
        result.setRecList(this.finArRecVerApplyRecService.listByMasIds(Collections.singletonList(id)));
        return result;
    }

    @Override
    @SysCodeProc
    public FinArRecVerApplyVO writeOffDetail(Long id) {
        FinArRecVerApplyDO entity = this.findApplyOrder(id);
        FinArRecVerApplyVO result = FinArRecVerApplyConvert.INSTANCE.entity2Vo(entity);
        FinArRecVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(Lists.newArrayList((Object[])new Long[]{id}));
        result.setArHeadList(headAndDetailInfo.getArHeadList());
        result.setRecHeadList(headAndDetailInfo.getRecHeadList());
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinArRecVerApplyVO> page(FinArRecVerApplyQuery query) {
        List<FinArRecVerApplyRecVO> recVOList;
        ArrayList masIds = new ArrayList();
        ArrayList<Long> arIds = new ArrayList<Long>();
        ArrayList<Long> recIds = new ArrayList<Long>();
        List<FinArRecVerApplyArVO> arVOList = this.finArRecVerApplyArService.listByOutArDocNoOrDId(query);
        if (CollUtil.isNotEmpty(arVOList)) {
            masIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getMasId).distinct().collect(Collectors.toList()));
            arIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(recVOList = this.finArRecVerApplyRecService.listByOutRecDocNoOrDId(query))) {
            masIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getMasId).distinct().collect(Collectors.toList()));
            recIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(masIds)) {
            query.setIds(masIds.stream().distinct().collect(Collectors.toList()));
        }
        if ((StrUtil.isNotEmpty((CharSequence)query.getOutArDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutArDId()) || StrUtil.isNotEmpty((CharSequence)query.getOutRecDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutRecDId())) && CollUtil.isEmpty(masIds)) {
            return PagingVO.empty();
        }
        PagingVO<FinArRecVerApplyVO> result = this.finArRecVerApplyRepoProc.joinPage(query);
        if (result.isEmpty()) {
            return PagingVO.empty();
        }
        List<Long> ids = result.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<FinArRecVerApplyArVO> arList = this.finArRecVerApplyArService.listByQuery(FinArRecVerApplyArQuery.builder().ids(arIds).masIds(ids).build());
        List<FinArRecVerApplyRecVO> recList = this.finArRecVerApplyRecService.listByQuery(FinArRecVerApplyRecQuery.builder().ids(recIds).masIds(ids).build());
        if (arList.isEmpty() && recList.isEmpty()) {
            return result;
        }
        List apRelevanceOuCodeList = arList.stream().map(FinArRecVerApplyArVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List payRelevanceOuCodeList = recList.stream().map(FinArRecVerApplyRecVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(arList)) {
            arList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        if (CollectionUtil.isNotEmpty(recList)) {
            recList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        List<ArVerConfigDTO> arVerConfigDTOS = this.arVerConfigDomainService.queryAll();
        Map<Object, Object> arVerConfigDTOMap = new HashMap();
        if (CollectionUtils.isNotEmpty(arVerConfigDTOS)) {
            arVerConfigDTOMap = arVerConfigDTOS.stream().collect(Collectors.toMap(ArVerConfigDTO::getId, ArVerConfigDTO::getSchemeName));
        }
        HashMap finArVerConfigDTOMap = arVerConfigDTOMap;
        result.getRecords().forEach(e -> {
            e.setSchemeName((String)finArVerConfigDTOMap.get(e.getSchemeId()));
            e.setArList(arList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
            e.setRecList(recList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
        });
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinArRecVerApplyVO> writeOffPage(FinArRecVerApplyQuery query) {
        List<ArVerConfigDTO> arVerConfigDTOS;
        List<FinArRecVerApplyRecVO> recVOList;
        ArrayList arMasIds = new ArrayList();
        ArrayList recNasIds = new ArrayList();
        List<Object> totalMasIds = new ArrayList();
        ArrayList<Long> arIds = new ArrayList<Long>();
        ArrayList<Long> recIds = new ArrayList<Long>();
        List<FinArRecVerApplyArVO> arVOList = this.finArRecVerApplyArService.listByOutArDocNoOrDId(query);
        boolean existArRecQueryConditionFlag = false;
        boolean existApPayQueryConditionFlag = false;
        if (CollUtil.isNotEmpty(arVOList)) {
            List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOS = this.finArRecVerApplyArHeadService.listByIds(arVOList.stream().map(FinArRecVerApplyArVO::getMasId).distinct().collect(Collectors.toList()), query);
            if (CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)) {
                arMasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinArRecVerApplyArHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            arIds.addAll(arVOList.stream().map(FinArRecVerApplyArVO::getId).distinct().collect(Collectors.toList()));
        }
        if (StrUtil.isNotEmpty((CharSequence)query.getOutArDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffArOuCode()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffArSalesmanCode()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffArCustCode())) {
            existArRecQueryConditionFlag = true;
            if (CollUtil.isEmpty(arMasIds)) {
                return PagingVO.empty();
            }
        }
        if (CollUtil.isNotEmpty(recVOList = this.finArRecVerApplyRecService.listByOutRecDocNoOrDId(query))) {
            List<FinArRecVerApplyRecHeadVO> finArRecVerApplyArHeadVOS = this.finArRecVerApplyRecHeadService.listByIds(recVOList.stream().map(FinArRecVerApplyRecVO::getMasId).distinct().collect(Collectors.toList()), query);
            if (CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)) {
                recNasIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinArRecVerApplyRecHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            recIds.addAll(recVOList.stream().map(FinArRecVerApplyRecVO::getId).distinct().collect(Collectors.toList()));
        }
        if (StrUtil.isNotEmpty((CharSequence)query.getOutRecDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffRecOuCode()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffRecCustCode()) || StrUtil.isNotEmpty((CharSequence)query.getWriteOffRecSalesmanCode())) {
            existApPayQueryConditionFlag = true;
            if (CollUtil.isEmpty(recNasIds)) {
                return PagingVO.empty();
            }
        }
        if (existArRecQueryConditionFlag && !existApPayQueryConditionFlag) {
            totalMasIds = arMasIds;
        } else if (!existArRecQueryConditionFlag && existApPayQueryConditionFlag) {
            totalMasIds = recNasIds;
        } else if (existArRecQueryConditionFlag && existApPayQueryConditionFlag) {
            totalMasIds = arMasIds.stream().filter(recNasIds::contains).collect(Collectors.toList());
        } else {
            totalMasIds.addAll(arMasIds);
            totalMasIds.addAll(recNasIds);
        }
        if (CollUtil.isEmpty(totalMasIds)) {
            return PagingVO.empty();
        }
        query.setIds(totalMasIds.stream().distinct().collect(Collectors.toList()));
        PagingVO<FinArRecVerApplyVO> result = this.finArRecVerApplyRepoProc.writeOffJoinPage(query);
        if (result.isEmpty()) {
            return PagingVO.empty();
        }
        List<Long> ids = result.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> schemeIds = result.getRecords().stream().filter(v -> WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(v.getVerMode()) && v.getSchemeId() != null).map(v -> v.getSchemeId()).collect(Collectors.toList());
        Map<Object, Object> arVerConfigNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(schemeIds) && CollectionUtils.isNotEmpty(arVerConfigDTOS = this.arVerConfigDomainService.findByIds(schemeIds))) {
            arVerConfigNameMap = arVerConfigDTOS.stream().collect(Collectors.toMap(ArVerConfigDTO::getId, ArVerConfigDTO::getSchemeName));
        }
        HashMap arVerConfigNameMapFinal = arVerConfigNameMap;
        FinArRecVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfoByQuery(arIds, recIds, ids);
        result.getRecords().forEach(record -> {
            record.setArHeadList(headAndDetailInfo.getArHeadList().stream().filter(finArRecVerApplyArHeadVO -> record.getId().equals(finArRecVerApplyArHeadVO.getMasId())).collect(Collectors.toList()));
            record.setRecHeadList(headAndDetailInfo.getRecHeadList().stream().filter(finArRecVerApplyRecHeadVO -> record.getId().equals(finArRecVerApplyRecHeadVO.getMasId())).collect(Collectors.toList()));
            if (WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode().equals(record.getVerMode()) && record.getSchemeId() != null) {
                record.setSchemeName((String)arVerConfigNameMapFinal.get(record.getSchemeId()));
            }
        });
        return result;
    }

    private FinArRecVerApplyVO queryHeadAndDetailInfoByQuery(List<Long> arIds, List<Long> recIds, List<Long> masIds) {
        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = this.finArRecVerApplyArHeadService.listByMasIds(masIds);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = this.finArRecVerApplyArService.listByQuery(FinArRecVerApplyArQuery.builder().masIds(arMasIds).ids(arIds).build());
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinArRecVerApplyArVO> resultList = finArRecVerApplyArVOList.stream().filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyArHeadVO.setArList(resultList);
            });
        }
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = this.finArRecVerApplyRecHeadService.listByMasIds(masIds);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = this.finArRecVerApplyRecService.listByQuery(FinArRecVerApplyRecQuery.builder().masIds(recMasIds).ids(recIds).build());
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinArRecVerApplyRecVO> resultList = finArRecVerApplyRecVOList.stream().filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyRecHead.setRecList(resultList);
            });
        }
        List apRelevanceOuCodeList = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List payRelevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            finArRecVerApplyArHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        if (CollectionUtil.isNotEmpty(finArRecVerApplyRecHeadVOList)) {
            finArRecVerApplyRecHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        FinArRecVerApplyVO finArRecVerApplyVO = new FinArRecVerApplyVO();
        finArRecVerApplyVO.setArHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setRecHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    private FinArRecVerApplyVO queryHeadAndDetailInfo(Collection<Long> ids) {
        Map custInOut = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_IN_OUT");
        List<FinArRecVerApplyArHeadVO> finArRecVerApplyArHeadVOList = this.finArRecVerApplyArHeadService.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<FinArRecVerApplyArVO> finArRecVerApplyArVOList = this.finArRecVerApplyArService.listByMasIds(arMasIds);
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinArRecVerApplyArVO> resultList = finArRecVerApplyArVOList.stream().filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyArHeadVO.setArList(resultList);
                if (custInOut != null) {
                    finArRecVerApplyArHeadVO.setInOutCustName((String)custInOut.get(finArRecVerApplyArHeadVO.getInOutCust()));
                }
            });
        }
        List<FinArRecVerApplyRecHeadVO> finArRecVerApplyRecHeadVOList = this.finArRecVerApplyRecHeadService.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = this.finArRecVerApplyRecService.listByMasIds(recMasIds);
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinArRecVerApplyRecVO> resultList = finArRecVerApplyRecVOList.stream().filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyRecHead.setRecList(resultList);
                if (custInOut != null) {
                    finArRecVerApplyRecHead.setInOutCustName((String)custInOut.get(finArRecVerApplyRecHead.getInOutCust()));
                }
            });
        }
        List apRelevanceOuCodeList = finArRecVerApplyArHeadVOList.stream().map(FinArRecVerApplyArHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List payRelevanceOuCodeList = finArRecVerApplyRecHeadVOList.stream().map(FinArRecVerApplyRecHeadVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            finArRecVerApplyArHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        if (CollectionUtil.isNotEmpty(finArRecVerApplyRecHeadVOList)) {
            finArRecVerApplyRecHeadVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
                if (Objects.nonNull(ouRpcSimpleDTO)) {
                    v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
                }
            });
        }
        FinArRecVerApplyVO finArRecVerApplyVO = new FinArRecVerApplyVO();
        finArRecVerApplyVO.setArHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setRecHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(FinArRecApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinArRecVerApplyDO> applyList = this.finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finArRecVerApplyRepoProc.save(applyList);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO != null ? sysUserDTO.getLastName() : principal.getUsername();
        this.threadLocalCopyUtil.asyncTask(() -> {
            CURRENT_USER.set(user);
            SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
            TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e -> {
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
            });
            this.finArRecVerApplyRepoProc.save(applyList);
            applyList.forEach(apply -> {
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_OK, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            CURRENT_USER.remove();
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffApprove(FinArRecApplyApprovalDTO dto) {
        List<FinArRecVerApplyDO> applyList = this.finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finArRecVerApplyRepoProc.save(applyList);
        SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
        String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
        String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
        String erpLog = "";
        try {
            this.updateAmount(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()), "1");
        }
        catch (Exception e2) {
            log.error("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25", (Throwable)e2);
            applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
            verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
            erpLog = e2.getMessage();
        }
        String finalApplyState = applyState;
        String finalVerState = verState;
        String finalErpLog = erpLog;
        applyList.forEach(e -> {
            e.setState(finalApplyState);
            e.setVerState(finalVerState);
        });
        this.finArRecVerApplyRepoProc.save(applyList);
        applyList.forEach(apply -> {
            if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_OK, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
            }
        });
    }

    public ApiResult<String> reTryApprove(Long id) {
        FinArRecVerApplyDO applyDO = (FinArRecVerApplyDO)((Object)this.finArRecVerApplyRepoProc.get(id));
        SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
        TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
        String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
        String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
        String erpLog = "";
        Boolean isSuccess = Boolean.TRUE;
        String finalApplyState = applyState;
        String finalVerState = verState;
        String finalErpLog = erpLog;
        applyDO.setState(finalApplyState);
        applyDO.setVerState(finalVerState);
        this.finArRecVerApplyRepoProc.save((Serializable)((Object)applyDO));
        return isSuccess != false ? ApiResult.ok((Object)"\u91cd\u63a8\u6838\u9500\u5ba1\u6279\u6210\u529f") : ApiResult.fail((String)erpLog);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAmount(Collection<Long> ids, String verType) {
        BigDecimal factor = BigDecimal.ONE;
        FinArRecVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(ids);
        List<Long> arMasIds = headAndDetailInfo.getArHeadList().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> recMasIds = headAndDetailInfo.getRecHeadList().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<FinArRecVerApplyArVO> arVOList = this.finArRecVerApplyArService.listByMasIds(arMasIds);
        arVOList.forEach(e -> this.arOrderService.updateVerAmt(e.getArDId(), e.getVerAmt().multiply(factor), verType));
        List<FinArRecVerApplyRecVO> recVOList = this.finArRecVerApplyRecService.listByMasIds(recMasIds);
        recVOList.forEach(e -> this.recOrderService.updateVerAmt(e.getRecDId(), e.getVerAmt().multiply(factor), verType));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuse(FinArRecApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinArRecVerApplyDO> applyList = this.finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, (String)"\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u5355", (Object[])new Object[0]);
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finArRecVerApplyArService.listByMasIds(masIds).forEach(e -> this.arOrderExService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt().negate()));
        this.finArRecVerApplyRecService.listByMasIds(masIds).forEach(e -> this.recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt().negate()));
        this.finArRecVerApplyRepoProc.save(applyList);
        applyList.forEach(apply -> this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffRefuse(FinArRecApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinArRecVerApplyDO> applyList = this.finArRecVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, (String)"\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u5355", (Object[])new Object[0]);
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        FinArRecVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(masIds);
        List<Long> arMasIds = headAndDetailInfo.getArHeadList().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> recMasIds = headAndDetailInfo.getRecHeadList().stream().map(BaseViewModel::getId).collect(Collectors.toList());
        this.finArRecVerApplyArService.listByMasIds(arMasIds).forEach(e -> this.arOrderExService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt().negate()));
        this.finArRecVerApplyRecService.listByMasIds(recMasIds).forEach(e -> this.recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt().negate()));
        this.finArRecVerApplyRepoProc.save(applyList);
        applyList.forEach(apply -> this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(Long id) {
        FinArRecVerApplyDO entity = this.findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("\u4ec5\u6838\u9500\u72b6\u6001\u4e3a\u5df2\u6838\u9500\u6216\u8005\u53d6\u6d88\u5931\u8d25\u7684\u5355\u636e\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c!");
        }
        this.updateOrderForVerCancel(entity);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String user = principal.getUsername();
        ThreadUtil.execute(() -> {
            CURRENT_USER.set(user);
            log.info("\u53d6\u6d88\u6838\u9500\u5f02\u6b65\u6267\u884c");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String erpLog = "";
            try {
                SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
                TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u6838\u9500,\u63a8\u9001nc\u5931\u8d25,{}", (Object)e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            log.info("\u53d6\u6d88\u6838\u9500\u66f4\u65b0\u72b6\u6001,{}", (Object)JSONUtil.toJsonStr((Object)((Object)entity)));
            this.finArRecVerApplyRepoProc.save((Serializable)((Object)entity));
            CURRENT_USER.remove();
        });
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, "\u53d6\u6d88\u6838\u9500");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffCancel(Long id) {
        FinArRecVerApplyDO entity = this.findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("\u4ec5\u6838\u9500\u72b6\u6001\u4e3a\u5df2\u6838\u9500\u6216\u8005\u53d6\u6d88\u5931\u8d25\u7684\u5355\u636e\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c!");
        }
        if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(entity.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(entity.getProposedStatus())) {
            throw new BusinessException("\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
        }
        this.updateOrderForVerCancel(entity);
        this.updateAmount(Collections.singleton(id), "2");
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, "\u53d6\u6d88\u6838\u9500");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        List list = this.finArRecVerApplyRepoProc.get(ids);
        Assert.notEmpty((Iterable)list, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f", (Object[])new Object[0]);
        list.forEach(e -> {
            if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode().equals(e.getState())) {
                throw new BusinessException("\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff0c\u8bf7\u6838\u5bf9\u5355\u636e\u72b6\u6001");
            }
        });
        this.finArRecVerApplyRepoProc.delete(ids);
        this.finArRecVerApplyArService.deleteByMasId(ids);
        this.finArRecVerApplyRecService.deleteByMasId(ids);
    }

    @Override
    public List<FinArRecVerApplySettleVO> settleList(Long id) {
        return this.finArRecVerApplySettleService.listByMasIds(Collections.singletonList(id));
    }

    private void updateArMiddleVerAmt(List<FinArRecVerApplyArSaveDTO> list) {
        list.forEach(e -> this.arOrderService.updateMiddleVerAmt(e.getArDId(), e.getVerAmt()));
    }

    private void updateRecMiddleVerAmt(List<FinArRecVerApplyRecSaveDTO> list) {
        list.forEach(e -> this.recOrderExService.updateMiddleVerAmt(e.getRecDId(), e.getVerAmt()));
    }

    private void updateOrderForVerCancel(FinArRecVerApplyDO entity) {
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode());
        this.finArRecVerApplyRepoProc.save((Serializable)((Object)entity));
    }

    private void verifyData(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyArSaveDTO> arSaveList = save.getArSaveList();
        List<FinArRecVerApplyRecSaveDTO> recSaveList = save.getRecSaveList();
        if (arSaveList.isEmpty()) {
            throw new BusinessException("\u5e94\u6536\u5355\u6838\u9500\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (recSaveList.isEmpty()) {
            throw new BusinessException("\u6838\u9500\u5355\u6838\u9500\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        save.setVerAmt(this.checkAndGetTotalVerAmt(arSaveList, recSaveList));
        List<Long> arDIds = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getArDId).collect(Collectors.toList());
        List<ArOrderDtlExVo> arOrderDtlExVos = this.arOrderExService.listArOrderDetail(FinArOrderDetailQuery.builder().arDIds(arDIds).build());
        if (arDIds.size() != arOrderDtlExVos.size()) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u5e94\u6536\u5355\u5355\u53f7");
        }
        arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getArDId())).findFirst().ifPresent(ar -> {
            if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                throw new BusinessException("\u8bf7\u6821\u9a8c\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + arSave.getArDocNo());
            }
            if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                throw new BusinessException("\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + arSave.getArDocNo());
            }
        }));
        List<Long> recDId = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).collect(Collectors.toList());
        List<RecOrderDtlExVo> recOrderDtlExVos = this.recOrderExService.listRecOrderDetail(FinRecOrderDetailQuery.builder().recDIds(recDId).build());
        if (recOrderDtlExVos.size() != recDId.size()) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u6536\u6b3e\u5355\u5355\u53f7");
        }
        recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getRecDId())).findFirst().ifPresent(rec -> {
            if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                throw new BusinessException("\u8bf7\u6821\u9a8c\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + recSave.getRecDocNo());
            }
            if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                throw new BusinessException("\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + recSave.getRecDocNo());
            }
        }));
    }

    private void verifyDataNew(FinArRecVerApplySaveDTO save) {
        List<FinArRecVerApplyArSaveDTO> arSaveList = save.getArSaveList();
        List<FinArRecVerApplyRecSaveDTO> recSaveList = save.getRecSaveList();
        if (CollectionUtils.isEmpty(arSaveList) && CollectionUtils.isEmpty(recSaveList)) {
            throw new BusinessException("\u5e94\u6536\u5355\u548c\u6536\u6b3e\u5355\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        save.setVerAmt(this.checkAndGetTotalVerAmtNew(arSaveList, recSaveList));
        if (CollectionUtils.isNotEmpty(arSaveList)) {
            List<Long> arDIds = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getArDId).collect(Collectors.toList());
            List<ArOrderDtlExVo> arOrderDtlExVos = this.arOrderExService.listArOrderDetail(FinArOrderDetailQuery.builder().arDIds(arDIds).build());
            if (arDIds.size() != arOrderDtlExVos.size()) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u5e94\u6536\u5355\u5355\u53f7");
            }
            arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getArDId())).findFirst().ifPresent(ar -> {
                if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                    throw new BusinessException("\u8bf7\u6821\u9a8c\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + arSave.getArDocNo());
                }
                if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                    throw new BusinessException("\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + arSave.getArDocNo());
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(recSaveList)) {
            List<Long> recDId = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDId).collect(Collectors.toList());
            List<RecOrderDtlExVo> recOrderDtlExVos = this.recOrderExService.listRecOrderDetail(FinRecOrderDetailQuery.builder().recDIds(recDId).build());
            if (recOrderDtlExVos.size() != recDId.size()) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u6536\u6b3e\u5355\u5355\u53f7");
            }
            recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getRecDId())).findFirst().ifPresent(rec -> {
                if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                    throw new BusinessException("\u8bf7\u6821\u9a8c\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + recSave.getRecDocNo());
                }
                if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                    throw new BusinessException("\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + recSave.getRecDocNo());
                }
            }));
        }
    }

    private BigDecimal checkAndGetTotalVerAmt(List<FinArRecVerApplyArSaveDTO> arSaveList, List<FinArRecVerApplyRecSaveDTO> recSaveList) {
        BigDecimal recVerAmt;
        BigDecimal arVerAmt = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (arVerAmt.compareTo(recVerAmt = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw new BusinessException("\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        }
        return arVerAmt;
    }

    private BigDecimal checkAndGetTotalVerAmtNew(List<FinArRecVerApplyArSaveDTO> arSaveList, List<FinArRecVerApplyRecSaveDTO> recSaveList) {
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(arSaveList)) {
            arSaveList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
            arVerAmt = arSaveList.stream().map(FinArRecVerApplyArSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty(recSaveList)) {
            recSaveList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
            recVerAmt = recSaveList.stream().map(FinArRecVerApplyRecSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        }
        return arVerAmt;
    }

    public void updateVerAmt(Collection<Long> ids, String verType) {
        BigDecimal factor = BigDecimal.ONE;
        List<FinArRecVerApplyArVO> arVOList = this.finArRecVerApplyArService.listByMasIds(ids);
        arVOList.forEach(e -> this.arOrderExService.updateVerAmt(e.getArDId(), e.getVerAmt().multiply(factor), verType));
        List<FinArRecVerApplyRecVO> recVOList = this.finArRecVerApplyRecService.listByMasIds(ids);
        recVOList.forEach(e -> this.recOrderExService.updateVerAmt(e.getRecDId(), e.getVerAmt().multiply(factor), verType));
    }

    private Long doUpdate(FinArRecVerApplySaveDTO save) {
        this.updateApplyOrder(save);
        this.finArRecVerApplyArService.deleteByMasId(Collections.singleton(save.getId()));
        this.finArRecVerApplyRecService.deleteByMasId(Collections.singleton(save.getId()));
        this.finArRecVerApplyArService.createBatch(save.getId(), save.getArSaveList());
        this.finArRecVerApplyRecService.createBatch(save.getId(), save.getRecSaveList());
        return save.getId();
    }

    @NotNull
    private FinArRecVerApplyDO findApplyOrder(Long id) {
        FinArRecVerApplyDO entity = (FinArRecVerApplyDO)((Object)this.finArRecVerApplyRepoProc.get(id));
        Assert.notNull((Object)((Object)entity), (String)("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u4fe1\u606f\uff0cid:" + id), (Object[])new Object[0]);
        return entity;
    }

    private Long doCreate(FinArRecVerApplySaveDTO save) {
        long id = this.createApplyOrder(save);
        this.finArRecVerApplyArService.createBatch(id, save.getArSaveList());
        this.finArRecVerApplyRecService.createBatch(id, save.getRecSaveList());
        return id;
    }

    private long createApplyOrder(FinArRecVerApplySaveDTO save) {
        FinArRecVerApplyDO entity = FinArRecVerApplyConvert.INSTANCE.save2Do(save);
        entity.setApplyDocNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
        entity.setState(save.getState() == null ? WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode() : save.getState());
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_NOT.getValueCode());
        entity.setApplyDate(LocalDateTime.now());
        entity.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        entity.setApplyUserId(principal.getUserId());
        SysUserDTO user = principal.getUser();
        if (user != null) {
            entity.setApplyUserName(user.getLastName());
        }
        this.finArRecVerApplyRepoProc.save((Serializable)((Object)entity));
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.ADD, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.ADD));
        save.setApplyDocNo(entity.getApplyDocNo());
        return entity.getId();
    }

    private void updateApplyOrder(FinArRecVerApplySaveDTO save) {
        FinArRecVerApplyDO entity = (FinArRecVerApplyDO)((Object)this.finArRecVerApplyRepoProc.get(save.getId()));
        Assert.notNull((Object)((Object)entity), (String)("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6838\u9500\u7533\u8bf7\u5355\uff0cID:" + save.getId()), (Object[])new Object[0]);
        FinArRecVerApplyConvert.INSTANCE.save2Do(save, entity);
        this.finArRecVerApplyRepoProc.save((Serializable)((Object)entity));
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.UPDATE));
    }

    private void setApprovalMsg(FinArRecApplyApprovalDTO dto, List<FinArRecVerApplyDO> applyList) {
        applyList.forEach(e -> {
            if (dto.getApprovalType() == FinArRecApplyApprovalDTO.ApprovalType.APPROVE) {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVALING.getValueCode());
            } else {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_REFUSE.getValueCode());
            }
            GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            e.setApprovalUserId(principal.getUserId());
            SysUserDTO user = principal.getUser();
            if (user != null) {
                e.setApprovalUserName(user.getLastName());
            }
            e.setApprovalDate(LocalDateTime.now());
            if (org.springframework.util.StringUtils.hasText((String)dto.getApprovalRemark())) {
                e.setApprovalRemark(dto.getApprovalRemark());
            }
        });
    }

    private void preCheckForApproval(List<String> applyNos, List<FinArRecVerApplyDO> applyList) {
        if (applyNos.size() > applyList.size() && applyNos.removeAll(applyList.stream().map(FinArRecVerApplyDO::getApplyDocNo).collect(Collectors.toList()))) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u4ee5\u4e0b\u5355\u53f7:" + applyNos);
        }
        List fiRes = applyList.stream().filter(fi -> !WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(fi.getState())).map(FinArRecVerApplyDO::getApplyDocNo).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(fiRes)) {
            throw new BusinessException("\u4ee5\u4e0b\u6838\u9500\u7533\u8bf7\u5355\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c:" + fiRes);
        }
    }

    private List<FinArRecVerApplySettleSaveDTO> settleApplyDetailList(List<FinArRecVerApplyArSaveDTO> ars, List<FinArRecVerApplyRecSaveDTO> recs) {
        List<FinArRecVerApplyArSaveDTO> arList = ars.stream().sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt)).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> recList = recs.stream().sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt)).collect(Collectors.toList());
        return this.doSettle(arList, recList);
    }

    private List<FinArRecVerApplySettleSaveDTO> settleApplyDetailListNew(List<FinArRecVerApplyArSaveDTO> ars, List<FinArRecVerApplyRecSaveDTO> recs) {
        ArrayList<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<FinArRecVerApplySettleSaveDTO>();
        ArrayList<FinArRecVerApplyArSaveDTO> leftAllArlist = new ArrayList<FinArRecVerApplyArSaveDTO>();
        ArrayList<FinArRecVerApplyRecSaveDTO> leftAllReclist = new ArrayList<FinArRecVerApplyRecSaveDTO>();
        List zeroArlist = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        List zeroReclist = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        List<FinArRecVerApplyArSaveDTO> arListPositive = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<FinArRecVerApplyArSaveDTO> arListNegative = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(arListPositive) && CollectionUtils.isNotEmpty(arListNegative)) {
            List<FinArRecVerApplyArSaveDTO> leftArlist = this.doSettleForArOffset(arListPositive, arListNegative, settles);
            if (CollectionUtils.isNotEmpty(leftArlist)) {
                leftAllArlist.addAll(leftArlist);
            }
        } else {
            if (CollectionUtils.isNotEmpty(arListPositive)) {
                leftAllArlist.addAll(arListPositive);
            }
            if (CollectionUtils.isNotEmpty(arListNegative)) {
                leftAllArlist.addAll(arListNegative);
            }
        }
        List<FinArRecVerApplyRecSaveDTO> recListPositive = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> recListNegative = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(recListPositive) && CollectionUtils.isNotEmpty(recListNegative)) {
            List<FinArRecVerApplyRecSaveDTO> leftReclist = this.doSettleForRecOffset(recListPositive, recListNegative, settles);
            if (CollectionUtils.isNotEmpty(leftReclist)) {
                leftAllReclist.addAll(leftReclist);
            }
        } else {
            if (CollectionUtils.isNotEmpty(recListPositive)) {
                leftAllReclist.addAll(recListPositive);
            }
            if (CollectionUtils.isNotEmpty(recListNegative)) {
                leftAllReclist.addAll(recListNegative);
            }
        }
        if (CollectionUtils.isEmpty(leftAllArlist) || CollectionUtils.isEmpty(leftAllReclist)) {
            return settles;
        }
        List<FinArRecVerApplyArSaveDTO> arList = leftAllArlist.stream().sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt)).collect(Collectors.toList());
        List<FinArRecVerApplyRecSaveDTO> recList = leftAllReclist.stream().sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt)).collect(Collectors.toList());
        settles.addAll(this.doSettleNew(arList, recList));
        return settles;
    }

    private List<FinArRecVerApplyArSaveDTO> doSettleForArOffset(List<FinArRecVerApplyArSaveDTO> arListPositive, List<FinArRecVerApplyArSaveDTO> arListNegative, List<FinArRecVerApplySettleSaveDTO> settles) {
        arListPositive.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        arListNegative.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        List arListPositiveSorted = arListPositive.stream().sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt)).collect(Collectors.toList());
        List arListNegativeSorted = arListNegative.stream().sorted(Comparator.comparing(FinArRecVerApplyArSaveDTO::getVerAmt)).collect(Collectors.toList());
        Collections.reverse(arListNegativeSorted);
        ArrayList arListPositiveRm = new ArrayList();
        ArrayList arListNegativeRm = new ArrayList();
        arListNegativeSorted.stream().forEach(arn -> arListPositiveSorted.stream().forEach(arp -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = BigDecimal.ZERO.compareTo(arn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(arp.getVerAmt()) == 0;
            if (writeOffFlag) {
                return;
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(this.buildSettleForArOffset((FinArRecVerApplyArSaveDTO)arp, null));
                arn.setVerAmt(arn.getVerAmt().add(arp.getVerAmt()));
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(this.buildSettleForArOffset((FinArRecVerApplyArSaveDTO)arn, null));
                settles.add(this.buildSettleForArOffset((FinArRecVerApplyArSaveDTO)arp, null));
                arn.setVerAmt(BigDecimal.ZERO);
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
                arListNegativeRm.add(arn);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(this.buildSettleForArOffset((FinArRecVerApplyArSaveDTO)arn, null));
                arp.setVerAmt(arp.getVerAmt().add(arn.getVerAmt()));
                arn.setVerAmt(BigDecimal.ZERO);
                arListNegativeRm.add(arn);
            }
        }));
        arListPositive.removeAll(arListPositiveRm);
        arListNegative.removeAll(arListNegativeRm);
        if (CollectionUtils.isNotEmpty(arListPositive)) {
            Optional<FinArRecVerApplyArSaveDTO> first = arListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForArOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListPositive;
        }
        if (CollectionUtils.isNotEmpty(arListNegative)) {
            Optional<FinArRecVerApplyArSaveDTO> first = arListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForArOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListNegative;
        }
        return null;
    }

    private List<FinArRecVerApplyRecSaveDTO> doSettleForRecOffset(List<FinArRecVerApplyRecSaveDTO> recListPositive, List<FinArRecVerApplyRecSaveDTO> recListNegative, List<FinArRecVerApplySettleSaveDTO> settles) {
        recListPositive.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        recListNegative.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        List recListPositiveSorted = recListPositive.stream().sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt)).collect(Collectors.toList());
        List recListNegativeSorted = recListNegative.stream().sorted(Comparator.comparing(FinArRecVerApplyRecSaveDTO::getVerAmt)).collect(Collectors.toList());
        Collections.reverse(recListNegativeSorted);
        ArrayList recListPositiveRm = new ArrayList();
        ArrayList recListNegativeRm = new ArrayList();
        recListNegativeSorted.stream().forEach(recn -> recListPositiveSorted.stream().forEach(recp -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = BigDecimal.ZERO.compareTo(recn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(recp.getVerAmt()) == 0;
            if (writeOffFlag) {
                return;
            }
            if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(this.buildSettleForRecOffset((FinArRecVerApplyRecSaveDTO)recp, null));
                recn.setVerAmt(recn.getVerAmt().add(recp.getVerAmt()));
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
            } else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(this.buildSettleForRecOffset((FinArRecVerApplyRecSaveDTO)recn, null));
                settles.add(this.buildSettleForRecOffset((FinArRecVerApplyRecSaveDTO)recp, null));
                recn.setVerAmt(BigDecimal.ZERO);
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
                recListNegativeRm.add(recn);
            } else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(this.buildSettleForRecOffset((FinArRecVerApplyRecSaveDTO)recn, null));
                recp.setVerAmt(recp.getVerAmt().add(recn.getVerAmt()));
                recn.setVerAmt(BigDecimal.ZERO);
                recListNegativeRm.add(recn);
            }
        }));
        recListPositive.removeAll(recListPositiveRm);
        recListNegative.removeAll(recListNegativeRm);
        if (CollectionUtils.isNotEmpty(recListPositive)) {
            Optional<FinArRecVerApplyRecSaveDTO> first = recListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForRecOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListPositive;
        }
        if (CollectionUtils.isNotEmpty(recListNegative)) {
            Optional<FinArRecVerApplyRecSaveDTO> first = recListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForRecOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListNegative;
        }
        return null;
    }

    private List<FinArRecVerApplySettleSaveDTO> doSettle(List<FinArRecVerApplyArSaveDTO> arList, List<FinArRecVerApplyRecSaveDTO> recList) {
        ArrayList<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<FinArRecVerApplySettleSaveDTO>();
        arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
            if (writeOffFlag) {
                return;
            }
            if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
                rec.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, rec.getVerAmt()));
                ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                rec.setVerAmt(BigDecimal.ZERO);
            }
        }));
        return settles;
    }

    private List<FinArRecVerApplySettleSaveDTO> doSettleNew(List<FinArRecVerApplyArSaveDTO> arList, List<FinArRecVerApplyRecSaveDTO> recList) {
        boolean isPositive = arList.get(0).getVerAmt().compareTo(BigDecimal.ZERO) > 0;
        ArrayList<FinArRecVerApplySettleSaveDTO> settles = new ArrayList<FinArRecVerApplySettleSaveDTO>();
        if (isPositive) {
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                boolean writeOffFlag;
                boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                }
            }));
        } else {
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                boolean writeOffFlag;
                boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(this.buildSettle((FinArRecVerApplyArSaveDTO)ar, (FinArRecVerApplyRecSaveDTO)rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }
        return settles;
    }

    private FinArRecVerApplySettleSaveDTO buildSettle(FinArRecVerApplyArSaveDTO ar, FinArRecVerApplyRecSaveDTO rec, BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
        settle.setArId(ar.getArId());
        settle.setArDocNo(ar.getArDocNo());
        settle.setOutArDocNo(ar.getOutArDocNo());
        settle.setArDId(ar.getArDId());
        settle.setOutArDId(ar.getOutArDId());
        settle.setRecId(rec.getRecId());
        settle.setRecDocNo(rec.getRecDocNo());
        settle.setOutRecDocNo(rec.getOutRecDocNo());
        settle.setRecDId(rec.getRecDId());
        settle.setOutRecDId(rec.getOutRecDId());
        settle.setArCustCode(ar.getCustCode());
        settle.setRecCustCode(rec.getCustCode());
        settle.setArNotVerAmt(ar.getNotVerAmt());
        settle.setRecNotVerAmt(rec.getNotVerAmt());
        settle.setVerAmt(verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_NORMAL.getValueCode());
        return settle;
    }

    private FinArRecVerApplySettleSaveDTO buildSettleForArOffset(FinArRecVerApplyArSaveDTO arOffset, BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
        settle.setArId(arOffset.getArId());
        settle.setArDocNo(arOffset.getArDocNo());
        settle.setOutArDocNo(arOffset.getOutArDocNo());
        settle.setArDId(arOffset.getArDId());
        settle.setOutArDId(arOffset.getOutArDId());
        settle.setArCustCode(arOffset.getCustCode());
        settle.setArNotVerAmt(arOffset.getNotVerAmt());
        settle.setVerAmt(verAmt == null ? arOffset.getOrigVerAmt() : verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }

    private FinArRecVerApplySettleSaveDTO buildSettleForRecOffset(FinArRecVerApplyRecSaveDTO recOffset, BigDecimal verAmt) {
        FinArRecVerApplySettleSaveDTO settle = new FinArRecVerApplySettleSaveDTO();
        settle.setRecId(recOffset.getRecId());
        settle.setRecDocNo(recOffset.getRecDocNo());
        settle.setOutRecDocNo(recOffset.getOutRecDocNo());
        settle.setRecDId(recOffset.getRecDId());
        settle.setOutRecDId(recOffset.getOutRecDId());
        settle.setRecCustCode(recOffset.getCustCode());
        settle.setRecNotVerAmt(recOffset.getNotVerAmt());
        settle.setVerAmt(verAmt == null ? recOffset.getOrigVerAmt() : verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }

    @Override
    public Long autoWriteoff(List<WriteoffVO> writeoffVOS, Long schemeId) {
        if (CollectionUtils.isEmpty(writeoffVOS)) {
            return null;
        }
        FinArRecVerApplySaveDTO finArRecVerApplySaveDTO = new FinArRecVerApplySaveDTO();
        ArrayList<FinArRecVerApplyArHeadSaveDTO> arHeadSaveList = new ArrayList<FinArRecVerApplyArHeadSaveDTO>();
        ArrayList<FinArRecVerApplyRecHeadSaveDTO> recHeadSaveList = new ArrayList<FinArRecVerApplyRecHeadSaveDTO>();
        finArRecVerApplySaveDTO.setArHeadSaveList(arHeadSaveList);
        finArRecVerApplySaveDTO.setRecHeadSaveList(recHeadSaveList);
        for (WriteoffVO writeoffVO : writeoffVOS) {
            if (writeoffVO instanceof ArOrderVO) {
                ArOrderVO arOrderVO = (ArOrderVO)writeoffVO;
                FinArRecVerApplyArHeadSaveDTO finArRecVerApplyArHeadSaveDTO = ArOrderConvert.INSTANCE.convertVO2FinArRecVerApplyArHeadSaveDTO(arOrderVO);
                arHeadSaveList.add(finArRecVerApplyArHeadSaveDTO);
                continue;
            }
            if (!(writeoffVO instanceof RecOrderVO)) continue;
            RecOrderVO recOrderVO = (RecOrderVO)writeoffVO;
            FinArRecVerApplyRecHeadSaveDTO finArRecVerApplyRecHeadSaveDTO = RecOrderConvert.INSTANCE.convertVO2FinArRecVerApplyRecHeadSaveDTO(recOrderVO);
            recHeadSaveList.add(finArRecVerApplyRecHeadSaveDTO);
        }
        finArRecVerApplySaveDTO.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_AUTOMATIC.getValueCode());
        finArRecVerApplySaveDTO.setSchemeId(schemeId);
        finArRecVerApplySaveDTO.setHeadFlag(true);
        Long id = this.writeOffSubmit(finArRecVerApplySaveDTO);
        return id;
    }

    @Override
    public void autoWriteoffAr(ArOrderDTO arOrderDTO) {
        log.info("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355,-------\u5f00\u59cb");
        Long arId = arOrderDTO.getId();
        if (arId == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u5355\u636eID\u4e3a\u7a7a");
            throw new BusinessException("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u5355\u636eID\u4e3a\u7a7a");
        }
        ArOrderDTO arOrderDTO1 = this.arOrderDomainService.get(arId);
        if (arOrderDTO1 == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u67e5\u8be2\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5355\u636eID\uff1a{}", (Object)arId);
            return;
        }
        if (BigDecimal.ZERO.equals(arOrderDTO.getTotalAmt())) {
            log.info("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u5f85\u6838\u9500\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u6838\u9500\uff0c\u5355\u636eID\uff1a{}", (Object)arId);
            return;
        }
        ArOrderVO currArOrderVO = ArOrderConvert.INSTANCE.convert(arOrderDTO1);
        boolean positiveAmtFlag = arOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO) > 0;
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigDomainService.queryDef();
        if (arVerConfigDTO == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)arOrderDTO1.getArOrderNo());
            return;
        }
        Long schemeId = arVerConfigDTO.getId();
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = this.arVerConfigDtlRepoProc.queryByMasId(arVerConfigDTO.getId());
        if (CollectionUtils.isEmpty(arVerConfigDtlDTOS)) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\u660e\u7ec6\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\u7f16\u7801\uff1a{}", (Object)arOrderDTO1.getArOrderNo());
            return;
        }
        Boolean redOffsetFlag = arVerConfigDTO.getRedOffsetFlag();
        String writeoffOrder = arVerConfigDTO.getWriteoffOrder();
        String ou_code = null;
        String cust_code = null;
        String curr_code = null;
        String so_doc_no = null;
        for (ArVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if ("ou_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                ou_code = arOrderDTO1.getOuCode();
                continue;
            }
            if ("cust_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                cust_code = arOrderDTO1.getCustCode();
                continue;
            }
            if ("curr_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                curr_code = arOrderDTO1.getCurrCode();
                continue;
            }
            if (!"so_doc_no".equals(arVerConfigDtlDTO.getFieldNo()) || !arVerConfigDtlDTO.getMatchFlag().booleanValue()) continue;
            so_doc_no = arOrderDTO1.getSourceNo();
        }
        boolean asc = true;
        if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)) {
            asc = true;
        } else if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)) {
            asc = false;
        }
        boolean finAsc = asc;
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("buDate");
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ArOrderVO> arOrderVOPagingVO = null;
        if (redOffsetFlag.booleanValue()) {
            ArOrderPageParam arOrderPageParam = new ArOrderPageParam();
            arOrderPageParam.setOuCode(ou_code);
            arOrderPageParam.setCustCode(cust_code);
            arOrderPageParam.setCurrCode(curr_code);
            arOrderPageParam.setOrders(orders);
            arOrderPageParam.setSize(Integer.MAX_VALUE);
            if (positiveAmtFlag) {
                arOrderPageParam.setWriteOfFAmtCon("LT0");
            } else {
                arOrderPageParam.setWriteOfFAmtCon("GT0");
            }
            arOrderVOPagingVO = this.arOrderService.writeoffPage(arOrderPageParam);
        }
        RecOrderPageParam recOrderPageParam = new RecOrderPageParam();
        recOrderPageParam.setOuCode(ou_code);
        recOrderPageParam.setCustCode(cust_code);
        recOrderPageParam.setCurrCode(curr_code);
        orderItem.setColumn("reDate");
        recOrderPageParam.setOrders(orders);
        recOrderPageParam.setSize(Integer.MAX_VALUE);
        if (positiveAmtFlag) {
            recOrderPageParam.setWriteOfFAmtCon("GT0");
        } else {
            recOrderPageParam.setWriteOfFAmtCon("LT0");
        }
        PagingVO<RecOrderVO> recOrderVOPagingVO = this.recOrderService.writeoffPage(recOrderPageParam);
        ArrayList allList = new ArrayList();
        List arOrderVOS = null;
        if (arOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)arOrderVOPagingVO.getRecords())) {
            arOrderVOS = arOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(arId)).collect(Collectors.toList());
            allList.addAll(arOrderVOS);
        }
        if (recOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)recOrderVOPagingVO.getRecords())) {
            allList.addAll(recOrderVOPagingVO.getRecords());
        }
        if (CollectionUtils.isEmpty(allList)) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u672a\u5339\u914d\u5230\u5f85\u6838\u9500\u5355\u636e\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)arOrderDTO.getArOrderNo());
            return;
        }
        CollUtil.sort(allList, (o1, o2) -> {
            if (finAsc) {
                return o1.getBuDate().compareTo(o2.getBuDate());
            }
            return o2.getBuDate().compareTo(o1.getBuDate());
        });
        BigDecimal unVerAmtBalance = arOrderDTO1.getTotalAmt();
        ArrayList<WriteoffVO> matchList = new ArrayList<WriteoffVO>();
        if (positiveAmtFlag) {
            for (WriteoffVO writeoffVO : allList) {
                if (writeoffVO instanceof ArOrderVO) {
                    if (writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    } else {
                        if (writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance) < 0) {
                            writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                            matchList.add(writeoffVO);
                            unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                            continue;
                        }
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }
                } else if (writeoffVO.getUnVerAmt().equals(unVerAmtBalance)) {
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                } else {
                    if (writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance) < 0) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        continue;
                    }
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                }
                break;
            }
        } else {
            for (WriteoffVO writeoffVO : allList) {
                if (writeoffVO instanceof ArOrderVO) {
                    if (writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    } else {
                        if (writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs()) < 0) {
                            writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                            matchList.add(writeoffVO);
                            unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                            continue;
                        }
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }
                } else if (writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())) {
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                } else {
                    if (writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs()) < 0) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        continue;
                    }
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                }
                break;
            }
        }
        if (unVerAmtBalance.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355\uff0c\u672a\u5339\u914d\u5230\u8db3\u591f\u7684\u6838\u9500\u91d1\u989d\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)arOrderDTO.getArOrderNo());
            return;
        }
        currArOrderVO.setVerAmt(currArOrderVO.getTotalAmt());
        matchList.add(currArOrderVO);
        this.autoWriteoff(matchList, schemeId);
        log.info("\u81ea\u52a8\u6838\u9500\u5e94\u6536\u5355,-------\u7ed3\u675f");
    }

    @Override
    public void autoWriteoffRec(RecOrderDTO recOrderDTO) {
        log.info("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355,-------\u5f00\u59cb");
        Long recId = recOrderDTO.getId();
        if (recId == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u5355\u636eID\u4e3a\u7a7a");
            throw new BusinessException("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u5355\u636eID\u4e3a\u7a7a");
        }
        RecOrderDTO recOrderDTO1 = this.recOrderDomainService.queryById(recId, false);
        if (recOrderDTO1 == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u67e5\u8be2\u6536\u6b3e\u5355\u5931\u8d25\uff0c\u5355\u636eID\uff1a{}", (Object)recId);
            return;
        }
        if (BigDecimal.ZERO.equals(recOrderDTO1.getTotalAmt())) {
            log.info("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u5f85\u6838\u9500\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u6838\u9500\uff0c\u5355\u636eID\uff1a{}", (Object)recId);
            return;
        }
        RecOrderVO currRecOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO1);
        boolean positiveAmtFlag = recOrderDTO1.getTotalAmt().compareTo(BigDecimal.ZERO) > 0;
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigDomainService.queryDef();
        if (arVerConfigDTO == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)recOrderDTO1.getRecOrderNo());
            return;
        }
        Long schemeId = arVerConfigDTO.getId();
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = this.arVerConfigDtlRepoProc.queryByMasId(arVerConfigDTO.getId());
        if (CollectionUtils.isEmpty(arVerConfigDtlDTOS)) {
            log.error("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\u660e\u7ec6\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)recOrderDTO1.getRecOrderNo());
            return;
        }
        Boolean redOffsetFlag = arVerConfigDTO.getRedOffsetFlag();
        String writeoffOrder = arVerConfigDTO.getWriteoffOrder();
        String ou_code = null;
        String cust_code = null;
        String curr_code = null;
        String so_doc_no = null;
        for (ArVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if ("ou_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                ou_code = recOrderDTO1.getOuCode();
                continue;
            }
            if ("cust_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                cust_code = recOrderDTO1.getCustCode();
                continue;
            }
            if ("curr_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                curr_code = recOrderDTO1.getCurrCode();
                continue;
            }
            if (!"so_doc_no".equals(arVerConfigDtlDTO.getFieldNo()) || !arVerConfigDtlDTO.getMatchFlag().booleanValue()) continue;
            so_doc_no = recOrderDTO1.getSourceNo();
        }
        boolean asc = true;
        if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)) {
            asc = true;
        } else if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)) {
            asc = false;
        }
        boolean finAsc = asc;
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ArOrderVO> arOrderVOPagingVO = null;
        PagingVO<RecOrderVO> recOrderVOPagingVO = null;
        if (redOffsetFlag.booleanValue()) {
            RecOrderPageParam recOrderPageParam = new RecOrderPageParam();
            recOrderPageParam.setOuCode(ou_code);
            recOrderPageParam.setCustCode(cust_code);
            recOrderPageParam.setCurrCode(curr_code);
            orderItem.setColumn("reDate");
            recOrderPageParam.setOrders(orders);
            recOrderPageParam.setSize(Integer.MAX_VALUE);
            if (positiveAmtFlag) {
                recOrderPageParam.setWriteOfFAmtCon("LT0");
            } else {
                recOrderPageParam.setWriteOfFAmtCon("GT0");
            }
            recOrderVOPagingVO = this.recOrderService.writeoffPage(recOrderPageParam);
        }
        orderItem.setColumn("buDate");
        ArOrderPageParam arOrderPageParam = new ArOrderPageParam();
        arOrderPageParam.setOuCode(ou_code);
        arOrderPageParam.setCustCode(cust_code);
        arOrderPageParam.setCurrCode(curr_code);
        arOrderPageParam.setOrders(orders);
        arOrderPageParam.setSize(Integer.MAX_VALUE);
        if (positiveAmtFlag) {
            arOrderPageParam.setWriteOfFAmtCon("GT0");
        } else {
            arOrderPageParam.setWriteOfFAmtCon("LT0");
        }
        arOrderVOPagingVO = this.arOrderService.writeoffPage(arOrderPageParam);
        ArrayList allList = new ArrayList();
        List recOrderVOS = null;
        if (recOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)recOrderVOPagingVO.getRecords())) {
            recOrderVOS = recOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(recId)).collect(Collectors.toList());
            allList.addAll(recOrderVOS);
        }
        if (arOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)arOrderVOPagingVO.getRecords())) {
            allList.addAll(arOrderVOPagingVO.getRecords());
        }
        if (CollectionUtils.isEmpty(allList)) {
            log.error("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u672a\u5339\u914d\u5230\u5f85\u6838\u9500\u5355\u636e\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)recOrderDTO1.getRecOrderNo());
            return;
        }
        CollUtil.sort(allList, (o1, o2) -> {
            if (finAsc) {
                return o1.getBuDate().compareTo(o2.getBuDate());
            }
            return o2.getBuDate().compareTo(o1.getBuDate());
        });
        BigDecimal unVerAmtBalance = recOrderDTO1.getTotalAmt();
        ArrayList<WriteoffVO> matchList = new ArrayList<WriteoffVO>();
        if (positiveAmtFlag) {
            for (WriteoffVO writeoffVO : allList) {
                if (writeoffVO instanceof RecOrderVO) {
                    if (writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance)) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    } else {
                        if (writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance) < 0) {
                            writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                            matchList.add(writeoffVO);
                            unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                            continue;
                        }
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().abs());
                    }
                } else if (writeoffVO.getUnVerAmt().equals(unVerAmtBalance)) {
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                } else {
                    if (writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance) < 0) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        continue;
                    }
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                }
                break;
            }
        } else {
            for (WriteoffVO writeoffVO : allList) {
                if (writeoffVO instanceof RecOrderVO) {
                    if (writeoffVO.getUnVerAmt().equals(unVerAmtBalance.abs())) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    } else {
                        if (writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance.abs()) < 0) {
                            writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                            matchList.add(writeoffVO);
                            unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                            continue;
                        }
                        writeoffVO.setVerAmt(unVerAmtBalance.multiply(BigDecimal.valueOf(-1L)));
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt().multiply(BigDecimal.valueOf(-1L)));
                    }
                } else if (writeoffVO.getUnVerAmt().abs().equals(unVerAmtBalance.abs())) {
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                } else {
                    if (writeoffVO.getUnVerAmt().abs().compareTo(unVerAmtBalance.abs()) < 0) {
                        writeoffVO.setVerAmt(writeoffVO.getUnVerAmt());
                        matchList.add(writeoffVO);
                        unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                        continue;
                    }
                    writeoffVO.setVerAmt(unVerAmtBalance);
                    matchList.add(writeoffVO);
                    unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getVerAmt());
                }
                break;
            }
        }
        if (unVerAmtBalance.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355\uff0c\u672a\u5339\u914d\u5230\u8db3\u591f\u7684\u6838\u9500\u91d1\u989d\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)recOrderDTO1.getRecOrderNo());
            return;
        }
        currRecOrderVO.setVerAmt(currRecOrderVO.getTotalAmt());
        matchList.add(currRecOrderVO);
        this.autoWriteoff(matchList, schemeId);
        log.info("\u81ea\u52a8\u6838\u9500\u6536\u6b3e\u5355,-------\u7ed3\u675f");
    }

    public FinArRecVerApplyServiceImpl(UdcProvider udcProvider, FinArRecVerApplyRepoProc finArRecVerApplyRepoProc, FinArRecVerApplyArService finArRecVerApplyArService, FinArRecVerApplyArHeadService finArRecVerApplyArHeadService, FinArRecVerApplyRecService finArRecVerApplyRecService, FinArRecVerApplyRecHeadService finArRecVerApplyRecHeadService, SeqNumProvider seqNumProvider, FinArRecVerLocalService finArRecVerLocalService, ArOrderExService arOrderExService, RecOrderExService recOrderExService, FinArRecVerApplySettleService finArRecVerApplySettleService, OperationLogService operationLogService, ThreadLocalCopyUtil threadLocalCopyUtil, ArOrderDtlService arOrderDtlService, RecOrderDtlService recOrderDtlService, RecOrderService recOrderService, ArVerConfigDomainService arVerConfigDomainService, ArVerConfigDtlRepoProc arVerConfigDtlRepoProc, ArOrderDomainService arOrderDomainService, RecOrderDomainService recOrderDomainService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.udcProvider = udcProvider;
        this.finArRecVerApplyRepoProc = finArRecVerApplyRepoProc;
        this.finArRecVerApplyArService = finArRecVerApplyArService;
        this.finArRecVerApplyArHeadService = finArRecVerApplyArHeadService;
        this.finArRecVerApplyRecService = finArRecVerApplyRecService;
        this.finArRecVerApplyRecHeadService = finArRecVerApplyRecHeadService;
        this.seqNumProvider = seqNumProvider;
        this.finArRecVerLocalService = finArRecVerLocalService;
        this.arOrderExService = arOrderExService;
        this.recOrderExService = recOrderExService;
        this.finArRecVerApplySettleService = finArRecVerApplySettleService;
        this.operationLogService = operationLogService;
        this.threadLocalCopyUtil = threadLocalCopyUtil;
        this.arOrderDtlService = arOrderDtlService;
        this.recOrderDtlService = recOrderDtlService;
        this.recOrderService = recOrderService;
        this.arVerConfigDomainService = arVerConfigDomainService;
        this.arVerConfigDtlRepoProc = arVerConfigDtlRepoProc;
        this.arOrderDomainService = arOrderDomainService;
        this.recOrderDomainService = recOrderDomainService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

