/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.recorder;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RecOrderDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;

    public List<Long> queryBySourceNo(String sourceNo) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qRecOrderDtlDO.masId).where((Predicate)this.qRecOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))).from((EntityPath)this.qRecOrderDtlDO)).fetch();
    }

    public List<Long> queryBySourceNoList(List<String> sourceNoList) {
        if (CollectionUtil.isEmpty(sourceNoList)) {
            return Collections.EMPTY_LIST;
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qRecOrderDtlDO.masId).from((EntityPath)this.qRecOrderDtlDO)).where((Predicate)this.qRecOrderDtlDO.sourceNo.in(sourceNoList))).fetch();
    }

    public List<Long> queryUnverBySourceNo(RecOrderPageParam param) {
        String sourceNo = param.getSourceNoDtl();
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)sourceNo)) {
            predicates.add(this.qRecOrderDtlDO.sourceNo.like("%" + sourceNo + "%"));
        }
        predicates.add(this.qRecOrderDtlDO.deleteFlag.eq((Object)0));
        if (StringUtils.isNotBlank((CharSequence)param.getWriteOfFAmtCon())) {
            if ("GT0".equals(param.getWriteOfFAmtCon())) {
                predicates.add(this.qRecOrderDtlDO.unVerAmt.gt((Number)BigDecimal.ZERO));
            } else if ("LT0".equals(param.getWriteOfFAmtCon())) {
                predicates.add(this.qRecOrderDtlDO.unVerAmt.lt((Number)BigDecimal.ZERO));
            }
        } else {
            predicates.add(this.qRecOrderDtlDO.unVerAmt.ne((Object)BigDecimal.ZERO));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qRecOrderDtlDO.masId).where(ExpressionUtils.allOf(predicates))).from((EntityPath)this.qRecOrderDtlDO)).fetch();
    }

    public void deleteByMasId(List<Long> masId) {
        this.jpaQueryFactory.delete((EntityPath)this.qRecOrderDtlDO).where(new Predicate[]{this.qRecOrderDtlDO.masId.in(masId)}).execute();
    }

    public PagingVO<RecOrderDtlDTO> page(RecOrderDtlPageParam pageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (pageParam.getMisId() != null) {
            predicates.add(this.qRecOrderDtlDO.masId.eq((Object)pageParam.getMisId()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getMasIds())) {
            predicates.add(this.qRecOrderDtlDO.masId.in(pageParam.getMasIds()));
        }
        JPAQuery query = (JPAQuery)this.select(RecOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, this.qRecOrderDtlDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    @SysCodeProc
    public List<RecOrderDtlDTO> queryByMasId(Long masId) {
        return ((JPAQuery)this.select(RecOrderDtlDTO.class).where((Predicate)this.qRecOrderDtlDO.masId.in((Object[])new Long[]{masId}))).fetch();
    }

    public List<RecOrderDtlDTO> queryByMasIds(List<Long> masIds) {
        return ((JPAQuery)this.select(RecOrderDtlDTO.class).where((Predicate)this.qRecOrderDtlDO.masId.in(masIds))).fetch();
    }

    public void deleteByMasIds(List<Long> masIds) {
        this.jpaQueryFactory.delete((EntityPath)this.qRecOrderDtlDO).where(new Predicate[]{this.qRecOrderDtlDO.masId.in(masIds)}).execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qRecOrderDtlDO.id, this.qRecOrderDtlDO.masId, this.qRecOrderDtlDO.recType, this.qRecOrderDtlDO.recKind, this.qRecOrderDtlDO.recBank, this.qRecOrderDtlDO.recAccount, this.qRecOrderDtlDO.recFlow, this.qRecOrderDtlDO.sourceNo, this.qRecOrderDtlDO.sourceId, this.qRecOrderDtlDO.sourceLine, this.qRecOrderDtlDO.sourceLineId, this.qRecOrderDtlDO.realRecAmt, this.qRecOrderDtlDO.realRecCurAmt, this.qRecOrderDtlDO.taxAmt, this.qRecOrderDtlDO.taxRate, this.qRecOrderDtlDO.totalAmt, this.qRecOrderDtlDO.totalCurAmt, this.qRecOrderDtlDO.expensesType, this.qRecOrderDtlDO.remark, this.qRecOrderDtlDO.taxCurAmt, this.qRecOrderDtlDO.relateId, this.qRecOrderDtlDO.verAmt, this.qRecOrderDtlDO.unVerAmt, this.qRecOrderDtlDO.applyVerAmTing, this.qRecOrderDtlDO.es16, this.qRecOrderDtlDO.es17})).from((EntityPath)this.qRecOrderDtlDO);
    }

    public void updateByMasId(SendPayReq payReq, Long id) {
        this.jpaQueryFactory.update((EntityPath)this.qRecOrderDtlDO).set((Path)this.qRecOrderDtlDO.recBank, (Object)payReq.getRecBank()).set((Path)this.qRecOrderDtlDO.recType, (Object)payReq.getRecType()).set((Path)this.qRecOrderDtlDO.recAccount, (Object)payReq.getRecAcc()).where(new Predicate[]{this.qRecOrderDtlDO.masId.in((Object[])new Long[]{id})}).execute();
    }

    public RecOrderDtlRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

