/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.service.aptype.ApTypeService;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.dto.recorder.RecOrderRpcDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.param.recorder.RecOrderRpcPageParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.param.recorder.WeChatPayRecOrderRpcParam;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgStoreRpcServiceService;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import com.elitesland.fin.utils.BigDecimalUtil;
import com.elitesland.inv.dto.companyAndCust.CompanyAndCustRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroDRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.dto.pay.TroPayRpcDTO;
import com.elitesland.inv.provider.InvCompanyAndCustProvider;
import com.elitesland.inv.provider.InvTroProvider;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.inv.provider.TroPayProvider;
import com.elitesland.pur.dto.PoPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoDDTO;
import com.elitesland.pur.dto.po.PurPoDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PoPayProvider;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.path.SupportTransactionPathRpcService;
import com.elitesland.support.provider.path.dto.SupportTransactionPathDRpcDTO;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/recOrder"})
public class RecOrderRpcServiceImpl
implements RecOrderRpcService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderRpcServiceImpl.class);
    private final PayTypeService payTypeService;
    private final RecTypeDomainService recTypeDomainService;
    public final RecOrderDomainService recOrderDomainService;
    public final RecOrderRpcTwoService recOrderRpcTwoService;
    private final ApTypeService apTypeService;
    private final InvCompanyAndCustProvider invCompanyAndCustProvider;
    private final OrgStoreRpcService orgStoreRpcService;
    private final InvTroProvider invTroProvider;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService;
    private final RecOrderService recOrderService;
    private final TransactionTemplate transactionTemplate;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final PayOrderRepoProc payOrderRepoProc;
    private final PurSuppOutService purSuppOutService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final PayOrderService payOrderService;
    private final PaymentRuleConfigService paymentRuleConfigService;
    @PersistenceContext
    private EntityManager entityManager;
    private final TroPayProvider troPayProvider;
    private final PoPayProvider poPayProvider;
    private final PurPoProvider purPoProvider;
    private final InvWhProvider invWhProvider;
    private final SupportTransactionPathRpcService supportTransactionPathRpcService;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final TaskExecutor taskExecutor;
    @Autowired
    private SysMsgTemplateSendRpcService sysMsgTemplateSendRpcService;

    public Long save(RecOrderRpcParam recOrderRpcParam) {
        if (CharSequenceUtil.isBlank((CharSequence)recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        recOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = this.recOrderDomainService.save(recOrder);
        return resId;
    }

    public ApiResult<PagingVO<RecOrderRpcDTO>> page(RecOrderRpcPageParam recOrderRpcPageParam) {
        PagingVO<RecOrderRpcPageRespVo> recOrderRpcPageRespVoPagingVO = this.recOrderRpcTwoService.queryRecOrderRpcPageList(RecOrderConvert.INSTANCE.recOrderRpcPageParam2RecOrderRpcTwoParam(recOrderRpcPageParam));
        return ApiResult.ok(RecOrderConvert.INSTANCE.recOrderRpcPageRespVoPagingVO2RecOrderRpcDTOPagingVO(recOrderRpcPageRespVoPagingVO));
    }

    public Long wechatPay(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam) {
        Long resId;
        block9: {
            log.info("\u5fae\u4f01\u4ed8\u751f\u6210\u6536\u6b3e\u5355:weChatPayRecOrderRpcParam:{}", (Object)JSONUtil.toJsonStr((Object)weChatPayRecOrderRpcParam));
            String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();
            try {
                this.checkIfExist(sourceNo);
            }
            catch (Exception e) {
                this.sendWechatBoot(sourceNo, e.getMessage());
            }
            HashMap<String, Long> docIdMap = new HashMap<String, Long>();
            HashMap<Long, BigDecimal> receiptAmtMap = new HashMap<Long, BigDecimal>();
            RecOrderSaveParam param = null;
            try {
                param = this.getRecOrderSaveParam(weChatPayRecOrderRpcParam, docIdMap, receiptAmtMap);
            }
            catch (Exception e) {
                this.sendWechatBoot(sourceNo, e.getMessage());
            }
            log.info("\u5355\u636e\u53f7:{},receiptAmtMap:{}", (Object)JSONUtil.toJsonStr(docIdMap), (Object)JSONUtil.toJsonStr(receiptAmtMap));
            Long docId = (Long)docIdMap.get("docId");
            HashMap paymentRuleIdsMap = new HashMap();
            this.transactionTemplate.setPropagationBehavior(3);
            RecOrderSaveParam finalParam = param;
            resId = (Long)this.transactionTemplate.execute(trans -> {
                Long id = null;
                try {
                    id = (Long)this.recOrderService.save(finalParam).getData();
                    this.entityManager.flush();
                    this.entityManager.clear();
                    String recOrderNo = this.recOrderService.queryById(id).getRecOrderNo();
                    log.info("\u5df2\u7ecf\u5b8c\u6210\u6536\u6b3e\u5355\u521b\u5efa:{},\u6536\u6b3e\u5355\u53f7:{}", (Object)JSONUtil.toJsonStr((Object)finalParam), (Object)recOrderNo);
                    RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(id);
                    List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasId(id);
                    PayOrderSaveParam payOrderSaveParam = this.getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                    this.payOrderService.save(payOrderSaveParam);
                    log.info("\u5df2\u7ecf\u5b8c\u6210\u4ed8\u6b3e\u5355\u521b\u5efa");
                    Set<Long> paymentRuleIds = this.generateStoreAccountFlow(finalParam, recOrderNo, id);
                    paymentRuleIdsMap.put("paymentRuleIds", paymentRuleIds);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58\u6536\u6b3e\u5355\u751f\u6210\u6d41\u6c34\u53d1\u751f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
                    this.sendWechatBoot(sourceNo, e.getMessage());
                    trans.setRollbackOnly();
                }
                return id;
            });
            log.info("\u652f\u4ed8\u89c4\u5219id\u5b57\u5178:{}", (Object)JSONUtil.toJsonStr(paymentRuleIdsMap));
            try {
                Set paymentRuleIds = (Set)paymentRuleIdsMap.get("paymentRuleIds");
                BigDecimal receiptAmt = receiptAmtMap.getOrDefault(docId, BigDecimal.ZERO);
                if (sourceNo.startsWith("PO")) {
                    PoPayRpcDTO poPayRpcDTO = new PoPayRpcDTO();
                    poPayRpcDTO.setId(docId);
                    poPayRpcDTO.setDocNo(sourceNo);
                    poPayRpcDTO.setReceiptAmt(receiptAmt);
                    poPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                    log.info("\u8c03\u7528\u91c7\u8d2d\u8ba2\u5355\u652f\u4ed8,\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)poPayRpcDTO));
                    this.poPayProvider.pay(poPayRpcDTO);
                    break block9;
                }
                try {
                    TroPayRpcDTO troPayRpcDTO = new TroPayRpcDTO();
                    troPayRpcDTO.setId(docId);
                    troPayRpcDTO.setDocNo(sourceNo);
                    troPayRpcDTO.setReceiptAmt(receiptAmt);
                    troPayRpcDTO.setPaymentRuleConfigDtlIds(paymentRuleIds);
                    log.info("\u8c03\u7528\u8c03\u62e8\u8ba2\u5355\u652f\u4ed8,\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)troPayRpcDTO));
                    this.troPayProvider.pay(troPayRpcDTO);
                }
                catch (Exception e) {
                    log.warn("\u8c03\u7528\u8c03\u62e8\u8ba2\u5355\u652f\u4ed8\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                    throw new com.elitescloud.boot.exception.BusinessException("\u8c03\u7528\u8c03\u62e8\u8ba2\u5355\u652f\u4ed8\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.sendWechatBoot(sourceNo, e.getMessage());
            }
        }
        log.info("\u8c03\u7528\u8c03\u62e8\u8ba2\u5355\u652f\u4ed8\u5b8c\u6210");
        this.entityManager.flush();
        this.entityManager.clear();
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(resId);
        log.info("\u5fae\u4f01\u4ed8\u751f\u6210\u6536\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500:{}", (Object)JSONUtil.toJsonStr((Object)recOrderDTO));
        CompletableFuture.runAsync(() -> this.finArRecVerApplyService.autoWriteoffRec(recOrderDTO), (Executor)this.taskExecutor);
        log.info("\u5fae\u4f01\u4ed8\u8fd4\u56de");
        return resId;
    }

    private PayOrderSaveParam getPayOrderSaveParam(RecOrderDTO recOrderDTO, List<RecOrderDtlDTO> recOrderDtlDTOS) {
        List<PayOrderDO> payOrderDOS;
        log.info("\u751f\u6210\u4ed8\u6b3e\u5355\u5165\u53c2:recOrderDTO:{},recOrderDtlDTOS:{}", (Object)JSONUtil.toJsonStr((Object)recOrderDTO), (Object)JSONUtil.toJsonStr(recOrderDtlDTOS));
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(recOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u7f16\u7801:{}", (Object)corBusinCode);
        if (StrUtil.isBlank((CharSequence)corBusinCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(recOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = this.purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u6536\u6b3e\u5355\u516c\u53f8\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        PayOrderSaveParam param = new PayOrderSaveParam();
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());
        param.setCurrCode(recOrderDTO.getCurrCode());
        param.setCurrName(recOrderDTO.getCurrName());
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        param.setSourceNo(recOrderDTO.getRecOrderNo());
        param.setPayTypeCode("AP");
        param.setPayTypeName("\u6807\u51c6\u4ed8\u6b3e");
        param.setPayTypeId(this.getApTypeIdByCode("AP"));
        param.setCreateMode("REC");
        param.setTotalAmt(recOrderDTO.getTotalAmt());
        param.setRealPayAmt(recOrderDTO.getRealRecAmt());
        param.setBuDate(recOrderDTO.getReDate());
        param.setInitFlag(recOrderDTO.getInitFlag());
        param.setTotalCurAmt(recOrderDTO.getTotalCurAmt());
        param.setRealPayCurAmt(recOrderDTO.getRealRecCurAmt());
        param.setApDate(recOrderDTO.getReDate());
        param.setApFlag(recOrderDTO.getReFlag());
        param.setExchangeRate(recOrderDTO.getExchangeRate());
        param.setOrderState("COMPLETE");
        param.setRedState(recOrderDTO.getRedState());
        String redSourceNo = recOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(payOrderDOS = this.payOrderRepoProc.queryBySourceNo(redSourceNo))) {
            PayOrderDO payOrderDO = payOrderDOS.get(0);
            param.setRedSourceNo(payOrderDO.getPayOrderNo());
            param.setRedSourceId(payOrderDO.getId());
            param.setRedState(true);
        }
        Map<String, List<RecOrderDtlDTO>> groupedData = recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getRecAccount() + e.getEs16()));
        log.info("\u5206\u7ec4\u540e groupedData:{}", (Object)JSONUtil.toJsonStr(groupedData));
        param.setProposedStatus("DRAFT");
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = groupedData.entrySet().stream().map(entry -> {
            BigDecimal realRecAmtTotal = BigDecimal.ZERO;
            BigDecimal realRecCurAmtTotal = BigDecimal.ZERO;
            for (RecOrderDtlDTO recOrderDtlDTO : (List)entry.getValue()) {
                realRecAmtTotal = realRecAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecAmt()));
                realRecCurAmtTotal = realRecCurAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecCurAmt()));
            }
            RecOrderDtlDTO payorderDtlDto = (RecOrderDtlDTO)((List)entry.getValue()).get(0);
            BigDecimal totalAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalAmt() != null).map(RecOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalCurAmt() != null).map(RecOrderDtlDTO::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            PayOrderDtlSaveParam payOrderDtlSaveParam = new PayOrderDtlSaveParam();
            payOrderDtlSaveParam.setSourceLine(payorderDtlDto.getSourceLine());
            payOrderDtlSaveParam.setSourceLineId(payorderDtlDto.getSourceLineId());
            payOrderDtlSaveParam.setPayType(payorderDtlDto.getRecType());
            payOrderDtlSaveParam.setPayBank(payorderDtlDto.getEs17());
            payOrderDtlSaveParam.setPayAccount(payorderDtlDto.getEs16());
            payOrderDtlSaveParam.setTotalAmt(totalAmt);
            payOrderDtlSaveParam.setTotalCurAmt(totalCurAmt);
            payOrderDtlSaveParam.setRecBank(payorderDtlDto.getRecBank());
            payOrderDtlSaveParam.setRecAccount(payorderDtlDto.getRecAccount());
            payOrderDtlSaveParam.setRealPayAmt(realRecAmtTotal);
            payOrderDtlSaveParam.setRealPayCurAmt(realRecCurAmtTotal);
            payOrderDtlSaveParam.setVerAmt(BigDecimal.ZERO);
            payOrderDtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            payOrderDtlSaveParam.setUnVerAmt(param.getTotalAmt());
            return payOrderDtlSaveParam;
        }).collect(Collectors.toList());
        param.setPayOrderDtlSaveParams(payOrderDtlSaveParams);
        log.info("\u751f\u6210\u4ed8\u6b3e\u5355\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private Set<Long> generateStoreAccountFlow(RecOrderSaveParam param, String recOrderNo, Long resId) {
        log.info("\u5f00\u59cb\u67e5\u8be2\u8d26\u6237\u4fe1\u606f,\u6536\u6b3e\u516c\u53f8\u7f16\u7801:{},\u5ba2\u6237\u7f16\u7801:{}", (Object)param.getRecOuCode(), (Object)param.getCustCode());
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOS = this.queryAccountInfo(param.getRecOuCode(), param.getCustCode(), param.getSourceNo());
        if (CollUtil.isEmpty(paymentRuleConfigDtlDTOS)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5ba2\u6237\u8d26\u53f7\u6709\u8bef\uff01");
        }
        log.info("\u8d26\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(paymentRuleConfigDtlDTOS));
        Set<Long> paymentRuleIds = paymentRuleConfigDtlDTOS.stream().map(BaseModelDTO::getId).collect(Collectors.toSet());
        PaymentRuleConfigDtlDTO storePaymentRuleConfig = paymentRuleConfigDtlDTOS.stream().filter(e -> "STORE".equals(e.getAccountType())).findFirst().orElseThrow(new com.elitescloud.boot.exception.BusinessException("\u6ca1\u6709\u627e\u5173\u8054\u7684\u50a8\u503c\u8d26\u6237\uff0c\u65e0\u6cd5\u4ea7\u751f\u8d26\u6237\u6d41\u6c34"));
        log.info("\u50a8\u503c\u8d26\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)storePaymentRuleConfig));
        ArrayList<GenerateAccountFlowRpcParam> params = new ArrayList<GenerateAccountFlowRpcParam>();
        params.add(this.createGenerateAccountFlowRpcParam("SKD", "SKD", "COMPLETE", recOrderNo, resId, "STORE", storePaymentRuleConfig.getAccountTypeName(), storePaymentRuleConfig.getAccountCode(), storePaymentRuleConfig.getAccountName(), param.getTotalAmt()));
        log.info("\u8c03\u7528\u8d22\u52a1\u57df\u751f\u6210\u8d26\u6237\u6d41\u6c34,\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr(params));
        List<GenerateAccountFlowRpcDTO> generateAccountFlowRpcDTOS = this.generateAccountFlow(params, Boolean.TRUE);
        log.info("\u8c03\u7528\u8d22\u52a1\u57df\u751f\u6210\u8d26\u6237\u6d41\u6c34,\u7ed3\u679c:{}", (Object)JSONUtil.toJsonStr(generateAccountFlowRpcDTOS));
        return paymentRuleIds;
    }

    private List<GenerateAccountFlowRpcDTO> generateAccountFlow(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList, Boolean needMerge) {
        ApiResult refundResult;
        log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u53c2\u6570(\u5408\u5e76\u524d)\uff1a{}", (Object)JSONUtil.toJsonStr(generateAccountFlowRpcParamList));
        GenerateAccountFlowRpcService rpcService = (GenerateAccountFlowRpcService)SpringUtil.getBean(GenerateAccountFlowRpcService.class);
        if (needMerge.booleanValue()) {
            List<GenerateAccountFlowRpcParam> params = RecOrderRpcServiceImpl.mergeParams(generateAccountFlowRpcParamList);
            log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u53c2\u6570(\u5408\u5e76\u540e)\uff1a{}", (Object)JSONUtil.toJsonStr(params));
            refundResult = rpcService.generateAccountFlow(params);
        } else {
            refundResult = rpcService.generateAccountFlow(generateAccountFlowRpcParamList);
        }
        log.info("\u3010\u8c03\u7528\u8d22\u52a1\u57df\u3011\u751f\u6210\u6d41\u6c34-\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr((Object)refundResult));
        if (!refundResult.isSuccess()) {
            throw new com.elitescloud.boot.exception.BusinessException("\u8d22\u52a1\u57df\u751f\u6210\u6d41\u6c34\u62a5\u9519\uff1a" + refundResult.getMsg());
        }
        return (List)refundResult.getData();
    }

    private static List<GenerateAccountFlowRpcParam> mergeParams(List<GenerateAccountFlowRpcParam> generateAccountFlowRpcParamList) {
        HashMap<CallSite, GenerateAccountFlowRpcParam> generateAccountFlowRpcParamMap = new HashMap<CallSite, GenerateAccountFlowRpcParam>();
        for (GenerateAccountFlowRpcParam generateAccountFlowRpcParam : generateAccountFlowRpcParamList) {
            String key = generateAccountFlowRpcParam.getAccountType() + "-" + generateAccountFlowRpcParam.getAccountCode();
            if (!generateAccountFlowRpcParamMap.containsKey(key)) {
                generateAccountFlowRpcParamMap.put((CallSite)((Object)key), generateAccountFlowRpcParam);
                continue;
            }
            GenerateAccountFlowRpcParam param = (GenerateAccountFlowRpcParam)generateAccountFlowRpcParamMap.get(key);
            param.setDocAmount(param.getDocAmount().add(generateAccountFlowRpcParam.getDocAmount()));
        }
        return generateAccountFlowRpcParamMap.values().stream().collect(Collectors.toList());
    }

    private GenerateAccountFlowRpcParam createGenerateAccountFlowRpcParam(String docNo, String docType, String docStatus, String soDocNo, Long sourceId, String accountType, String accountTypeName, String payAccNo, String payAccName, BigDecimal docAmount) {
        GenerateAccountFlowRpcParam param = new GenerateAccountFlowRpcParam();
        param.setDoc(docNo);
        param.setDocType(docType);
        param.setDocStatus(docStatus);
        param.setDocAmount(docAmount);
        param.setSourceId(sourceId);
        param.setSourceNo(soDocNo);
        param.setAccountType(accountType);
        param.setAccountTypeName(accountTypeName);
        param.setAccountCode(payAccNo);
        param.setAccountName(payAccName);
        log.info("\u6d41\u6c34\u6784\u9020\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    public List<PaymentRuleConfigDtlDTO> queryAccountInfo(String ouCode, String custCode, String docNo) {
        if (StrUtil.isBlank((CharSequence)ouCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)custCode)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PaymentRuleConfigParam param = new PaymentRuleConfigParam();
        if (docNo.startsWith("PO")) {
            param.setDoc("PO");
            param.setDocType("PO");
            param.setDocStatus("APPED");
        } else {
            param.setDoc("STKTRO");
            param.setDocType("TRO");
            param.setDocStatus("APPED");
        }
        param.setSourceId(RandomUtil.randomLong());
        param.setSourceNo(IdUtil.randomUUID());
        param.setOuCode(ouCode);
        param.setObjectCode(custCode);
        param.setDocAmount(BigDecimal.ONE);
        param.setRebateAmount(null);
        param.setPaymentRuleConfigDtlIds(null);
        return this.paymentRuleConfigService.queryAccountAmount(param);
    }

    private RecOrderSaveParam getRecOrderSaveParam(WeChatPayRecOrderRpcParam weChatPayRecOrderRpcParam, Map<String, Long> docMap, Map<Long, BigDecimal> receiptAmtMap) {
        RecOrderSaveParam param = new RecOrderSaveParam();
        String sourceNo = weChatPayRecOrderRpcParam.getSourceNo();
        param.setSourceNo(sourceNo);
        param.setRecTypeCode("SKD01_SYS");
        param.setRecTypeName("\u6807\u51c6\u6536\u6b3e\u5355");
        param.setRecTypeId(this.getRecTypeIdByCode("SKD01_SYS"));
        param.setReDate(weChatPayRecOrderRpcParam.getPayDateTime());
        param.setCurrCode(weChatPayRecOrderRpcParam.getCurrCode());
        param.setCurrName(weChatPayRecOrderRpcParam.getCurrName());
        if (sourceNo.startsWith("PO")) {
            param.setCreateMode("PO");
            List codeBatch = this.purPoProvider.findCodeBatch(Arrays.asList(sourceNo));
            if (CollUtil.isEmpty((Collection)codeBatch)) {
                throw new com.elitescloud.boot.exception.BusinessException("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            PurPoDTO purPoDTO = (PurPoDTO)codeBatch.get(0);
            if (purPoDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            docMap.put("docId", purPoDTO.getId());
            PurPoDTO data = (PurPoDTO)this.purPoProvider.findPurPoOne(purPoDTO.getId()).getData();
            if (data != null) {
                receiptAmtMap.put(purPoDTO.getId(), data.getPurPoDDTOList().stream().map(PurPoDDTO::getLastPathSaleAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            log.info("\u91c7\u8d2d\u5355\u8be6\u60c5:{},\u91c7\u8d2d\u8ba2\u5355,docId:{},receiptAmtMap:{}", new Object[]{JSONUtil.toJsonStr((Object)purPoDTO), purPoDTO.getId(), JSONUtil.toJsonStr(receiptAmtMap)});
            InvWhRpcSimpleDTO whRpcSimpleDTO = (InvWhRpcSimpleDTO)((List)this.invWhProvider.querySimple(List.of(purPoDTO.getWhId())).getData()).get(0);
            ApiResult orgStoreByWhCode = this.orgStoreRpcService.getOrgStoreByWhCode(whRpcSimpleDTO.getWhCode());
            if (orgStoreByWhCode.isSuccess() && orgStoreByWhCode.getData() == null) {
                throw new com.elitescloud.boot.exception.BusinessException("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5173\u8054\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5173\u8054\u95e8\u5e97\u4e0d\u5b58\u5728");
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            SupportTransactionPathRpcParam rpcParam = new SupportTransactionPathRpcParam();
            rpcParam.setCompanyIdStart(purPoDTO.getOuId());
            rpcParam.setCompanyIdEnd(purPoDTO.getAcceptOuId());
            SupportTransactionPathRpcDTO pathCodeResult = (SupportTransactionPathRpcDTO)this.supportTransactionPathRpcService.queryByParam(rpcParam).getData();
            if (pathCodeResult == null) {
                log.info("\u91c7\u8d2d\u8ba2\u5355:{},\u672a\u83b7\u53d6\u5230\u7ed3\u7b97\u8def\u5f84\u4fe1\u606f:{}", (Object)purPoDTO.getDocNo(), (Object)JSONUtil.toJsonStr((Object)rpcParam));
                throw new com.elitescloud.boot.exception.BusinessException("\u91c7\u8d2d\u8ba2\u5355,\u672a\u83b7\u53d6\u5230\u7ed3\u7b97\u8def\u5f84\u4fe1\u606f");
            }
            log.info("\u83b7\u53d6\u5230\u7ed3\u7b97\u8def\u5f84\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)pathCodeResult));
            List detailList = pathCodeResult.getDetailList();
            int size = detailList.size();
            SupportTransactionPathDRpcDTO dto = (SupportTransactionPathDRpcDTO)detailList.get(size - 1);
            param.setOuCode(dto.getCompanyCodeStart());
            param.setOuId(dto.getCompanyIdStart());
            param.setOuName(dto.getCompanyNameStart());
            param.setCustCode(dto.getCustCodeEnd());
            param.setCustId(dto.getCustIdEnd());
            param.setCustName(dto.getCustNameEnd());
            param.setRecOuId(dto.getCompanyIdStart());
            param.setRecOuCode(dto.getCompanyCodeStart());
            param.setRecOuName(dto.getCompanyNameStart());
        } else {
            CompanyAndCustRpcDTO companyAndCustRpcDTO = this.invCompanyAndCustProvider.getFromCompanyAndToCustomer(sourceNo);
            param.setOuCode(companyAndCustRpcDTO.getOuCode());
            param.setOuId(companyAndCustRpcDTO.getOuId());
            param.setOuName(companyAndCustRpcDTO.getOuName());
            param.setCustCode(companyAndCustRpcDTO.getCustCode());
            param.setCustId(companyAndCustRpcDTO.getCustId());
            param.setCustName(companyAndCustRpcDTO.getCustName());
            param.setCreateMode("TRO");
            ApiResult byDocNo = this.invTroProvider.findByDocNo(sourceNo);
            if (!byDocNo.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            InvTroRpcDTO invTroRpcDTO = (InvTroRpcDTO)byDocNo.getData();
            log.info("\u8c03\u62e8\u5355\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)invTroRpcDTO));
            if (invTroRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            docMap.put("docId", invTroRpcDTO.getId());
            receiptAmtMap.put(invTroRpcDTO.getId(), invTroRpcDTO.getInvTrnDRpcDTOS().stream().map(InvTroDRpcDTO::getLastPathSaleAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
            log.info("\u8c03\u62e8\u5355,docId:{},receiptAmtMap:{}", (Object)invTroRpcDTO.getId(), (Object)JSONUtil.toJsonStr(receiptAmtMap));
            if (StrUtil.isBlank((CharSequence)invTroRpcDTO.getToWhCode())) {
                throw new com.elitescloud.boot.exception.BusinessException("\u8c03\u62e8\u5355\u6536\u8d27\u4ed3\u5e93\u4e0d\u5b58\u5728");
            }
            ApiResult orgStoreByWhCode = this.orgStoreRpcService.getOrgStoreByWhCode(invTroRpcDTO.getToWhCode());
            if (!orgStoreByWhCode.isSuccess()) {
                throw new com.elitescloud.boot.exception.BusinessException("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728,\u4ed3\u5e93\u7f16\u7801\u4e3a:" + invTroRpcDTO.getToWhCode());
            }
            OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)orgStoreByWhCode.getData();
            if (orgStoreBaseRpcDTO == null) {
                throw new com.elitescloud.boot.exception.BusinessException("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728,\u4ed3\u5e93\u7f16\u7801\u4e3a:" + invTroRpcDTO.getToWhCode());
            }
            param.setStoreCode(orgStoreBaseRpcDTO.getStoreCode());
            param.setStoreName(orgStoreBaseRpcDTO.getStoreName());
            param.setRecOuId(companyAndCustRpcDTO.getOuId());
            param.setRecOuCode(companyAndCustRpcDTO.getOuCode());
            param.setRecOuName(companyAndCustRpcDTO.getOuName());
        }
        param.setExchangeRate(BigDecimal.ONE);
        param.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        param.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        param.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        param.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        param.setReFlag(false);
        param.setInitFlag(false);
        param.setOrderState("COMPLETE");
        param.setRedState(false);
        param.setProposedStatus("DRAFT");
        RecOrderDtlSaveParam dtlSaveParam = new RecOrderDtlSaveParam();
        dtlSaveParam.setSourceNo(sourceNo);
        dtlSaveParam.setRecType("WQF");
        dtlSaveParam.setRecTypeName("\u5fae\u4f01\u4ed8");
        String storeCode = param.getStoreCode();
        List<OrgBankRpcDTO> bankByStoreCode = this.rmiOrgStoreRpcServiceService.findBankByStoreCode(storeCode);
        if (!bankByStoreCode.isEmpty()) {
            OrgBankRpcDTO orgBankRpcDTO = bankByStoreCode.get(0);
            dtlSaveParam.setEs16(orgBankRpcDTO.getCardNo());
            dtlSaveParam.setEs17(orgBankRpcDTO.getOpenBank());
        }
        Long ouId = param.getRecOuId();
        List<OrgOuBankRpcDTO> ouBankData = this.rmiOrgOuRpcServiceService.findOuBank(ouId);
        OrgOuBankRpcDTO bankRpcDTO = ouBankData.stream().filter(e -> "WQF".equals(e.getPayCollectMethod()) && "IN".equals(e.getAccType())).findFirst().orElseThrow(new com.elitescloud.boot.exception.BusinessException("\u6536\u6b3e\u516c\u53f8\u94f6\u884c\u4fe1\u606f\u65e0\u5fae\u4f01\u4ed8\u6536\u6b3e\u4fe1\u606f"));
        dtlSaveParam.setRecAccount(bankRpcDTO.getBankAcc());
        dtlSaveParam.setRecBank(bankRpcDTO.getHolderName());
        dtlSaveParam.setRecFlow(weChatPayRecOrderRpcParam.getFlowNo());
        dtlSaveParam.setTotalAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setTotalCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setRealRecCurAmt(weChatPayRecOrderRpcParam.getRealRecAmt());
        dtlSaveParam.setVerAmt(BigDecimal.ZERO);
        dtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
        dtlSaveParam.setUnVerAmt(param.getTotalAmt());
        param.setOrderDtlSaveParamList(Arrays.asList(dtlSaveParam));
        log.info("\u751f\u6210\u7684\u6536\u6b3e\u5355\u8be6\u60c5:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private void checkIfExist(String sourceNo) {
        List<RecOrderDO> bySourceNo = this.recOrderRepoProc.findBySourceNo(sourceNo);
        if (CollUtil.isNotEmpty(bySourceNo)) {
            throw new com.elitescloud.boot.exception.BusinessException("\u8be5\u6765\u6e90\u5355\u53f7\u5df2\u5b58\u5728\u5173\u8054\u7684\u6536\u6b3e\u5355,\u6765\u6e90\u5355\u53f7:" + sourceNo);
        }
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List payTypeVOList = (List)this.payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    private Long getRecTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List<RecTypeDTO> apTypeDTOS = this.recTypeDomainService.findAll();
        Optional<RecTypeDTO> first = apTypeDTOS.stream().filter(e -> e.getRecTypeCode().equals(code)).findFirst();
        return first.map(RecTypeDTO::getId).orElse(null);
    }

    private void sendWechatBoot(String docNo, String msg) {
        try {
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WECHAT_PAY");
            HashMap<String, String> contentTemplateParams = new HashMap<String, String>();
            contentTemplateParams.put("DOC_NO", docNo);
            contentTemplateParams.put("MSG", msg);
            dto.setContentReplaceMap(contentTemplateParams);
            this.sysMsgTemplateSendRpcService.msgTemplateSend(dto);
            log.debug("\u4f01\u5fae\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a" + LocalDateTime.now());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u544a\u8b66\u4fe1\u606f\u5931\u8d25\uff0c" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public RecOrderRpcServiceImpl(PayTypeService payTypeService, RecTypeDomainService recTypeDomainService, RecOrderDomainService recOrderDomainService, RecOrderRpcTwoService recOrderRpcTwoService, ApTypeService apTypeService, InvCompanyAndCustProvider invCompanyAndCustProvider, OrgStoreRpcService orgStoreRpcService, InvTroProvider invTroProvider, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, RmiOrgStoreRpcServiceService rmiOrgStoreRpcServiceService, RecOrderService recOrderService, TransactionTemplate transactionTemplate, RecOrderRepoProc recOrderRepoProc, RecOrderDtlRepoProc recOrderDtlRepoProc, PayOrderRepoProc payOrderRepoProc, PurSuppOutService purSuppOutService, RmiSaleRpcService rmiSaleRpcService, PayOrderService payOrderService, PaymentRuleConfigService paymentRuleConfigService, TroPayProvider troPayProvider, PoPayProvider poPayProvider, PurPoProvider purPoProvider, InvWhProvider invWhProvider, SupportTransactionPathRpcService supportTransactionPathRpcService, FinArRecVerApplyService finArRecVerApplyService, TaskExecutor taskExecutor) {
        this.payTypeService = payTypeService;
        this.recTypeDomainService = recTypeDomainService;
        this.recOrderDomainService = recOrderDomainService;
        this.recOrderRpcTwoService = recOrderRpcTwoService;
        this.apTypeService = apTypeService;
        this.invCompanyAndCustProvider = invCompanyAndCustProvider;
        this.orgStoreRpcService = orgStoreRpcService;
        this.invTroProvider = invTroProvider;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.rmiOrgStoreRpcServiceService = rmiOrgStoreRpcServiceService;
        this.recOrderService = recOrderService;
        this.transactionTemplate = transactionTemplate;
        this.recOrderRepoProc = recOrderRepoProc;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.payOrderRepoProc = payOrderRepoProc;
        this.purSuppOutService = purSuppOutService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.payOrderService = payOrderService;
        this.paymentRuleConfigService = paymentRuleConfigService;
        this.troPayProvider = troPayProvider;
        this.poPayProvider = poPayProvider;
        this.purPoProvider = purPoProvider;
        this.invWhProvider = invWhProvider;
        this.supportTransactionPathRpcService = supportTransactionPathRpcService;
        this.finArRecVerApplyService = finArRecVerApplyService;
        this.taskExecutor = taskExecutor;
    }
}

