/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flow;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.facade.param.flow.AccountFlowAccAmtParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowAccAmtVO;
import com.elitesland.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.fin.application.service.flow.AccountFlowTcService;
import com.elitesland.fin.common.UdcEnum;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountFlowTcServiceImpl
implements AccountFlowTcService {
    @Autowired
    private AccountFlowCommonService accountFlowCommonService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<AccountFlowParam> saveTc(List<AccountFlowParam> paramList) {
        this.distinguishDataSource(paramList);
        return paramList;
    }

    private void distinguishDataSource(List<AccountFlowParam> paramList) {
        Optional<String> paramOptional = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().findFirst();
        if (paramOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        String dataSource = paramOptional.get();
        if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD03.getValueCode())) {
            this.handleDataSource01(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TZD04.getValueCode())) {
            this.handleDataSource02(paramList);
        } else if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
            this.handleDataSource03(paramList);
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u6570\u636e\u6765\u6e90!");
        }
    }

    private void handleDataSource01(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("SUB").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)((Object)param));
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)((Object)param));
        });
    }

    private void handleDataSource02(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)((Object)param));
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)((Object)param));
        });
    }

    private void handleDataSource03(List<AccountFlowParam> paramList) {
        this.accountFlowCommonService.checkAdjustApprove(paramList);
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getSplitType()));
        List<AccountFlowParam> accountFlowTcTypeList = accountFlowListMap.get("ADJUST_APPROVE_FROM");
        List<AccountFlowParam> accountFlowTjTypeList = accountFlowListMap.get("ADJUST_APPROVE_TO");
        if (!CollectionUtils.isEmpty(accountFlowTcTypeList)) {
            accountFlowTcTypeList.forEach(param -> {
                AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
                AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("SUB").accOccHandleType("EQU").build();
                AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
                param.setAccAmt(calculateData.getAccAmt());
                param.setAccOccAmt(calculateData.getAccOccAmt());
                this.accountFlowCommonService.defaultAssignment((AccountFlowParam)((Object)param));
                this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)((Object)param));
            });
        }
        if (!CollectionUtils.isEmpty(accountFlowTjTypeList)) {
            this.handleDataSource04(accountFlowTjTypeList);
        }
    }

    private void handleDataSource04(List<AccountFlowParam> paramList) {
        paramList.forEach(param -> {
            AccountFlowAccAmtVO previousData = this.accountFlowCommonService.selectPreviousData(param.getAccCode());
            AccountFlowAccAmtParam accountFlowAccAmtParam = AccountFlowAccAmtParam.builder().amount(param.getAmount()).accAmt(previousData.getAccAmt()).accOccAmt(previousData.getAccOccAmt()).accHandleType("ADD").accOccHandleType("EQU").build();
            AccountFlowAccAmtVO calculateData = this.accountFlowCommonService.handleAccAmt(accountFlowAccAmtParam);
            param.setAccAmt(calculateData.getAccAmt());
            param.setAccOccAmt(calculateData.getAccOccAmt());
            this.accountFlowCommonService.defaultAssignment((AccountFlowParam)((Object)param));
            this.accountFlowCommonService.saveAccountAndFlow((AccountFlowParam)((Object)param));
        });
    }
}

