/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.workflow.recorder.RecOrderProcessService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.rpc.pur.PurSuppOutService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.BigDecimalUtil;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.dto.param.CustBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderProcessServiceImpl
implements RecOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderProcessServiceImpl.class);
    @Autowired
    @Lazy
    private PayOrderService payOrderService;
    private final PayTypeService payTypeService;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final PurSuppOutService purSuppOutService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;
    private final RecOrderDomainService recOrderDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasId(id);
        if (recOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)recOrderDO).set(recOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{recOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(recOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)recOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)recOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)recOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(recOrderDO.approvedTime, (Object)LocalDateTime.now()).set(recOrderDO.auditDate, (Object)LocalDateTime.now()).set(recOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)recOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        String custType2 = this.getCustType2(recOrderDTO);
        List<PayOrderDO> data = this.payOrderRepoProc.queryBySourceNo(recOrderDTO.getRecOrderNo());
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            if ("C".equals(custType2) && CollUtil.isEmpty(data) && !Objects.equals(recOrderDTO.getCreateMode(), "PAY")) {
                PayOrderSaveParam payOrderSaveParam = this.getPayOrderSaveParam(recOrderDTO, recOrderDtlDTOS);
                this.payOrderService.save(payOrderSaveParam);
            }
            log.info("\u6536\u6b3e\u5355\u5ba1\u6279\u901a\u8fc7\uff0c\u5f00\u59cb\u81ea\u52a8\u6838\u9500");
            this.finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
            if (this.isOutterCust(recOrderDTO)) {
                log.info("\u5916\u90e8\u5ba2\u6237,\u5ba1\u6279\u5b8c\u6210\u81ea\u52a8\u521b\u5efa\u8d26\u6237\u6d41\u6c34");
                this.recOrderDomainService.createFinFlow(recOrderDTO);
            }
            this.updateVerState(id);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT) && "C".equals(custType2) && CollUtil.isNotEmpty(data)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5df2\u7ecf\u751f\u6210\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5ba1\u6279");
        }
    }

    private boolean isOutterCust(RecOrderDTO recOrderDTO) {
        String inOutCust = recOrderDTO.getInOutCust();
        return "OUT".equals(inOutCust);
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code)) {
            return null;
        }
        List payTypeVOList = (List)this.payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    private PayOrderSaveParam getPayOrderSaveParam(RecOrderDTO recOrderDTO, List<RecOrderDtlDTO> recOrderDtlDTOS) {
        List<PayOrderDO> payOrderDOS;
        log.info("\u751f\u6210\u4ed8\u6b3e\u5355\u5165\u53c2:recOrderDTO:{},recOrderDtlDTOS:{}", (Object)JSONUtil.toJsonStr((Object)recOrderDTO), (Object)JSONUtil.toJsonStr(recOrderDtlDTOS));
        CustBaseRpcParam custBaseRpcParam = new CustBaseRpcParam();
        custBaseRpcParam.setCustCodeList(Arrays.asList(recOrderDTO.getCustCode()));
        List<CustBaseDTO> baseCustByParam = this.rmiSaleRpcService.findBaseCustByParam(custBaseRpcParam);
        if (CollUtil.isEmpty(baseCustByParam)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CustBaseDTO custBaseDTO = baseCustByParam.get(0);
        log.info("\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)custBaseDTO));
        String corBusinCode = custBaseDTO.getCorBusinCode();
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u7f16\u7801:{}", (Object)corBusinCode);
        if (StrUtil.isBlank((CharSequence)corBusinCode)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        List<OrgOuRpcSimpleDTO> baseOuByCodes = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(Arrays.asList(corBusinCode));
        if (CollUtil.isEmpty(baseOuByCodes)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = baseOuByCodes.get(0);
        log.info("\u5ba2\u6237\u5173\u8054\u516c\u53f8\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)orgOuRpcSimpleDTO));
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setOuCode2s(Arrays.asList(recOrderDTO.getOuCode()));
        List<PurSuppBaseRpcDTO> baseSuppByParam = this.purSuppOutService.findBaseSuppByParam(purSuppBaseRpcParam);
        if (CollUtil.isEmpty(baseSuppByParam)) {
            throw new BusinessException("\u6536\u6b3e\u5355\u516c\u53f8\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        PurSuppBaseRpcDTO purSuppBaseRpcDTO = baseSuppByParam.get(0);
        PayOrderSaveParam param = new PayOrderSaveParam();
        param.setInOutCust(purSuppBaseRpcDTO.getIoType());
        param.setCurrCode(recOrderDTO.getCurrCode());
        param.setCurrName(recOrderDTO.getCurrName());
        param.setOuId(orgOuRpcSimpleDTO.getId());
        param.setOuCode(orgOuRpcSimpleDTO.getOuCode());
        param.setOuName(orgOuRpcSimpleDTO.getOuName());
        param.setSuppId(purSuppBaseRpcDTO.getId());
        param.setSuppCode(purSuppBaseRpcDTO.getSuppCode());
        param.setSuppName(purSuppBaseRpcDTO.getSuppName());
        param.setSourceNo(recOrderDTO.getRecOrderNo());
        param.setPayTypeCode("AP");
        param.setPayTypeName("\u6807\u51c6\u4ed8\u6b3e");
        param.setPayTypeId(this.getApTypeIdByCode("AP"));
        param.setCreateMode("REC");
        param.setTotalAmt(recOrderDTO.getTotalAmt());
        param.setRealPayAmt(recOrderDTO.getRealRecAmt());
        param.setBuDate(recOrderDTO.getReDate());
        param.setInitFlag(recOrderDTO.getInitFlag());
        param.setTotalCurAmt(recOrderDTO.getTotalCurAmt());
        param.setRealPayCurAmt(recOrderDTO.getRealRecCurAmt());
        param.setApDate(recOrderDTO.getReDate());
        param.setApFlag(recOrderDTO.getReFlag());
        param.setExchangeRate(recOrderDTO.getExchangeRate());
        param.setOrderState("COMPLETE");
        param.setRedState(recOrderDTO.getRedState());
        String redSourceNo = recOrderDTO.getRedSourceNo();
        if (StrUtil.isNotBlank((CharSequence)redSourceNo) && CollUtil.isNotEmpty(payOrderDOS = this.payOrderRepoProc.queryBySourceNo(redSourceNo))) {
            PayOrderDO payOrderDO = payOrderDOS.get(0);
            param.setRedSourceNo(payOrderDO.getPayOrderNo());
            param.setRedSourceId(payOrderDO.getId());
            param.setRedState(true);
        }
        Map<String, List<RecOrderDtlDTO>> groupedData = recOrderDtlDTOS.stream().collect(Collectors.groupingBy(e -> e.getRecAccount() + e.getEs16()));
        log.info("\u5206\u7ec4\u540e groupedData:{}", (Object)JSONUtil.toJsonStr(groupedData));
        param.setProposedStatus("DRAFT");
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = groupedData.entrySet().stream().map(entry -> {
            BigDecimal realRecAmtTotal = BigDecimal.ZERO;
            BigDecimal realRecCurAmtTotal = BigDecimal.ZERO;
            for (RecOrderDtlDTO recOrderDtlDTO : (List)entry.getValue()) {
                realRecAmtTotal = realRecAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecAmt()));
                realRecCurAmtTotal = realRecCurAmtTotal.add(BigDecimalUtil.getUnify(recOrderDtlDTO.getRealRecCurAmt()));
            }
            RecOrderDtlDTO payorderDtlDto = (RecOrderDtlDTO)((List)entry.getValue()).get(0);
            BigDecimal totalAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalAmt() != null).map(RecOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmt = ((List)entry.getValue()).stream().filter(e -> e.getTotalCurAmt() != null).map(RecOrderDtlDTO::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            PayOrderDtlSaveParam payOrderDtlSaveParam = new PayOrderDtlSaveParam();
            payOrderDtlSaveParam.setSourceLine(payorderDtlDto.getSourceLine());
            payOrderDtlSaveParam.setSourceLineId(payorderDtlDto.getSourceLineId());
            payOrderDtlSaveParam.setPayType(payorderDtlDto.getRecType());
            payOrderDtlSaveParam.setPayBank(payorderDtlDto.getEs17());
            payOrderDtlSaveParam.setPayAccount(payorderDtlDto.getEs16());
            payOrderDtlSaveParam.setTotalAmt(totalAmt);
            payOrderDtlSaveParam.setTotalCurAmt(totalCurAmt);
            payOrderDtlSaveParam.setRecBank(payorderDtlDto.getRecBank());
            payOrderDtlSaveParam.setRecAccount(payorderDtlDto.getRecAccount());
            payOrderDtlSaveParam.setRealPayAmt(realRecAmtTotal);
            payOrderDtlSaveParam.setRealPayCurAmt(realRecCurAmtTotal);
            payOrderDtlSaveParam.setVerAmt(BigDecimal.ZERO);
            payOrderDtlSaveParam.setApplyVerAmTing(BigDecimal.ZERO);
            payOrderDtlSaveParam.setUnVerAmt(param.getTotalAmt());
            return payOrderDtlSaveParam;
        }).collect(Collectors.toList());
        param.setPayOrderDtlSaveParams(payOrderDtlSaveParams);
        log.info("\u751f\u6210\u4ed8\u6b3e\u5355\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)param));
        return param;
    }

    private String getCustType2(RecOrderDTO recOrderDTO) {
        List<CrmCustBaseDTO> custBaseInfoList = this.rmiSaleRpcService.getCustBaseInfo(Collections.singletonList(recOrderDTO.getCustCode()));
        if (CollUtil.isEmpty(custBaseInfoList)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801" + recOrderDTO.getCustCode() + "\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CrmCustBaseDTO crmCustBaseDTO = custBaseInfoList.get(0);
        return crmCustBaseDTO.getCustType2();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        RecOrderDTO recOrderDTO = this.recOrderRepoProc.queryById(businessId);
        if (recOrderDTO == null) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(recOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    private void updateVerState(Long id) {
        RecOrderDTO newRecOrderDTO = this.recOrderRepoProc.queryById(id);
        List<RecOrderDtlDTO> newRecOrderDtlDTOList = this.recOrderDtlRepoProc.queryByMasId(id);
        BigDecimal verAmtSum = BigDecimal.ZERO;
        BigDecimal verAmtingSum = BigDecimal.ZERO;
        BigDecimal unVerAmtSum = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(newRecOrderDtlDTOList)) {
            for (RecOrderDtlDTO recOrderDtlDTO : newRecOrderDtlDTOList) {
                if (null != recOrderDtlDTO.getVerAmt()) {
                    verAmtSum = verAmtSum.add(recOrderDtlDTO.getVerAmt());
                }
                if (recOrderDtlDTO.getApplyVerAmTing() != null) {
                    verAmtingSum = verAmtingSum.add(recOrderDtlDTO.getApplyVerAmTing());
                }
                if (recOrderDtlDTO.getUnVerAmt() == null) continue;
                unVerAmtSum = unVerAmtSum.add(recOrderDtlDTO.getUnVerAmt());
            }
        }
        String verState = null;
        verState = unVerAmtSum.add(verAmtingSum).compareTo(BigDecimal.ZERO) == 0 ? UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode() : (Objects.nonNull(newRecOrderDTO.getTotalAmt()) && unVerAmtSum.add(verAmtingSum).compareTo(newRecOrderDTO.getTotalAmt()) == 0 ? UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode() : UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)verState)) {
            this.recOrderRepoProc.updateVerState(verState, id);
        }
    }

    public RecOrderProcessServiceImpl(PayTypeService payTypeService, PayOrderRepoProc payOrderRepoProc, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, PurSuppOutService purSuppOutService, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, RecOrderRepoProc recOrderRepoProc, RecOrderDtlRepoProc recOrderDtlRepoProc, JPAQueryFactory jpaQueryFactory, FinArRecVerApplyService finArRecVerApplyService, RecOrderDomainService recOrderDomainService) {
        this.payTypeService = payTypeService;
        this.payOrderRepoProc = payOrderRepoProc;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.purSuppOutService = purSuppOutService;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.recOrderRepoProc = recOrderRepoProc;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.finArRecVerApplyService = finArRecVerApplyService;
        this.recOrderDomainService = recOrderDomainService;
    }
}

