/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.param.account.AccountStorageQueryReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;
import com.elitesland.fin.application.service.account.AccountStorageService;
import com.elitesland.fin.application.service.unionpay.UnionPayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u50a8\u503ctims"})
@RestController
@RequestMapping(value={"/accountStorage"}, produces={"application/json"})
public class AccountStorageController {
    private static final Logger log = LoggerFactory.getLogger(AccountStorageController.class);
    private final AccountStorageService accountStorageService;
    private final UnionPayService unionPayService;

    @ApiOperation(value="\u8d26\u6237\u50a8\u503c\u5206\u9875")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<AccountStorageVO>> page(@RequestBody AccountStorageParam params) {
        log.info("[FIN-ACCOUNT-STORAGE] page  param ={}", (Object)params);
        PagingVO<AccountStorageVO> list = this.accountStorageService.page(params);
        return ApiResult.ok(list);
    }

    @ApiOperation(value="\u8d26\u6237\u50a8\u503c\u5217\u8868")
    @PostMapping(value={"/list"})
    public ApiResult<List<AccountStorageVO>> list(@RequestBody AccountStorageParam params) {
        log.info("[FIN-ACCOUNT-STORAGE] list  param ={}", (Object)params);
        List<AccountStorageVO> list = this.accountStorageService.list(params);
        return ApiResult.ok(list);
    }

    @ApiOperation(value="\u50a8\u503c\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/single/{id}"})
    public ApiResult<AccountStorageVO> single(@PathVariable(value="id") Long id) {
        log.info("[FIN-ACCOUNT-STORAGE] list  param ={}", (Object)id);
        AccountStorageVO vo = this.accountStorageService.single(id);
        return ApiResult.ok((Object)((Object)vo));
    }

    @ApiOperation(value="\u8d26\u6237\u50a8\u503c\u65b0\u589e")
    @PostMapping(value={"/save"})
    public ApiResult<AccountStorageVO> save(@RequestBody AccountStorageSaveParam saveParams) {
        log.info("[FIN-ACCOUNT-STORAGE] save param ={}", (Object)saveParams);
        if (ObjectUtils.isEmpty((Object)saveParams.getRemitterAmt())) {
            log.warn("\u8d26\u6237\u50a8\u503c\u91d1\u989d\u6709\u8bef:{}", (Object)saveParams.getRemitterAmt());
            return ApiResult.fail((String)"\u8d26\u6237\u50a8\u503c\u91d1\u989d\u6709\u8bef");
        }
        AccountStorageVO vo = this.accountStorageService.save(saveParams);
        return ApiResult.ok((Object)((Object)vo));
    }

    @ApiOperation(value="\u4ea4\u6613\u9000\u6b3e\u9884\u7559\u63a5\u53e3")
    @PostMapping(value={"/followPay"})
    public ApiResult<Void> followPay(@RequestBody AccountStorageFollowReq followReq) {
        log.info("[FIN-ACCOUNT-STORAGE] followPay  param ={}", (Object)followReq);
        this.accountStorageService.followPay(followReq);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u4ea4\u6613\u72b6\u6001\u67e5\u8be2\u9884\u7559\u63a5\u53e3")
    @GetMapping(value={"/queryPay"})
    public ApiResult<Void> queryPay(AccountStorageQueryReq req) {
        log.info("[FIN-ACCOUNT-STORAGE] queryPay  param ={}", (Object)req);
        this.unionPayService.queryPay(req);
        return ApiResult.ok();
    }

    public AccountStorageController(AccountStorageService accountStorageService, UnionPayService unionPayService) {
        this.accountStorageService = accountStorageService;
        this.unionPayService = unionPayService;
    }
}

