/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.expense.ExpenseCalService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobHandler {
    private static final Logger log = LoggerFactory.getLogger(JobHandler.class);
    private final LimitAdjustOrderService limitAdjustOrderService;
    private final InvoiceAwaitService invoiceAwaitService;
    private final CreditAccountService creditAccountService;
    private final AccountService accountService;
    private final FinAccountEngineService finAccountEngineService;
    private final ArOrderService arOrderService;
    private final TenantClientProvider tenantClientProvider;
    private final JournalGenerateService journalGenerateService;
    private final ApArOrderService apArOrderService;
    private final CreditAccountAutoRepaymentService creditAccountAutoRepaymentService;
    private final ExpenseCalService expenseCalService;

    @XxlJob(value="expireLimitAdjustOrder")
    public ReturnT<String> expireLimitAdjustOrder(String param) {
        try {
            this.limitAdjustOrderService.expireLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="activeLimitAdjustOrder")
    public ReturnT<String> activeLimitAdjustOrder(String param) {
        try {
            log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
            this.limitAdjustOrderService.activeLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="invoiceAwaitOrder")
    public ReturnT<String> invoiceAwaitOrder(String param) {
        try {
            this.invoiceAwaitService.invoiceAwaitOrder(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="invoiceAwaitOrderBySalDo")
    public ReturnT<String> invoiceAwaitOrderBySalDo(String param) {
        try {
            XxlJobLogger.log((String)"\u9500\u552e\u53d1\u8d27\u5355/\u9500\u552e\u9000\u8d27\u6536\u8d27\u5355\u751f\u6210\u5f85\u5f00\u7533\u8bf7\u53d1\u7968\u5217\u8868\u5f00\u59cb", (Object[])new Object[0]);
            this.invoiceAwaitService.invoiceAwaitOrderBySalDo(param);
            XxlJobLogger.log((String)"\u9500\u552e\u53d1\u8d27\u5355/\u9500\u552e\u9000\u8d27\u6536\u8d27\u5355\u751f\u6210\u5f85\u5f00\u7533\u8bf7\u53d1\u7968\u5217\u8868\u5b8c\u6210", (Object[])new Object[0]);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="creditAccountSnapshot")
    public ReturnT<String> creditAccountSnapshot(String param) {
        XxlJobLogger.log((String)"creditAccountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.creditAccountService.creditAccountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="accountSnapshot")
    public ReturnT<String> accountSnapshot(String param) {
        XxlJobLogger.log((String)"accountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.accountService.accountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="accountJournalGenerate")
    public ReturnT<String> accountJournalGenerate(String param) {
        long tenantId = -1L;
        if (this.tenantClientProvider.getSessionTenant() != null) {
            tenantId = this.tenantClientProvider.getSessionTenant().getId();
        }
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c,\u79df\u6237id:{}", (Object[])new Object[]{tenantId});
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c,\u53c2\u6570:{}", (Object[])new Object[]{param});
        List engineIds = null;
        if (!StringUtils.isBlank((CharSequence)param)) {
            String[] paramary = param.split(",");
            engineIds = Arrays.stream(paramary).map(v -> Long.valueOf(v)).collect(Collectors.toList());
        }
        try {
            this.journalGenerateService.generateJournal(engineIds);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u7ed3\u675f", (Object[])new Object[0]);
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="autoCreateArOrder")
    public ReturnT<String> autoCreateArOrder(String param) {
        XxlJobLogger.log((String)"\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u5b9a\u65f6\u4efb\u52a1 \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.arOrderService.jobAutoCreate(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="logicInvIoCreateApArOrder")
    public ReturnT<String> logicInvIoCreateApArOrder(String param) {
        XxlJobLogger.log((String)"\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u5b9a\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e(\u5e94\u6536\u5355\u4e0e\u5e94\u4ed8\u5355)\u5b9a\u65f6\u4efb\u52a1 \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.apArOrderService.logicInvIoJobAutoCreateApArOrder(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u5b9a\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e(\u5e94\u6536\u5355\u4e0e\u5e94\u4ed8\u5355)\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="creditAccountAutoRepayment")
    public ReturnT<String> creditAccountAutoRepayment(String param) {
        XxlJobLogger.log((String)"\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5b9a\u65f6\u4efb\u52a1 \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.creditAccountAutoRepaymentService.creditAccountAutoRepayment(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    public JobHandler(LimitAdjustOrderService limitAdjustOrderService, InvoiceAwaitService invoiceAwaitService, CreditAccountService creditAccountService, AccountService accountService, FinAccountEngineService finAccountEngineService, ArOrderService arOrderService, TenantClientProvider tenantClientProvider, JournalGenerateService journalGenerateService, ApArOrderService apArOrderService, CreditAccountAutoRepaymentService creditAccountAutoRepaymentService, ExpenseCalService expenseCalService) {
        this.limitAdjustOrderService = limitAdjustOrderService;
        this.invoiceAwaitService = invoiceAwaitService;
        this.creditAccountService = creditAccountService;
        this.accountService = accountService;
        this.finAccountEngineService = finAccountEngineService;
        this.arOrderService = arOrderService;
        this.tenantClientProvider = tenantClientProvider;
        this.journalGenerateService = journalGenerateService;
        this.apArOrderService = apArOrderService;
        this.creditAccountAutoRepaymentService = creditAccountAutoRepaymentService;
        this.expenseCalService = expenseCalService;
    }
}

