/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.expense;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerDetailRespVO;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.entity.expense.ExpLedgerDO;
import com.elitesland.fin.entity.expense.QExpLedgerDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpLedgerRepoProc {
    private static final Logger log = LoggerFactory.getLogger(ExpLedgerRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final QExpLedgerDO qExpLedgerDO = QExpLedgerDO.expLedgerDO;

    public ExpLedgerDetailRespVO detail(Long id) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        return (ExpLedgerDetailRespVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExpLedgerDetailRespVO.class, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ouId, jpaQDo.ouCode, jpaQDo.ouName, jpaQDo.carrierType, jpaQDo.carrier, jpaQDo.brand, jpaQDo.custId, jpaQDo.custCode, jpaQDo.custName, jpaQDo.storeId, jpaQDo.storeCode, jpaQDo.storeName, jpaQDo.expTypeCode, jpaQDo.expTypeName, jpaQDo.docType, jpaQDo.sourceDocNo, jpaQDo.sourceDocNoDate, jpaQDo.amt, jpaQDo.netAmt, jpaQDo.taxAmt, jpaQDo.taxRate, jpaQDo.ruleName, jpaQDo.orderState, jpaQDo.calState, jpaQDo.calError, jpaQDo.finFlag, jpaQDo.finError})).from((EntityPath)jpaQDo)).where((Predicate)jpaQDo.id.eq((Object)id))).fetchOne();
    }

    public List<ExpLedgerDO> findBySourceNoList(List<String> sourceNoList) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)jpaQDo).where((Predicate)jpaQDo.sourceDocNo.in(sourceNoList))).fetch();
    }

    public PagingVO<ExpLedgerPageVO> searchPage(ExpLedgerQueryParam param) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExpLedgerPageVO.class, (Expression[])new Expression[]{jpaQDo.id, jpaQDo.ouCode, jpaQDo.ouName, jpaQDo.carrier, jpaQDo.carrierName, jpaQDo.brand, jpaQDo.brandName, jpaQDo.custCode, jpaQDo.custName, jpaQDo.storeCode, jpaQDo.storeName, jpaQDo.expTypeCode, jpaQDo.expTypeName, jpaQDo.docType, jpaQDo.docTypeName, jpaQDo.sourceDocNo, jpaQDo.sourceDocNoDate, jpaQDo.amt, jpaQDo.netAmt, jpaQDo.taxAmt, jpaQDo.taxRate, jpaQDo.ruleName, jpaQDo.orderState, jpaQDo.finFlag, jpaQDo.finError, jpaQDo.calError, jpaQDo.calState, jpaQDo.creator, jpaQDo.createTime})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private Predicate where(ExpLedgerQueryParam param) {
        QExpLedgerDO jpaQDo = QExpLedgerDO.expLedgerDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        if (StrUtil.isNotBlank((CharSequence)param.getOuCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.ouCode.eq((Object)param.getOuCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCarrier())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.carrier.eq((Object)param.getCarrier()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.custCode.eq((Object)param.getCustCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getExpTypeCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.expTypeCode.eq((Object)param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getStoreCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.storeCode.eq((Object)param.getStoreCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getDocType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.docType.eq((Object)param.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getSourceDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.sourceDocNo.eq((Object)param.getSourceDocNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCalState())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.calState.eq((Object)param.getCalState()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOrderState())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.orderState.eq((Object)param.getOrderState()));
        }
        if (param.getSourceDocNoDateStart() != null && param.getSourceDocNoDateEnd() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.sourceDocNoDate.between((Comparable)param.getSourceDocNoDateStart(), (Comparable)param.getSourceDocNoDateEnd()));
        }
        return predicate;
    }

    public List<ExpLedgerPageVO> selectListByParam(ExpLedgerQueryParam param) {
        List<Predicate> where = this.expLedgerWhere(param);
        JPAQuery query = (JPAQuery)this.select(ExpLedgerPageVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> expLedgerWhere(ExpLedgerQueryParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)param.getOuCode())) {
            predicates.add((Predicate)this.qExpLedgerDO.ouCode.eq((Object)param.getOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCarrier())) {
            predicates.add((Predicate)this.qExpLedgerDO.carrier.eq((Object)param.getCarrier()));
        }
        if (param.getSourceDocNoDateStart() != null && param.getSourceDocNoDateEnd() != null) {
            predicates.add((Predicate)this.qExpLedgerDO.sourceDocNoDate.between((Comparable)param.getSourceDocNoDateStart(), (Comparable)param.getSourceDocNoDateEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getExpTypeCode())) {
            predicates.add((Predicate)this.qExpLedgerDO.expTypeCode.eq((Object)param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOrderState())) {
            predicates.add((Predicate)this.qExpLedgerDO.orderState.eq((Object)param.getOrderState()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getFinFlag())) {
            predicates.add((Predicate)this.qExpLedgerDO.finFlag.eq((Object)param.getFinFlag()));
        }
        if (Objects.nonNull(param.getNotGenerateFinFlag()) && param.getNotGenerateFinFlag().booleanValue()) {
            predicates.add((Predicate)this.qExpLedgerDO.finFlag.eq((Object)"0").or((Predicate)this.qExpLedgerDO.finFlag.isNull()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qExpLedgerDO.id, this.qExpLedgerDO.ouCode, this.qExpLedgerDO.ouName, this.qExpLedgerDO.carrier, this.qExpLedgerDO.carrierName, this.qExpLedgerDO.brand, this.qExpLedgerDO.brandName, this.qExpLedgerDO.custCode, this.qExpLedgerDO.custName, this.qExpLedgerDO.storeCode, this.qExpLedgerDO.storeName, this.qExpLedgerDO.expTypeCode, this.qExpLedgerDO.expTypeName, this.qExpLedgerDO.docType, this.qExpLedgerDO.docTypeName, this.qExpLedgerDO.sourceDocNo, this.qExpLedgerDO.sourceDocNoDate, this.qExpLedgerDO.amt, this.qExpLedgerDO.netAmt, this.qExpLedgerDO.taxAmt, this.qExpLedgerDO.taxRate, this.qExpLedgerDO.ruleName, this.qExpLedgerDO.orderState, this.qExpLedgerDO.finFlag, this.qExpLedgerDO.finError, this.qExpLedgerDO.calError, this.qExpLedgerDO.calState, this.qExpLedgerDO.remark, this.qExpLedgerDO.createTime, this.qExpLedgerDO.createUserId, this.qExpLedgerDO.creator, this.qExpLedgerDO.modifyTime, this.qExpLedgerDO.modifyUserId, this.qExpLedgerDO.updater, this.qExpLedgerDO.tenantId, this.qExpLedgerDO.deleteFlag})).from((EntityPath)this.qExpLedgerDO);
    }

    public void updateFinFlagByIds(List<Long> ids, String finFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qExpLedgerDO).set((Path)this.qExpLedgerDO.finFlag, (Object)finFlag).where(new Predicate[]{this.qExpLedgerDO.id.in(ids)}).execute();
    }

    public void updateFinFlagBySourceDocNos(List<String> sourceDocNos, String finFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qExpLedgerDO).set((Path)this.qExpLedgerDO.finFlag, (Object)finFlag).where(new Predicate[]{this.qExpLedgerDO.sourceDocNo.in(sourceDocNos)}).execute();
    }

    public void deleteBySourceNoList(List<String> sourceDocNos) {
        this.jpaQueryFactory.update((EntityPath)this.qExpLedgerDO).set(this.qExpLedgerDO.deleteFlag, (Object)1).where(new Predicate[]{this.qExpLedgerDO.sourceDocNo.in(sourceDocNos)}).execute();
    }

    public ExpLedgerRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

