package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 单据核销请求参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@Builder
public class FinApPayVerificationDTO implements Serializable {

    private static final long serialVersionUID = -313962750746986775L;

    @ApiModelProperty("外部应收单单号")
    private String apOutNo;

    @ApiModelProperty("外部应收单明细ID")
    private String apDId;

    @ApiModelProperty("外部收款单单号")
    private String payOutNo;

    @ApiModelProperty("外部应收单明细ID")
    private String payDId;

    @ApiModelProperty("应收客户编码")
    private String apCustCode;

    @ApiModelProperty("收款客户编码")
    private String paySuppCode;

    @ApiModelProperty("应收余额")
    private BigDecimal apAmt;

    @ApiModelProperty("收款余额")
    private BigDecimal payAmt;

    @ApiModelProperty("取消核销时，必填")
    private String batchNo;

    @ApiModelProperty("核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("核销类型 1:核销 2:取消核销 3:红蓝对冲")
    private String verType;

    @ApiModelProperty("处理人")
    private String creator;

    static public class VerType {
        // 核销
        public static final String APPROVE = "1";
        // 取消核销
        public static final String CANCEL = "2";
        // 红蓝对冲
        public static final String HEDGE = "3";
    }
}
