package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "账套")
public class FinSetOfBookParam extends BaseModelParam {

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("本位币")
    private String currCode;

    @ApiModelProperty("本位币名称")
    private String currName;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("账套明细")
    private List<FinSetOfBookLineParam> dimenDetailList;

    @ApiModelProperty("账套公司")
    private List<FinSetOfBookOuParam> ouDetailList;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

}
