package com.elitesland.fin.application.facade.param.arorder;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.arorder
 * @date 2022/4/12 17:29
 */
@Data
public class ArOrderDtlSaveParam implements Serializable {

    private static final long serialVersionUID = -8119774515716084630L;
    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "总单ID")
    private Long masId;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemType;

    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    @ApiModelProperty(value = "小类名称")
    private String smallCateName;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "计量单位名称")
    private String uomName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "部门编码")
    private String buCode;

    @ApiModelProperty(value = "部门ID")
    private Long buId;

    @ApiModelProperty(value = "部门名称")
    private String buName;

    @ApiModelProperty(value = "费用类型")
    private String expensesType;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("发货单号")
    private String es11;

    @ApiModelProperty("发货单明细ID（开票申请单）")
    private Long es12;

    @ApiModelProperty("订单客户")
    private String es13;

    @ApiModelProperty("客户编码(子客户)")
    private String es14;

    @ApiModelProperty("未税单价")
    private BigDecimal es15;

    @ApiModelProperty("税码")
    private String es16;

    @ApiModelProperty("发票号")
    private String es17;

    @ApiModelProperty("发票类型")
    private String es18;

    @ApiModelProperty("收款协议")
    private String es19;

    @ApiModelProperty("业务员编码")
    private String es20;

    @ApiModelProperty("币种")
    private String es21;

    @ApiModelProperty("汇率")
    private BigDecimal es22;

    @ApiModelProperty("起算日期")
    private LocalDateTime es23;

    @ApiModelProperty("到期付款日")
    private LocalDateTime es24;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;
    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;
}
