package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class PaymentOrderParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 992404276422799501L;
    @ApiModelProperty("主表id")
    private Long id;
    @ApiModelProperty("付款单号")
    private String payOrderNo;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("供应商编码")
    private String suppCode;
    //门店编码
    @ApiModelProperty("门店编码")
    private String shopCode;
    //门店名称
    @ApiModelProperty("门店名称")
    private String shopName;
    @ApiModelProperty("付款单类型代码")
    @SysCode(sys = "yst-fin", mod = "PAYORDER_TYPE")
    private String payTypeCode;
    private String payTypeCodeName;
    private LocalDateTime apDateStart;
    private LocalDateTime apDateEnd;
    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "PAYORDER_STATE")
    private String orderState;
    private String orderStateName;
    @ApiModelProperty("创建人")
    private String creator;
}
