package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.fin.application.service.excel.entity.AdjustExportEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_ADJUST_EXPORT;

@Service
@AllArgsConstructor
public class AdjustExportUsingParamServiceImpl implements DataExport<AdjustExportEntity, AdjustOrderPageParam> {
    private final AdjustOrderService adjustOrderService;
    @Override
    public String getTmplCode() {
        return FIN_ADJUST_EXPORT;
    }
    
    @Override
    public PagingVO<AdjustExportEntity> executeExport(AdjustOrderPageParam param){
        PagingVO<AdjustOrderVO> page = adjustOrderService.page(param);
        if(page.isNotEmpty()) {
            List<AdjustOrderVO> records = page.getRecords();
            List<AdjustExportEntity> adjustExportEntities = ExcelConvertUtils.convertLoosely(records, AdjustExportEntity.class);
            return new PagingVO<>(page.getTotal(), adjustExportEntities);
        }
        return new PagingVO<>(0, List.of());
    }
}
