package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.application.service.excel.ExportConstants;
import com.elitesland.fin.application.service.excel.entity.AdjustToExportEntity;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class DefaultAdjustToExportServiceImpl implements DataExport<AdjustToExportEntity, AdjustToOrderParam> {
    private final AdjustToOrderService adjustToOrderService;
    private final FlexFieldUtilService flexFieldUtilService;
    @Override
    public String getTmplCode() {
        return ExportConstants.FIN_ADJUST_TO_EXPORT_DEFAULT_IMPL;
    }
    @Override
    public PagingVO<AdjustToExportEntity> executeExport(AdjustToOrderParam queryParam) {
        PagingVO<AdjustToOrderVO> page = adjustToOrderService.page(queryParam);
        
        if (!page.isEmpty()) {
            flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.ADJUST_ORDER_TO,page.getRecords());
            return new PagingVO<>(
                            page.getTotal(),
                            ExcelConvertUtils.convertLoosely(page.getRecords(), AdjustToExportEntity.class)
                    );
        }
        
        return new PagingVO<>(0, List.of());
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
