package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;

import static com.elitesland.fin.application.service.excel.ExportConstants.DISABLE;

@Service
@AllArgsConstructor
public class DefaultArExportServiceImpl implements DataExport<ArExportEntity, ArOrderPageParam> {
    private final ArOrderDomainService arOrderDomainService;
    private final UdcProvider udcProvider;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    @Override
    public String getTmplCode() {
        return DISABLE;
    }
    @Override
    public PagingVO<ArExportEntity> executeExport(ArOrderPageParam queryParam) {
        PagingVO<ArExportEntity> arExportEntityPagingVO = arOrderDomainService.exportDefault(queryParam);
        if (arExportEntityPagingVO.isEmpty()) {
            return arExportEntityPagingVO;
        }
        var arDocClsMap = udcProvider.getValueMapByUdcCode("yst-fin", "AR_DOC_CLS");
        var applyStatusMap = udcProvider.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        var verifyStatusMap = udcProvider.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        var settlementTypeMap = udcProvider.getValueMapByUdcCode("yst-fin", "SETTLEMENT_TYPE");
        var proposedStatusMap = udcProvider.getValueMapByUdcCode("yst-fin", "DOC_PROPOSED_STATUS");
        var expensesTypeMap = udcProvider.getValueMapByUdcCode("yst-fin", "EXPENSES_TYPE");
        ExcelConverterManager.refresh();
        var totalCountMap = new HashMap<Long, BigDecimal>();
        for (ArExportEntity record : arExportEntityPagingVO.getRecords()) {
            Long id = record.getId();
            if(totalCountMap.containsKey(id)) {
                record.setTotalCount(totalCountMap.get(id));
            } else {
                BigDecimal totalCount = arOrderDtlRepoProc.countByMasId(id).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                totalCountMap.put(id, totalCount);
                record.setTotalCount(totalCount);
            }
            ExcelConvertUtils.convertSelfLoosely(record);
            record.setOrderStateName(applyStatusMap.get(record.getOrderState()));
            record.setExpensesTypeName(expensesTypeMap.get(record.getExpensesType()));
            record.setVerStateName(verifyStatusMap.get(record.getVerState()));
            record.setSettlementTypeName(settlementTypeMap.get(record.getSettlementType()));
            record.setProposedStatusName(proposedStatusMap.get(record.getProposedStatus()));
            record.setCreateModeName(arDocClsMap.get(record.getCreateMode()));
        }
        return arExportEntityPagingVO;
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
