package com.elitesland.fin.application.web.expense;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpLedgeCalParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerApproveParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerGenApArSaveParam;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerDetailRespVO;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.application.service.expense.ExpenseLedgerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: Mark
 * @Date: 2024/8/14 14:23
 * @Description:
 */
@RestController
@RequestMapping("/fin/expense/ledger")
@RequiredArgsConstructor
@Api(value = "费用台账管理", tags = {"费用台账管理"})
public class ExpenseLedgerController {
    private final ExpenseLedgerService expenseledgerService;

    @PostMapping("/page")
    @ApiOperation("费用台账管理-分页查询")
    public ApiResult<PagingVO<ExpLedgerPageVO>> page(@RequestBody ExpLedgerQueryParam param) {
        val ret = expenseledgerService.searchPage(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/detail/{id}")
    @ApiOperation("费用台账管理-详情")
    public ApiResult<ExpLedgerDetailRespVO> detail(@PathVariable("id") Long id) {
        val ret = expenseledgerService.detail(id);
        return ApiResult.ok(ret);
    }


    @PostMapping("approve")
    @ApiOperation("审批通过")
    public ApiResult<String> approve(@RequestBody ExpLedgerApproveParam param) {
        expenseledgerService.approve(param);
        return ApiResult.ok();
    }

    @PostMapping("reject")
    @ApiOperation("审批拒绝")
    public ApiResult<String> reject(@RequestBody ExpLedgerApproveParam param) {
        expenseledgerService.reject(param);
        return ApiResult.ok();
    }

    @PostMapping("reCal")
    @ApiOperation("重新计算")
    public ApiResult<String> reCal(@RequestBody ExpLedgeCalParam param) {
        expenseledgerService.reCal(param);
        return ApiResult.ok();
    }


    @PostMapping("/generate/apArOrder")
    @ApiOperation("生成应收应付")
    public ApiResult<Object> generateApArOrder(@RequestBody ExpLedgerGenApArSaveParam expLedgerGenApArSaveParam) {
        expenseledgerService.generateApArOrder(expLedgerGenApArSaveParam);
        return ApiResult.ok();
    }
}
