package com.elitesland.fin.common;

import com.google.common.collect.Lists;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/6/5
 */
public final class FinConstant {
    private FinConstant() {
    }

    public static final String UNDERLINE = "_";

    public static final String SYSTEM = "SYSTEM";


    //2位小数正则
    public static final String TWO_DECIMAL_REGULAR = "^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$";

    //转译后的加号
    public static final String TRANSLATION_PLUS = "\\+";

    //加号
    public static final String PLUS = "+";

    //换行
    public static final String WRAP = "\n";

    //YES
    public static final String YES = "是";

    //NO
    public static final String NO = "否";

    //TRUE
    public static final String TRUE = "true";

    //FALSE
    public static final String FALSE = "false";

    //付款单号对应规则
    public static final String FKD = "FKD";

    //应付单号对应规则
    public static final String YFD = "YFD";

    //核销方案编码对应规则
    public static final String HXFA = "HXFA";

    //收款单号对应规则
    public static final String SKD = "SKD";

    //应收单规则
    public static final String YSD = "YSD";

    //应付单单据
    public static final String AP = "AP";

    //付款单单据
    public static final String PAY = "PAY";

    //应收核销记录
    public static final String APVER = "APVER";

    //应收单单据
    public static final String AR = "AR";

    public static final String JXFP = "JXFP";

    // 销项发票
    public static final String XXFP = "XXFP";

    // 换开申请
    public static final String HKSQ = "HKSQ";

    //收款单单据
    public static final String REC = "REC";

    public static final String STRING = "String";

    public static final String BIGDECIMAL = "BigDecimal";

    public static final String LOCALDATETIME = "LocalDateTime";

    public static final String LONG = "Long";

    public static final String FIN = "yst-fin";

    public static final String CG_ORDER = "CG_ORDER";

    /**
     * 账户流水流水号的编号
     */
    public static final String ACCOUNT_FLOW_NO = "ACCOUNT_FLOW_NO";

    /**
     * 账户流水账户金额、账户占用金额处理类型-相加
     */
    public static final String ACC_HANDLE_TYPE_ADD = "ADD";
    /**
     * 账户流水账户金额、账户占用金额处理类型-相减
     */
    public static final String ACC_HANDLE_TYPE_SUB = "SUB";
    /**
     * 账户流水账户金额、账户占用金额处理类型-相同
     */
    public static final String ACC_HANDLE_TYPE_EQU = "EQU";
    /**
     * 账户流水账户金额、账户占用金额处理类型-值为空
     */
    public static final String ACC_HANDLE_TYPE_EMP = "EMP";

    public static final String TIME_SUFFIX = " 00:00:00";

    //判断时间类型长度
    public static final Integer EXCEL_TIME = 10;
    //充值单类型
    public static final String BZJ0001 = "BZJ0001";
    public static final String BZJ0002 = "BZJ0002";
    public static final String BZJ0003 = "BZJ0003";
    public static final String BZJ0004 = "BZJ0004";
    public static final String BZJ0005 = "BZJ0005";
    public static final String BZJ0006 = "BZJ0006";
    public static final String BZJ0007 = "BZJ0007";
    public static final String BZJ0008 = "BZJ0008";
    public static final String ZC0001 = "ZC0001";
    public static final String PJ0001 = "PJ0001";
    public static final String FJ0001 = "FJ0001";
    public static final String RBZJ0001 = "RBZJ0001";
    public static final String RBZJ0002 = "RBZJ0002";
    public static final String RBZJ0003 = "RBZJ0003";
    public static final String RBZJ0004 = "RBZJ0004";
    //充值类型
    public static final String ZCCZ = "ZCCZ";
    public static final String PJCZ = "PJCZ";
    public static final String FJBCZ = "FJBCZ";
    public static final String ZXBZJ = "ZXBZJ";
    public static final String DCBZJ = "DCBZJ";
    public static final String DZPBZJ = "DZPBZJ";
    public static final String XPBZJ = "XPBZJ";
    public static final String DCBZJT = "DCBZJT";
    public static final String ZXBZJT = "ZXBZJT";
    public static final String DZPBZJT = "DZPBZJT";
    public static final String XPBZJT = "XPBZJT";

    //流水生成标记
    public static final String REJECT = "REJECT";
    public static final String SUBMIT = "SUBMIT";
    public static final String APPROVED = "APPROVED";
    /**
     * 英文横线分隔符号
     */
    public static final String LINE_SPLIT = "-";
    /**
     * 分割后的数组长度
     */
    public static final int SPLIT_ARRAY_LENGTH = 2;
    /**
     * 数组下标值
     */
    public static final int ARRAY_INDEX_0 = 0;
    public static final int ARRAY_INDEX_1 = 1;
    public static final int ARRAY_INDEX_2 = 2;
    /**
     * 年月无日时：默认的月初第一天
     */
    public static final int FIRST_DAY_OF_MONTH = 1;

    /**
     * 账户流水的拆分类型：调剂单审核通过-从账户
     */
    public static final String SPLIT_TYPE_ADJUST_APPROVE_FROM = "ADJUST_APPROVE_FROM";
    /**
     * 账户流水的拆分类型：调剂单审核通过-至账户
     */
    public static final String SPLIT_TYPE_ADJUST_APPROVE_TO = "ADJUST_APPROVE_TO";
    /**
     * 账户流水账户进出方式-相加
     */
    public static final String ACC_IO_TYPE_ADD = "ADD";
    /**
     * 账户流水账户进出方式-相减
     */
    public static final String ACC_IO_TYPE_SUB = "SUB";
    /**
     * 账户流水账户进出方式-无
     */
    public static final String ACC_IO_TYPE_NO = "NO";
    /**
     * 账户流水账户进出方式-无-相加
     */
    public static final String ACC_IO_TYPE_NO_ADD = "NO_ADD";
    /**
     * 账户流水账户进出方式-无-相减
     */
    public static final String ACC_IO_TYPE_NO_SUB = "NO_SUB";

    /**
     * 账户流水生单类型-调剂单自动生单时
     */
    public static final String BIRTH_ORDER_TYPE_ADJUST_AUTO = "ADJUST_AUTO";

    public static final String PERCENTAGE = "%";


    public static final String ZT_TO_NC_SALINV = "zt_to_nc_salinv";

    // 对账单开票中状态
    public static final String INV_STATE_INVING = "INVING";

    /**
     * 发生金额为增加的交易类型编码的集合
     */
    public static final List<String> ADD_TRANSACTION_TYPE = new ArrayList<String>();

    /**
     * 发生金额为扣减的交易类型编码的集合
     */
    public static final List<String> SUB_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_FHKJ.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJKK.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHHC.getValueCode()
    );

    /**
     * 发生金额为无-增加的交易类型编码的集合
     */
    public static final List<String> NO_ADD_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_DDZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_CXFHZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TZDZY.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode()
    );

    /**
     * 发生金额为无-扣减的交易类型编码的集合
     */
    public static final List<String> NO_SUB_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.FIN_TRANSACTION_TYPE_DDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_BZJSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TZDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode(),
            UdcEnum.FIN_TRANSACTION_TYPE_FHSFCH.getValueCode()

    );


    static {
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_CXFHTH.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_THTK.getValueCode());
        ADD_TRANSACTION_TYPE.add(UdcEnum.FIN_TRANSACTION_TYPE_BZJTK.getValueCode());
    }

    /**
     * 账户进出方式为增加编码的集合
     */
    public static final List<String> ACC_IO_TYPE_ADD_LIST = Lists.newArrayList(
            ACC_IO_TYPE_ADD, ACC_IO_TYPE_NO_ADD
    );

    /**
     * 账户进出方式为扣减编码的集合
     */
    public static final List<String> ACC_IO_TYPE_SUB_LIST = Lists.newArrayList(
            ACC_IO_TYPE_SUB, ACC_IO_TYPE_NO_SUB
    );

    public static final String DRIVEN_NAME = "com.mysql.cj.jdbc.Driver";

    public static final String CONNECTION_NAME = "jdbc:mysql://%s:%s/%s";

    public static final String COLUMN_NAME ="COLUMN_NAME";

    public static final String TYPE_NAME ="TYPE_NAME";

    public static final String REMARKS ="REMARKS";

    public static final String POINT =".";

    public static final String COMMA =",";

    public static final String BETWEEN ="between";

    public static final String AND ="and";

    public static final String BLANK =" ";

    public static final String SELECT ="select";

    public static final String FROM ="from";

    public static final String WHERE ="where";

    public static final String INNER ="inner";

    public static final String JOIN ="join";

    public static final String ON ="on";

    public static final String MAS ="mas";

    public static final String ID ="id";

    public static final String EQUAL ="=";

    public static final String ONE ="1";

    public static final String OUT_PUT_ONE ="ACC_ENG_FAST_CODE_OUTPUT_ONE";

    public static final String OUT_PUT_TWO ="ACC_ENG_FAST_CODE_OUTPUT_TWO";

    public static final String OUT_PUT_THREE ="ACC_ENG_FAST_CODE_OUTPUT_THREE";

    public static final String SET ="set";

    public static final String INSERT ="insert";

    public static final String INTO ="into";

    public static final String LEFT_PARENTHESIS ="(";

    public static final String RIGHT_PARENTHESIS =")";

    public static final String VALUES ="values";
    public static final String EVENT_TABLE_CONDITION_CATEGORY_DATA_SELECT="DATA_SELECT";
    public static final String EVENT_TABLE_CONDITION_CATEGORY_PROPOSED="PROPOSED";

    public static final String WRITE_OFF_AMT_CON_GT="GT0";
    public static final String WRITE_OFF_AMT_CON_LT="LT0";
    public static final String WRITE_OFF_AMT_CON_NE="NE0";
    public static final String ASTERISK  = "*";
    public static final String DELETE_FLAG_WHERE  = "(delete_flag = 0 or delete_flag is null)";

    /**
     * 账户流水修复重算-账户类型编码的集合
     */
    public static final List<String> ACCOUNT_FLOW_REPAIR_ACCOUNT_TYPE = Lists.newArrayList(
            UdcEnum.ACCOUNT_TYPE_STORE.getValueCode(),
            UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode()
    );

    /**
     * 信用账户流水修复重算-账户类型编码的集合
     */
    public static final List<String> CREDIT_ACCOUNT_FLOW_REPAIR_ACCOUNT_TYPE = Lists.newArrayList(
            UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()
    );

    /**
     * 账户流水修复重算-交易类型编码的集合
     */
    public static final List<String> ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.IO_TYPE_I.getValueCode(),
            UdcEnum.IO_TYPE_O.getValueCode(),
            UdcEnum.IO_TYPE_T.getValueCode(),
            UdcEnum.IO_TYPE_R.getValueCode()
    );

    /**
     * 信用账户流水修复重算-交易类型编码的集合
     */
    public static final List<String> CREDIT_ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE = Lists.newArrayList(
            UdcEnum.CREDIT_IO_TYPE_I.getValueCode(),
            UdcEnum.CREDIT_IO_TYPE_O.getValueCode(),
            UdcEnum.CREDIT_IO_TYPE_T.getValueCode(),
            UdcEnum.CREDIT_IO_TYPE_R.getValueCode(),
            UdcEnum.CREDIT_IO_TYPE_U.getValueCode(),
            UdcEnum.CREDIT_IO_TYPE_D.getValueCode()
    );


    public static final String TWO_POINT = "0.00";

    /**
     * 财务单据: 应收单
     * 逻辑性销售出库且客户的内外部=内部客户
     */
    public static final String SCENE_CODE_SO_LOGIC_DELIVERY = "SO_LOGIC_DELIVERY";
    /**
     * 财务单据: 应付单
     * 逻辑性采购入库且客户的内外部=内部客户
     */
    public static final String SCENE_CODE_PO_LOGIC_RECEIPT = "PO_LOGIC_RECEIPT";
    /**
     * 财务单据: 负数应付单
     * 逻辑性采购退货出库且客户的内外部=内部客户
     */
    public static final String SCENE_CODE_PO_LOGIC_RETURN = "PO_LOGIC_RETURN";
    /**
     * 财务单据: 负数应收单
     * 逻辑性销售退货入库且客户的内外部=内部客户
     */
    public static final String SCENE_CODE_SO_LOGIC_RECEIPT = "SO_LOGIC_RECEIPT";

    /**
     * 生成财务单据标识 0未生成公司间应收单/应付单，1已经生成，2生成失败
     */
    public static final Integer FIN_INTER_FLAG_0 = 0;
    public static final Integer FIN_INTER_FLAG_1 = 1;
    public static final Integer FIN_INTER_FLAG_2 = 2;

    /**
     * 逻辑性采购入库/采购退货出库流水应付单类型代码
     */
    public static final String AP_TYPE_CODE_YFD05_SYS = "YFD05_SYS";

    public static final String AP_TYPE_CODE_YFD02_SYS = "YFD02_SYS";

    public static final String AGREEMENT_PROTOCOL_CODE = "AGREEMENT_PROTOCOL_CODE";

    public static final String AR_TYPE_CODE_YSD02_SYS = "YSD02_SYS";

    /**
     * 拟定
     */
    public static final String MANUAL_PROPOSED_TYPE_COMMON = "common";
    /**
     * 重新拟定
     */
    public static final String MANUAL_PROPOSED_TYPE_REPROPOSED = "reproposed";

    /**
     * 定时任务拟定
     */
    public static final String JOB_PROPOSED_TYPE_REPROPOSED = "job";


    public static final LocalTime LOCAL_TIME_MAX = LocalTime.of(23,59,59);

}
