package com.elitesland.fin.domain.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeConvert;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.expense.ExpType;
import com.elitesland.fin.domain.expense.ExpTypeDO;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @Auther: Mark
 * @Date: 2024/8/08 17:00
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ExpTypeDomainServiceImpl implements ExpTypeDomainService {

    private final ExpTypeRepo expTypeRepo;
    private final ExpTypeRepoProc expTypeRepoProc;
    private final ExpTypeDtlDomainService expTypeDtlDomainService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long save(ExpType expType) {
        expType.checkNotNull();
        expType.setDefaultValue();
        checkExpType(expType);
        // 编码和名称是否存在
        Boolean isExistName = expTypeRepoProc.existsName(expType.getExpTypeName());
        if (isExistName) {
            throw new BusinessException("费用类型名称已存在");
        }
        Boolean isExistCode = expTypeRepoProc.existsCode(expType.getExpTypeCode());
        if (isExistCode) {
            throw new BusinessException("费用类型编码已存在");
        }

        // 如果第一条新增，则为默认
       /* Boolean isFir = expTypeRepoProc.isFir();
        if (isFir) {
            expType.setDefaultFlag(true);
        }*/
        ExpTypeDO res = expTypeRepo.save(ExpTypeConvert.INSTANCE.convert(expType));
        Long masId = res.getId();

        //明细全删全插
        if (Objects.nonNull(expType.getId())) {
            expTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(expType.getId()));
        }

        if (CollectionUtil.isNotEmpty(expType.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expType.getDtlList();
            expTypeDtlList.forEach(expTypeDtl -> {
                expTypeDtl.setMasId(masId);
            });
            expTypeDtlDomainService.save(expTypeDtlList);
        }

        return masId;
    }

    @Override
    @SysCodeProc
    public ExpTypeDTO get(Long id) {
        ExpTypeDTO res = expTypeRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExpTypeDTO> page(ExpTypePageParam expTypePageParam) {
        List<Long> exptypeIds = new ArrayList<>();
        /*if (null != expTypePageParam.getOuId()) {
            artypeIds = expTypeOuRepoProc.queryByOuId(arTypePageParam.getOuId());
        }*/
        PagingVO<ExpTypeDTO> res = expTypeRepoProc.page(expTypePageParam, exptypeIds);
        return res;
    }

    @Override
    public List<ExpTypeDTO> findByIds(List<Long> ids) {
        List<ExpTypeDTO> res = expTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateEnableFlag(List<Long> ids, boolean enable) {
        expTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(Long id) {
        Assert.notNull(id, "id不能为空");
        // 启用状态和默认状态不能被删除
        ExpTypeDTO expTypeDTO = expTypeRepoProc.findById(id);
        if (expTypeDTO.getEnableFlag()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                    "只能删除未启用的数据");
        }
        Long res = expTypeRepoProc.del(id);
        return res;
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDTO> getList() {
        List<ExpTypeDTO> res = expTypeRepoProc.getList();
        return res;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long update(ExpType expType) {
        expType.checkNotNull();
        checkExpType(expType);
        Assert.notNull(expType.getEnableFlag(), "enableFlag is null");
        ExpTypeDO res = expTypeRepo.save(ExpTypeConvert.INSTANCE.convert(expType));

        Long masId = res.getId();

        //明细全删全插
        if (Objects.nonNull(expType.getId())) {
            expTypeDtlDomainService.deleteByIdBatch(Collections.singletonList(expType.getId()));
        }

        if (CollectionUtil.isNotEmpty(expType.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expType.getDtlList();
            expTypeDtlList.forEach(expTypeDtl -> {
                expTypeDtl.setMasId(masId);
            });
            expTypeDtlDomainService.save(expTypeDtlList);
        }

        return masId;
    }

    private void checkExpType(ExpType expType) {
        if (StrUtil.isBlank(expType.getItemCode())) {
            throw new BusinessException("商品不能为空");
        }
        //保存校验时  来源单据+来源单据类型+来源单据状态+分配的公司都重复时才报错
        /*List<ArTypeDtl> dtlList = expType.getDtlList();
        if (CollectionUtil.isEmpty(dtlList)) {
            return;
        }
        List<String> sourceDocList =
                dtlList.stream().map(ArTypeDtl::getSourceDoc).filter(Objects::nonNull).distinct().collect(Collectors
                .toList());
        List<String> sourceDocTypeList =
                dtlList.stream().map(ArTypeDtl::getSourceDocType).filter(Objects::nonNull).distinct().collect
                (Collectors.toList());
        List<String> sourceDocStatusList =
                dtlList.stream().map(ArTypeDtl::getSourceDocStatus).filter(Objects::nonNull).distinct().collect
                (Collectors.toList());
        ArTypeDtlPageParam arTypeDtlPageParam = new ArTypeDtlPageParam();
        arTypeDtlPageParam.setSourceDocList(sourceDocList);
        arTypeDtlPageParam.setSourceDocTypeList(sourceDocTypeList);
        arTypeDtlPageParam.setSourceDocStatusList(sourceDocStatusList);
        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDomainService.selectListByParam(arTypeDtlPageParam);
        if (CollectionUtil.isEmpty(arTypeDtlDTOList)) {
            return;
        }

        Map<String, List<ArTypeDtlDTO>> arTypeDtlListMap =
                arTypeDtlDTOList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(
                i.getSourceDoc(), i.getSourceDocType(), i.getSourceDocStatus())));

        //查公司,公司是保存后分配的，去掉
        List<Long> masIdList =
                arTypeDtlDTOList.stream().map(ArTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect
                (Collectors.toList());
        List<ArTypeDTO> arTypeDTOList = arTypeRepoProc.findByIds(masIdList);

        dtlList.forEach(arTypeDtl -> {
            String spliceGroupKey = arSpliceGroupKey(arTypeDtl.getSourceDoc(), arTypeDtl.getSourceDocType(),
                    arTypeDtl.getSourceDocStatus());
            List<ArTypeDtlDTO> spliceGroupList = arTypeDtlListMap.get(spliceGroupKey);
            if (CollectionUtil.isNotEmpty(spliceGroupList)) {
                List<Long> spliceGroupMasIdList =
                        spliceGroupList.stream().map(ArTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct()
                        .collect(Collectors.toList());
                Optional<ArTypeDTO> arTypeDTOOptional =
                        arTypeDTOList.stream().filter(arTypeDTO -> spliceGroupMasIdList.contains(arTypeDTO.getId())
                        && !Objects.equals(arTypeDTO.getId(), expType.getId())).findFirst();
                if (arTypeDTOOptional.isPresent()) {
                    throw new com.elitescloud.cloudt.common.exception.BusinessException("来源单据(" + arTypeDtl
                    .getSourceDoc() + ")-" +
                            "来源单据类型(" + arTypeDtl.getSourceDocType() + ")-" +
                            "来源单据状态(" + arTypeDtl.getSourceDocStatus() + ")与" +
                            "应收单类型配置(" + arTypeDTOOptional.get().getArTypeCode() + ")重复");
                }
            }
        });*/

    }

    private String arSpliceGroupKey(String sourceDoc, String sourceDocType, String sourceDocStatus) {
        String spliceGroupKey = sourceDoc + FinConstant.LINE_SPLIT +
                sourceDocType + FinConstant.LINE_SPLIT +
                sourceDocStatus;
        return spliceGroupKey;
    }
}
