/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderRpcFiledDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RecOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QRecOrderDO qRecOrderDO = QRecOrderDO.recOrderDO;
    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
    private final QRecOrderRpcFiledDO Q_REC_ORDER_FILE_DO = QRecOrderRpcFiledDO.recOrderRpcFiledDO;

    public List<RecOrderDO> findBySourceNo(String sourceNo) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qRecOrderDO).where((Predicate)this.qRecOrderDO.sourceNo.eq((Object)sourceNo))).fetch();
    }

    public List<RecOrderDO> findBySourceNoList(List<String> sourceNoList) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qRecOrderDO).where((Predicate)this.qRecOrderDO.sourceNo.in(sourceNoList))).fetch();
    }

    public PagingVO<RecOrderDTO> page(RecOrderPageParam param, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.buildPredicates(param, ids, predicates);
        this.pageWhere(param, predicates);
        JPAQuery query = (JPAQuery)this.select(RecOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, this.qRecOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private void pageWhere(RecOrderPageParam param, List<Predicate> predicates) {
        Predicate customFieldPredicate;
        if (param.getId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.id.eq((Object)param.getId()));
        }
        if (param.getBuDateStart() != null && param.getBuDateEnd() != null) {
            predicates.add((Predicate)this.qRecOrderDO.reDate.between((Comparable)param.getReDateStart(), (Comparable)param.getReDateEnd()));
        }
        if (param.getBuId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.buId.eq((Object)param.getBuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getBuIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.buId.in(param.getBuIdList()));
        }
        if (param.getOrgId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.orgId.eq((Object)param.getOrgId()));
        }
        if (param.getRedState() != null) {
            predicates.add((Predicate)this.qRecOrderDO.redState.eq(param.getRedState()));
        }
        if (param.getProposedStatus() != null) {
            predicates.add((Predicate)this.qRecOrderDO.proposedStatus.like("%" + param.getProposedStatus() + "%"));
        }
        if (param.getRedSourceNo() != null) {
            predicates.add((Predicate)this.qRecOrderDO.redSourceNo.like("%" + param.getRedSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getOrgIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.orgId.in(param.getOrgIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getRecOrderNo())) {
            predicates.add((Predicate)this.qRecOrderDO.recOrderNo.like("%" + param.getRecOrderNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOrderNoList())) {
            predicates.add((Predicate)this.qRecOrderDO.recOrderNo.in(param.getRecOrderNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getAuditUser())) {
            predicates.add((Predicate)this.qRecOrderDO.auditUser.like("%" + param.getAuditUser() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getAuditRejection())) {
            predicates.add((Predicate)this.qRecOrderDO.auditRejection.like("%" + param.getAuditRejection() + "%"));
        }
        if (param.getTotalAmtFrom() != null) {
            predicates.add((Predicate)this.qRecOrderDO.totalAmt.goe((Number)param.getTotalAmtFrom()));
        }
        if (param.getTotalAmtTo() != null) {
            predicates.add((Predicate)this.qRecOrderDO.totalAmt.loe((Number)param.getTotalAmtTo()));
        }
        if (param.getCustId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.custId.eq((Object)param.getCustId()));
        }
        if (CollectionUtils.isNotEmpty(param.getCustIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.custId.in(param.getCustIdList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getCustCode())) {
            predicates.add((Predicate)this.qRecOrderDO.custCode.eq((Object)param.getCustCode()));
        }
        if (CollectionUtil.isNotEmpty(param.getCustCodeList())) {
            predicates.add((Predicate)this.qRecOrderDO.custCode.in(param.getCustCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCustName())) {
            predicates.add((Predicate)this.qRecOrderDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getCustNameList())) {
            predicates.add((Predicate)this.qRecOrderDO.custName.in(param.getCustNameList()));
        }
        if (param.getRecTypeId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.recTypeId.eq((Object)param.getRecTypeId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecTypeIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.recTypeId.in(param.getRecTypeIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCreateMode())) {
            predicates.add((Predicate)this.qRecOrderDO.createMode.eq((Object)param.getCreateMode()));
        }
        if (ObjectUtil.isNotNull((Object)param.getRecOuId())) {
            predicates.add((Predicate)this.qRecOrderDO.recOuId.eq((Object)param.getRecOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOuIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.recOuId.in(param.getRecOuIdList()));
        }
        if (CollectionUtils.isNotEmpty(param.getIds())) {
            predicates.add((Predicate)this.qRecOrderDO.id.in(param.getIds()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)param.getConditions(), RecOrderDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        predicates.add((Predicate)this.qRecOrderDO.deleteFlag.eq((Object)0));
    }

    private void buildPredicates(RecOrderPageParam param, List<Long> ids, List<Predicate> predicates) {
        if (CollUtil.isNotEmpty(param.getInOutCustList())) {
            predicates.add((Predicate)this.qRecOrderDO.inOutCust.in(param.getInOutCustList()));
        }
        if (CollUtil.isNotEmpty(param.getRelevanceOuCodeList())) {
            predicates.add((Predicate)this.qRecOrderDO.relevanceOuCode.in(param.getRelevanceOuCodeList()));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add((Predicate)this.qRecOrderDO.id.in(ids));
        }
        if (param.getInitFlag() != null) {
            predicates.add((Predicate)this.qRecOrderDO.initFlag.eq(param.getInitFlag()));
        }
        if (param.getReFlag() != null) {
            predicates.add((Predicate)this.qRecOrderDO.reFlag.eq(param.getReFlag()));
        }
        if (param.getAuditDateStart() != null && param.getAuditDateEnd() != null) {
            predicates.add((Predicate)this.qRecOrderDO.auditDate.between((Comparable)param.getAuditDateStart(), (Comparable)param.getAuditDateEnd()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCurrCode())) {
            predicates.add((Predicate)this.qRecOrderDO.currCode.eq((Object)param.getCurrCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getCurrCodeList())) {
            predicates.add((Predicate)this.qRecOrderDO.currCode.in(param.getCurrCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getSaleUser())) {
            predicates.add((Predicate)this.qRecOrderDO.saleUser.like("%" + param.getSaleUser() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getSaleUserList())) {
            predicates.add((Predicate)this.qRecOrderDO.saleUser.in(param.getSaleUserList()));
        }
        if (CollectionUtils.isNotEmpty(param.getSaleUserIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.saleUserId.in(param.getSaleUserIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderState())) {
            predicates.add((Predicate)this.qRecOrderDO.orderState.eq((Object)param.getOrderState()));
        }
        if (CollectionUtils.isNotEmpty(param.getOrderStateList())) {
            predicates.add((Predicate)this.qRecOrderDO.orderState.in(param.getOrderStateList()));
        }
        if (param.getOuId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.ouId.eq((Object)param.getOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.ouId.in(param.getOuIdList()));
        }
        if (param.getExchangeRate() != null) {
            predicates.add((Predicate)this.qRecOrderDO.exchangeRate.eq((Object)param.getExchangeRate()));
        }
        if (param.getRecOuId() != null) {
            predicates.add((Predicate)this.qRecOrderDO.recOuId.eq((Object)param.getRecOuId()));
        }
        if (CollectionUtils.isNotEmpty(param.getRecOuIdList())) {
            predicates.add((Predicate)this.qRecOrderDO.recOuId.in(param.getRecOuIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)param.getVerState())) {
            predicates.add((Predicate)this.qRecOrderDO.verState.eq((Object)param.getVerState()));
        }
        if (CollectionUtils.isNotEmpty(param.getVerStateList())) {
            predicates.add((Predicate)this.qRecOrderDO.verState.in(param.getVerStateList()));
        }
        if (param.getAuditDateEnd() != null && param.getAuditDateStart() != null) {
            predicates.add((Predicate)this.qRecOrderDO.auditDate.between((Comparable)param.getAuditDateStart(), (Comparable)param.getAuditDateEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOuCode())) {
            predicates.add((Predicate)this.qRecOrderDO.ouCode.eq((Object)param.getOuCode()));
        }
        if (CollectionUtil.isNotEmpty(param.getOuCodeList())) {
            predicates.add((Predicate)this.qRecOrderDO.ouCode.in(param.getOuCodeList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSourceNo())) {
            predicates.add((Predicate)this.qRecOrderDO.sourceNo.eq((Object)param.getSourceNo()));
        }
    }

    public RecOrderDTO queryById(Long id) {
        return (RecOrderDTO)((JPAQuery)this.select(RecOrderDTO.class).where((Predicate)this.qRecOrderDO.id.eq((Object)id))).fetchOne();
    }

    public List<RecOrderDTO> queryByVerStatus(List<String> verStatus) {
        return ((JPAQuery)this.select(RecOrderDTO.class).where((Predicate)this.qRecOrderDO.verState.in(verStatus))).fetch();
    }

    public Long audit(List<Long> ids, String auditRejection, SysUserDTO user) {
        return this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).set(this.qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qRecOrderDO.auditRejection, (Object)auditRejection).set((Path)this.qRecOrderDO.auditUser, (Object)user.getUsername()).set(this.qRecOrderDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qRecOrderDO.id.in(ids)}).execute();
    }

    public List<RecOrderDTO> queryByIds(List<Long> ids) {
        return ((JPAQuery)this.select(RecOrderDTO.class).where((Predicate)this.qRecOrderDO.id.in(ids))).fetch();
    }

    public void deleteById(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qRecOrderDO).where(new Predicate[]{this.qRecOrderDO.id.in(ids)}).execute();
    }

    public List<RecOrderDTO> queryByRecTypeId(List<Long> recTypeId) {
        return ((JPAQuery)this.select(RecOrderDTO.class).where((Predicate)this.qRecOrderDO.recTypeId.in(recTypeId))).fetch();
    }

    public List<RecOrderDTO> getRecOrderList(RecOrderParam recOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)recOrderParam.getOuCode())) {
            predicates.add(this.qRecOrderDO.ouCode.eq((Object)recOrderParam.getOuCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)recOrderParam.getCustCode())) {
            predicates.add(this.qRecOrderDO.custCode.eq((Object)recOrderParam.getCustCode()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)recOrderParam.getCurrCode())) {
            predicates.add(this.qRecOrderDO.currCode.eq((Object)recOrderParam.getCurrCode()));
        }
        if (null != recOrderParam.getBuDateStart() && null != recOrderParam.getBuDateEnd()) {
            predicates.add(this.qRecOrderDO.reDate.between((Comparable)recOrderParam.getBuDateStart(), (Comparable)recOrderParam.getBuDateEnd()));
        }
        predicates.add(this.qRecOrderDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        List fetch = ((JPAQuery)this.select(RecOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
        return fetch;
    }

    public ArVerDTO queryVerAmtById(Long id) {
        return (ArVerDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ArVerDTO.class, (Expression[])new Expression[]{this.qRecOrderDO.id, this.qRecOrderDO.totalAmt, this.qRecOrderDO.verAmt, this.qRecOrderDO.auditDataVersion})).from((EntityPath)this.qRecOrderDO)).where((Predicate)this.qRecOrderDO.id.eq((Object)id))).fetchOne();
    }

    public long updateVerAmt(ArVerDTO arVerDTO) {
        return this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).set((Path)this.qRecOrderDO.verState, (Object)arVerDTO.getVerState()).set(this.qRecOrderDO.verAmt, (Object)arVerDTO.getVerAmt()).set(this.qRecOrderDO.auditDataVersion, (Object)(arVerDTO.getAuditDataVersion() + 1)).where(new Predicate[]{this.qRecOrderDO.id.eq((Object)arVerDTO.getId()).and((Predicate)this.qRecOrderDO.totalAmt.goe((Number)arVerDTO.getVerAmt())).and((Predicate)this.qRecOrderDO.auditDataVersion.eq((Object)arVerDTO.getAuditDataVersion()))}).execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qRecOrderDO.id, this.qRecOrderDO.sourceNo, this.qRecOrderDO.ouCode, this.qRecOrderDO.ouId, this.qRecOrderDO.ouName, this.qRecOrderDO.arTypeId, this.qRecOrderDO.arTypeName, this.qRecOrderDO.arTypeCode, this.qRecOrderDO.recTypeId, this.qRecOrderDO.recTypeCode, this.qRecOrderDO.recTypeName, this.qRecOrderDO.recOrderNo, this.qRecOrderDO.currCode, this.qRecOrderDO.currName, this.qRecOrderDO.localCurrCode, this.qRecOrderDO.localCurrName, this.qRecOrderDO.totalAmt, this.qRecOrderDO.totalCurAmt, this.qRecOrderDO.auditUserId, this.qRecOrderDO.auditUser, this.qRecOrderDO.auditDate, this.qRecOrderDO.orderState, this.qRecOrderDO.exchangeRate, this.qRecOrderDO.initFlag, this.qRecOrderDO.realRecAmt, this.qRecOrderDO.realRecCurAmt, this.qRecOrderDO.reDate, this.qRecOrderDO.reFlag, this.qRecOrderDO.auditRejection, this.qRecOrderDO.createMode, this.qRecOrderDO.verState, this.qRecOrderDO.verAmt, this.qRecOrderDO.custId, this.qRecOrderDO.custCode, this.qRecOrderDO.custName, this.qRecOrderDO.buId, this.qRecOrderDO.buCode, this.qRecOrderDO.buName, this.qRecOrderDO.recOuCode, this.qRecOrderDO.recOuId, this.qRecOrderDO.recOuName, this.qRecOrderDO.orgCode, this.qRecOrderDO.orgId, this.qRecOrderDO.orgName, this.qRecOrderDO.taxAmt, this.qRecOrderDO.recOrderType, this.qRecOrderDO.saleUserId, this.qRecOrderDO.saleUser, this.qRecOrderDO.creator, this.qRecOrderDO.remark, this.qRecOrderDO.createUserId, this.qRecOrderDO.taxCurAmt, this.qRecOrderDO.createTime, this.qRecOrderDO.modifyTime, this.qRecOrderDO.updater, this.qRecOrderDO.auditDataVersion, this.qRecOrderDO.procInstId, this.qRecOrderDO.procInstStatus, this.qRecOrderDO.approvedTime, this.qRecOrderDO.submitTime, this.qRecOrderDO.addrNo, this.qRecOrderDO.suppAddrNo, this.qRecOrderDO.docType, this.qRecOrderDO.docType2, this.qRecOrderDO.workflowProcInstId, this.qRecOrderDO.workflowProcInstStatus, this.Q_REC_ORDER_FILE_DO.applyFile, this.qRecOrderDO.docCls, this.qRecOrderDO.redState, this.qRecOrderDO.redSourceId, this.qRecOrderDO.redSourceNo, this.qRecOrderDO.proposedStatus, this.qRecOrderDO.inOutCust, this.qRecOrderDO.relevanceOuCode, this.qRecOrderDO.custType2, this.qRecOrderDO.extensionInfo})).from((EntityPath)this.qRecOrderDO)).leftJoin((EntityPath)this.Q_REC_ORDER_FILE_DO)).on((Predicate)this.qRecOrderDO.id.eq(this.Q_REC_ORDER_FILE_DO.masId));
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).set(this.qRecOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qRecOrderDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qRecOrderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qRecOrderDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qRecOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).setNull((Path)this.qRecOrderDO.redState).where(new Predicate[]{this.qRecOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).set((Path)this.qRecOrderDO.redState, (Object)flag).where(new Predicate[]{this.qRecOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public PagingVO<RecOrderEntity> defaultExport(RecOrderPageParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.buildPredicates(param, null, predicates);
        this.pageWhere(param, predicates);
        if (StringUtils.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            QRecOrderDtlDO recOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
            predicates.add((Predicate)this.qRecOrderDO.id.in((SubQueryExpression)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(recOrderDtlDO.masId).from((EntityPath)recOrderDtlDO)).where((Predicate)recOrderDtlDO.sourceNo.like("%" + param.getSourceNoDtl() + "%"))).groupBy(recOrderDtlDO.masId)));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(RecOrderEntity.class, (Expression[])new Expression[]{this.qRecOrderDO.sourceNo, this.qRecOrderDO.ouCode, this.qRecOrderDO.ouName, this.qRecOrderDO.arTypeName, this.qRecOrderDO.arTypeCode, this.qRecOrderDO.recTypeCode, this.qRecOrderDO.recTypeName, this.qRecOrderDO.recOrderNo, this.qRecOrderDO.currCode, this.qRecOrderDO.currName, this.qRecOrderDO.localCurrCode, this.qRecOrderDO.localCurrName, this.qRecOrderDO.totalAmt, this.qRecOrderDO.totalCurAmt, this.qRecOrderDO.auditUserId, this.qRecOrderDO.auditUser, this.qRecOrderDO.auditDate, this.qRecOrderDO.orderState, this.qRecOrderDO.exchangeRate, this.qRecOrderDO.initFlag, this.qRecOrderDO.realRecAmt, this.qRecOrderDO.realRecCurAmt, this.qRecOrderDO.reDate, this.qRecOrderDO.reFlag, this.qRecOrderDO.auditRejection, this.qRecOrderDO.createMode, this.qRecOrderDO.verState, this.qRecOrderDO.verAmt, this.qRecOrderDO.custId, this.qRecOrderDO.custCode, this.qRecOrderDO.custName, this.qRecOrderDO.buCode, this.qRecOrderDO.buName, this.qRecOrderDO.recOuCode, this.qRecOrderDO.recOuName, this.qRecOrderDO.orgCode, this.qRecOrderDO.orgName, this.qRecOrderDO.taxAmt, this.qRecOrderDO.recOrderType, this.qRecOrderDO.saleUser, this.qRecOrderDO.creator, this.qRecOrderDO.remark, this.qRecOrderDO.taxCurAmt, this.qRecOrderDO.createTime, this.qRecOrderDO.modifyTime, this.qRecOrderDO.updater, this.qRecOrderDO.auditDataVersion, this.qRecOrderDO.procInstStatus, this.qRecOrderDO.approvedTime, this.qRecOrderDO.submitTime, this.qRecOrderDO.addrNo, this.qRecOrderDO.suppAddrNo, this.qRecOrderDO.docType, this.qRecOrderDO.docType2, this.Q_REC_ORDER_FILE_DO.applyFile, this.qRecOrderDO.docCls, this.qRecOrderDO.redState, this.qRecOrderDO.redSourceNo, this.qRecOrderDO.proposedStatus, this.qRecOrderDO.totalAmt.subtract(this.qRecOrderDO.verAmt).as("unVerAmt"), this.qRecOrderDO.extensionInfo})).from((EntityPath)this.qRecOrderDO)).leftJoin((EntityPath)this.Q_REC_ORDER_FILE_DO)).on((Predicate)this.qRecOrderDO.id.eq(this.Q_REC_ORDER_FILE_DO.masId))).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.qRecOrderDO);
        param.setPaging(query);
        return new PagingVO(query.fetchCount(), query.fetch());
    }

    public List<RecOrderDTO> selectInOutCustByRecOrderNo(List<String> recOrderNoList) {
        if (CollectionUtil.isEmpty(recOrderNoList)) {
            return Collections.EMPTY_LIST;
        }
        List recOrderDTOList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(RecOrderDTO.class, (Expression[])new Expression[]{this.qRecOrderDO.recOrderNo, this.qRecOrderDO.inOutCust, this.qRecOrderDO.relevanceOuCode})).from((EntityPath)this.qRecOrderDO)).where((Predicate)this.qRecOrderDO.recOrderNo.in(recOrderNoList))).fetch();
        return recOrderDTOList;
    }

    public void updateVerState(String verState, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qRecOrderDO).set((Path)this.qRecOrderDO.verState, (Object)verState).where(new Predicate[]{this.qRecOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public Long countExportRecOrder(RecOrderPageParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qRecOrderDtlDO.count()).from((EntityPath)this.qRecOrderDtlDO)).leftJoin((EntityPath)this.qRecOrderDO)).on((Predicate)this.qRecOrderDtlDO.masId.eq(this.qRecOrderDO.id));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.pageWhere(param, predicates);
        this.buildPredicates(param, null, predicates);
        if (StrUtil.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            predicates.add((Predicate)this.qRecOrderDtlDO.sourceNo.eq((Object)param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qRecOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchCount();
    }

    public List<RecOrderEntity> exportRecOrder(RecOrderPageParam param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(RecOrderEntity.class, (Expression[])new Expression[]{this.qRecOrderDO.id, this.qRecOrderDO.sourceNo, this.qRecOrderDO.ouCode, this.qRecOrderDO.ouId, this.qRecOrderDO.ouName, this.qRecOrderDO.arTypeName, this.qRecOrderDO.arTypeCode, this.qRecOrderDO.recTypeCode, this.qRecOrderDO.recTypeName, this.qRecOrderDO.recOrderNo, this.qRecOrderDO.currCode, this.qRecOrderDO.currName, this.qRecOrderDO.totalAmt, this.qRecOrderDO.totalCurAmt, this.qRecOrderDO.auditUserId, this.qRecOrderDO.auditUser, this.qRecOrderDO.auditDate, this.qRecOrderDO.orderState, this.qRecOrderDO.exchangeRate, this.qRecOrderDO.initFlag, this.qRecOrderDO.realRecAmt, this.qRecOrderDO.reDate, this.qRecOrderDO.reFlag, this.qRecOrderDO.createMode, this.qRecOrderDO.verState, this.qRecOrderDO.verAmt, this.qRecOrderDO.custCode, this.qRecOrderDO.custName, this.qRecOrderDO.buCode, this.qRecOrderDO.buName, this.qRecOrderDO.recOuCode, this.qRecOrderDO.recOuName, this.qRecOrderDO.orgCode, this.qRecOrderDO.orgName, this.qRecOrderDO.taxAmt, this.qRecOrderDO.recOrderType, this.qRecOrderDO.saleUser, this.qRecOrderDO.creator, this.qRecOrderDO.remark, this.qRecOrderDO.taxCurAmt, this.qRecOrderDO.createTime, this.qRecOrderDO.modifyTime, this.qRecOrderDO.updater, this.qRecOrderDO.procInstStatus, this.qRecOrderDO.approvedTime, this.qRecOrderDO.submitTime, this.qRecOrderDO.docType, this.qRecOrderDO.docCls, this.qRecOrderDO.redState, this.qRecOrderDO.redSourceNo, this.qRecOrderDO.proposedStatus, this.qRecOrderDO.inOutCust, this.qRecOrderDO.relevanceOuCode, this.qRecOrderDO.custType2, this.qRecOrderDtlDO.sourceNo.as("detailSourceNo"), this.qRecOrderDtlDO.sourceLine, this.qRecOrderDtlDO.recKind, this.qRecOrderDtlDO.recType, this.qRecOrderDtlDO.recAccount, this.qRecOrderDtlDO.es16, this.qRecOrderDtlDO.es17, this.qRecOrderDtlDO.recBank, this.qRecOrderDtlDO.recAccount, this.qRecOrderDtlDO.totalAmt.as("detailTotalAmt"), this.qRecOrderDtlDO.realRecAmt.as("detailRealRecAmt"), this.qRecOrderDtlDO.verAmt, this.qRecOrderDtlDO.unVerAmt, this.qRecOrderDtlDO.applyVerAmTing})).from((EntityPath)this.qRecOrderDtlDO)).leftJoin((EntityPath)this.qRecOrderDO)).on((Predicate)this.qRecOrderDtlDO.masId.eq(this.qRecOrderDO.id));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.pageWhere(param, predicates);
        this.buildPredicates(param, null, predicates);
        if (StrUtil.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            predicates.add((Predicate)this.qRecOrderDtlDO.sourceNo.eq((Object)param.getSourceNoDtl()));
        }
        if (CollUtil.isNotEmpty(param.getDtlSourceNoList())) {
            predicates.add((Predicate)this.qRecOrderDtlDO.sourceNo.in(param.getDtlSourceNoList()));
        }
        param.setPaging(jpaQuery);
        param.fillOrders(jpaQuery, this.qRecOrderDtlDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public RecOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

