package com.elitesland.fin.application.convert.payorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface PayOrderConvert {

    PayOrderConvert INSTANCE = Mappers.getMapper(PayOrderConvert.class);

    PagingVO<PayOrderVO> convertPage(PagingVO<PayOrderDTO> payOrderDTO);

    @Mapping(target = "payOrderDtlVOList", source = "payOrderDtlVOList")
    PayOrderVO dtoToVo(PayOrderDTO dto);

    @Mapping(source = "payOrderDtlSaveParams", target = "dtlList")
    PayOrder convertParam(PayOrderSaveParam param);

    PayOrderDO convertToDo(PayOrder payOrder);

    List<PayOrderVO> dtoListToVO(List<PayOrderDTO> dtoList);

    @Mapping(source = "payOrderDtlRpcDTOList", target = "dtlList")
    PayOrder convertRpc(PayOrderRpcParam payOrderRpcParam);

    PayOrderPageParam convertPageParamRpc(PayOrderPageRpcParam payOrderPageRpcParam);

    PagingVO<PayOrderRpcDTO> convertRpcDto(PagingVO<PayOrderDTO> res);
}
