package com.elitesland.fin.application.facade.excel.creditaccount;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 信用账户导入实体类
 */
@Data
public class CreditAccountImportEntity implements Serializable {
    private static final long serialVersionUID = 6516605491117978659L;

    @ExcelProperty(index = 0)
    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("对象类型(客户组 客户)")
    @ExcelProperty(index = 1)
    private String objectTypeName;

    @ApiModelProperty("对象编码")
    @ExcelProperty(index = 2)
    private String objectCode;

    @ApiModelProperty("部门编码")
    @ExcelProperty(index = 3)
    private String deptCode;

    @ApiModelProperty("产品线编码")
    @ExcelProperty(index = 4)
    private String productLineCode;

    @ApiModelProperty("业务员编号")
    @ExcelProperty(index = 5)
    private String salesmanNo;

    @ApiModelProperty("信用账户名称")
    @ExcelProperty(index = 6)
    private String creditAccountName;

    @ApiModelProperty("信用账户类型")
    @ExcelProperty(index = 7)
    private String creditAccountTypeName;

    @ApiModelProperty("备注")
    @ExcelProperty(index = 8)
    private String remark;

    @ApiModelProperty("公司ID")
    @ExcelIgnore
    private Long ouId;

    @ApiModelProperty("公司名称")
    @ExcelIgnore
    private String ouName;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    @ExcelIgnore
    private String objectName;

    @ApiModelProperty("信用账户编码")
    @ExcelIgnore
    private String creditAccountCode;

    @ApiModelProperty("对象类型")
    @ExcelIgnore
    private String objectType;

    @ApiModelProperty("信用账户类型")
    @ExcelIgnore
    private String creditAccountType;
}
