package com.elitesland.fin.application.facade.param.creditaccount;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "信用账户分页查询参数")
public class CreditAccountPageParam extends AbstractOrderQueryParam{

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("对象类型(客户组 客户)")
    private String objectType;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("信用账户编码/名称")
    private String creditAccountCodeName;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimitStart;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimitEnd;

    @ApiModelProperty("ids")
    private List<Long> ids;

}