package com.elitesland.fin.application.service.excel.entity;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

@ApiModel(value = "账户报表", description = "账户报表")
@Data
public class AccountReportExportEntity implements Serializable {

    @ExcelProperty(value = "销售公司", index = 0)
    private String ouName;

    @ExcelProperty(value = "主客户编码", index = 1)
    private String custCode;

    @ExcelProperty(value = "主客户名称", index = 2)
    private String custName;

    @ExcelProperty(value = "可用金额", index = 3)
    private BigDecimal availableAmount;

    @ExcelProperty(value = "未汇款金额", index = 4)
    private BigDecimal unremittedAmount;

    @ExcelProperty(value = "账户额度", index = 5)
    private BigDecimal creditAccountLimit;

    @ExcelProperty(value = "账户使用额度", index = 6)
    private BigDecimal creditAccountUsedLimit;

    @ExcelProperty(value = "占用额度", index = 7)
    private BigDecimal creditAccountOccupancyLimit;

    @ExcelProperty(value = "可用额度", index = 8)
    private BigDecimal creditAccountAvailableLimit;

    @ExcelProperty(value = "储值账户金额", index = 9)
    private BigDecimal storageAccountAmount;

    @ExcelProperty(value = "储值账户占用金额", index = 10)
    private BigDecimal storageAccountOccupancyAmount;

    @ExcelProperty(value = "储值账户可用金额", index = 11)
    private BigDecimal storageAccountAvailableAmount;

    @ExcelProperty(value = "返利账户金额", index = 12)
    private BigDecimal rebateAccountAmount;

    @ExcelProperty(value = "返利账户占用金额", index = 13)
    private BigDecimal rebateAccountOccupancyAmount;

    @ExcelProperty(value = "返利账户可用金额", index = 14)
    private BigDecimal rebateAccountAvailableAmount;
}
