package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSobAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSobAccountPeriodVO;
import com.elitesland.fin.application.service.accountingengine.FinSobAccountPeriodService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/period/control")
@RequiredArgsConstructor
@Api(value = "会计期间控制", tags = {"会计期间控制"})
public class FinSobAccountPeriodController {

    private final FinSobAccountPeriodService finSobAccountPeriodService;

    @PostMapping("generate")
    @ApiOperation("生成")
    public ApiResult<Void> generate(@RequestBody FinSobAccountPeriodParam finSobAccountPeriodParam) {
        finSobAccountPeriodService.generate(finSobAccountPeriodParam);
        return ApiResult.ok();
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinSobAccountPeriodVO>> page(@RequestBody FinSobAccountPeriodParam finSobAccountPeriodParam) {
        return ApiResult.ok(finSobAccountPeriodService.page(finSobAccountPeriodParam));
    }

    @PostMapping("openOrClose")
    @ApiOperation("打开/关闭")
    public ApiResult<Void> openOrClose(@RequestBody FinSobAccountPeriodParam finSobAccountPeriodParam) {
        finSobAccountPeriodService.openOrClose(finSobAccountPeriodParam);
        return ApiResult.ok();
    }


}
